/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.http;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.SessionCenter;
import anet.channel.entity.ENV;
import anet.channel.util.ALog;
import anet.channel.util.Utils;
import anetwork.channel.config.NetworkConfigCenter;
import anetwork.channel.cookie.CookieManager;
import anetwork.channel.monitor.Monitor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class NetworkSdkSetting
implements Serializable {
    private static final String TAG = "anet.NetworkSdkSetting";
    public static ENV CURRENT_ENV = ENV.ONLINE;
    private static AtomicBoolean isInit = new AtomicBoolean(false);
    private static Context context;
    private static HashMap<String, Object> initParams;

    public static void init(Context context) {
        if (context == null) {
            return;
        }
        try {
            if (isInit.compareAndSet(false, true)) {
                ALog.e(TAG, "NetworkSdkSetting init", null, new Object[0]);
                NetworkSdkSetting.context = context;
                GlobalAppRuntimeInfo.setContext(context);
                NetworkSdkSetting.initTaobaoAdapter();
                Monitor.init();
                NetworkConfigCenter.init();
                CookieManager.setup(context);
                SessionCenter.init(context);
            }
            return;
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "Network SDK initial failed!", null, throwable, new Object[0]);
            return;
        }
    }

    public static void init(Application application, HashMap<String, Object> hashMap) {
        try {
            GlobalAppRuntimeInfo.setTtid((String)hashMap.get("ttid"));
            GlobalAppRuntimeInfo.setUtdid((String)hashMap.get("deviceId"));
            String string = (String)hashMap.get("process");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                GlobalAppRuntimeInfo.setCurrentProcess(string);
            }
            initParams = new HashMap<String, Object>(hashMap);
            NetworkSdkSetting.init(application.getApplicationContext());
            initParams = null;
            return;
        }
        catch (Exception exception) {
            ALog.e(TAG, "Network SDK initial failed!", null, exception, new Object[0]);
            return;
        }
    }

    public static void setTtid(String string) {
        GlobalAppRuntimeInfo.setTtid(string);
    }

    public static Context getContext() {
        return context;
    }

    private static void initTaobaoAdapter() {
        try {
            Utils.invokeStaticMethodThrowException("anet.channel.TaobaoNetworkAdapter", "init", new Class[]{Context.class, HashMap.class}, context, initParams);
            ALog.i(TAG, "init taobao adapter success", null, new Object[0]);
            return;
        }
        catch (Exception exception) {
            ALog.i(TAG, "initTaobaoAdapter failed. maybe not taobao app", null, exception);
            return;
        }
    }

    static {
        initParams = null;
    }
}

