/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.text.TextUtils;
import android.util.Log;

public class ALog {
    public static Logcat logcat = new Logcat();
    private static volatile ILog log = logcat;
    private static Object LOG_BREAK = "|";
    private static boolean isPrintLog = true;
    private static boolean canUseTlog = true;

    public static void setLog(ILog iLog) {
        if (iLog == null) {
            return;
        }
        if (!canUseTlog && iLog.getClass().getSimpleName().toLowerCase().contains("tlog")) {
            return;
        }
        if (!iLog.isValid()) {
            return;
        }
        log = iLog;
    }

    public static ILog getLog() {
        return log;
    }

    public static void setPrintLog(boolean bl) {
        isPrintLog = bl;
    }

    public static void setLevel(int n2) {
        if (log != null) {
            log.setLogLevel(n2);
        }
    }

    public static boolean isPrintLog(int n2) {
        if (!isPrintLog) {
            return false;
        }
        if (log != null) {
            return log.isPrintLog(n2);
        }
        return false;
    }

    public static void d(String string, String string2, String string3, Object ... objectArray) {
        if (ALog.isPrintLog(1) && log != null) {
            log.d(ALog.buildLogTag(string), ALog.buildLogMsg(string2, string3, objectArray));
        }
    }

    public static void i(String string, String string2, String string3, Object ... objectArray) {
        if (ALog.isPrintLog(2) && log != null) {
            log.i(ALog.buildLogTag(string), ALog.buildLogMsg(string2, string3, objectArray));
        }
    }

    public static void w(String string, String string2, String string3, Object ... objectArray) {
        if (ALog.isPrintLog(3) && log != null) {
            log.w(ALog.buildLogTag(string), ALog.buildLogMsg(string2, string3, objectArray));
        }
    }

    public static void w(String string, String string2, String string3, Throwable throwable, Object ... objectArray) {
        if (ALog.isPrintLog(3) && log != null) {
            log.w(ALog.buildLogTag(string), ALog.buildLogMsg(string2, string3, objectArray), throwable);
        }
    }

    public static void e(String string, String string2, String string3, Object ... objectArray) {
        if (ALog.isPrintLog(4) && log != null) {
            log.e(ALog.buildLogTag(string), ALog.buildLogMsg(string2, string3, objectArray));
        }
    }

    public static void e(String string, String string2, String string3, Throwable throwable, Object ... objectArray) {
        if (ALog.isPrintLog(4) && log != null) {
            log.e(ALog.buildLogTag(string), ALog.buildLogMsg(string2, string3, objectArray), throwable);
        }
    }

    private static String buildLogTag(String string) {
        return string;
    }

    private static String buildLogMsg(String string, String string2, Object ... objectArray) {
        if (string == null && string2 == null && objectArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(LOG_BREAK).append("[seq:").append(string2).append("]");
        }
        if (string != null) {
            stringBuilder.append(" ").append(string);
        }
        if (objectArray != null) {
            int n2 = 0;
            while (n2 + 1 < objectArray.length) {
                stringBuilder.append(" ").append(objectArray[n2] != null ? objectArray[n2] : "").append(":").append(objectArray[n2 + 1] != null ? objectArray[n2 + 1] : "");
                n2 += 2;
            }
            if (n2 < objectArray.length) {
                stringBuilder.append(" ");
                stringBuilder.append(objectArray[n2]);
            }
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static void setUseTlog(boolean bl) {
        if (!bl) {
            canUseTlog = false;
            log = logcat;
            return;
        }
        canUseTlog = true;
    }

    public static class Logcat
    implements ILog {
        int defaultLevel = 1;

        @Override
        public void d(String string, String string2) {
            Log.d((String)string, (String)string2);
        }

        @Override
        public void i(String string, String string2) {
            Log.i((String)string, (String)string2);
        }

        @Override
        public void w(String string, String string2) {
            Log.w((String)string, (String)string2);
        }

        @Override
        public void w(String string, String string2, Throwable throwable) {
            Log.w((String)string, (String)string2, (Throwable)throwable);
        }

        @Override
        public void e(String string, String string2) {
            Log.e((String)string, (String)string2);
        }

        @Override
        public void e(String string, String string2, Throwable throwable) {
            Log.e((String)string, (String)string2, (Throwable)throwable);
        }

        @Override
        public boolean isPrintLog(int n2) {
            return n2 >= this.defaultLevel;
        }

        @Override
        public void setLogLevel(int n2) {
            if (n2 < 0 || n2 > 5) {
                this.defaultLevel = 5;
                return;
            }
            this.defaultLevel = n2;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static class Level {
        public static final int V = 0;
        public static final int D = 1;
        public static final int I = 2;
        public static final int W = 3;
        public static final int E = 4;
        public static final int N = 5;
    }

    public static interface ILog {
        public void d(String var1, String var2);

        public void i(String var1, String var2);

        public void w(String var1, String var2);

        public void w(String var1, String var2, Throwable var3);

        public void e(String var1, String var2);

        public void e(String var1, String var2, Throwable var3);

        public boolean isPrintLog(int var1);

        public void setLogLevel(int var1);

        public boolean isValid();
    }
}

