/*
 * Decompiled with CFR 0.152.
 */
package com.igexin.sdk;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import com.igexin.b.a.c.b;
import com.igexin.sdk.GTIntentService$JobIntentService;
import com.igexin.sdk.c;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.GTNotificationMessage;
import com.igexin.sdk.message.GTTransmitMessage;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class GTIntentService
extends Service {
    public static final String TAG = "GTIntentService";
    public static final long WAIT_TIME = 30000L;
    private BlockingQueue<Intent> messageQueue;
    private Service mService;
    private volatile Looper mServiceLooper;
    private volatile c mServiceHandler;

    public void onCreate() {
        super.onCreate();
        HandlerThread handlerThread = new HandlerThread("IntentService[GTJob]");
        handlerThread.start();
        this.mServiceLooper = handlerThread.getLooper();
        this.mServiceHandler = new c(this, this.mServiceLooper, null);
        if (Build.VERSION.SDK_INT >= 26) {
            this.mService = new GTIntentService$JobIntentService(this, this);
        }
    }

    public IBinder onBind(Intent intent) {
        return this.mService == null ? null : this.mService.onBind(intent);
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        try {
            if (this.messageQueue == null) {
                this.messageQueue = new LinkedBlockingQueue<Intent>();
            }
            this.messageQueue.offer(intent);
            Message message = this.mServiceHandler.obtainMessage();
            message.arg1 = n3;
            message.obj = intent;
            this.mServiceHandler.sendMessage(message);
        }
        catch (Throwable throwable) {
            b.a("GTIntentService|" + throwable.toString());
        }
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mServiceLooper.quit();
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            this.processOnHandleIntent(intent);
            if (this.messageQueue != null) {
                this.messageQueue.remove(intent);
                this.messageQueue.poll(30000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable throwable) {
            b.a("GTIntentService|" + throwable.toString());
        }
    }

    private void processOnHandleIntent(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null || bundle.get("action") == null || !(bundle.get("action") instanceof Integer)) {
            return;
        }
        switch (bundle.getInt("action")) {
            case 10001: {
                this.onReceiveMessageData((Context)this, (GTTransmitMessage)intent.getSerializableExtra("transmit_data"));
                break;
            }
            case 10002: {
                this.onReceiveClientId((Context)this, bundle.getString("clientid"));
                break;
            }
            case 10007: {
                this.onReceiveOnlineState((Context)this, bundle.getBoolean("onlineState"));
                break;
            }
            case 10008: {
                this.onReceiveServicePid((Context)this, bundle.getInt("pid"));
                break;
            }
            case 10010: {
                this.onReceiveCommandResult((Context)this, (GTCmdMessage)intent.getSerializableExtra("cmd_msg"));
                break;
            }
            case 10011: {
                this.onNotificationMessageArrived((Context)this, (GTNotificationMessage)intent.getSerializableExtra("notification_arrived"));
                break;
            }
            case 10012: {
                this.onNotificationMessageClicked((Context)this, (GTNotificationMessage)intent.getSerializableExtra("notification_clicked"));
                break;
            }
        }
    }

    public abstract void onReceiveServicePid(Context var1, int var2);

    public abstract void onReceiveClientId(Context var1, String var2);

    public abstract void onReceiveMessageData(Context var1, GTTransmitMessage var2);

    public abstract void onReceiveOnlineState(Context var1, boolean var2);

    public abstract void onReceiveCommandResult(Context var1, GTCmdMessage var2);

    public abstract void onNotificationMessageArrived(Context var1, GTNotificationMessage var2);

    public abstract void onNotificationMessageClicked(Context var1, GTNotificationMessage var2);

    static /* synthetic */ c access$100(GTIntentService gTIntentService) {
        return gTIntentService.mServiceHandler;
    }
}

