/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl.adapter;

import android.os.Build;
import android.os.RemoteException;
import anet.channel.util.d;
import anetwork.channel.NetworkCallBack;
import anetwork.channel.NetworkEvent;
import anetwork.channel.aidl.Connection;
import anetwork.channel.aidl.ParcelableFuture;
import anetwork.channel.aidl.ParcelableInputStream;
import anetwork.channel.aidl.adapter.ParcelableInputStreamImpl;
import anetwork.channel.entity.i;
import anetwork.channel.statist.StatisticData;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ConnectionDelegate
extends Connection.Stub
implements NetworkCallBack.FinishListener,
NetworkCallBack.InputStreamListener,
NetworkCallBack.ResponseCodeListener {
    private ParcelableInputStreamImpl inputStream;
    private int statusCode;
    private String desc;
    private Map<String, List<String>> header;
    private StatisticData statisticData;
    private CountDownLatch statusLatch = new CountDownLatch(1);
    private CountDownLatch streamLatch = new CountDownLatch(1);
    private ParcelableFuture future;
    private i config;

    public ConnectionDelegate(int n2) {
        this.statusCode = n2;
        this.desc = d.a(n2);
    }

    public ConnectionDelegate(i i2) {
        this.config = i2;
    }

    @Override
    public String getDesc() throws RemoteException {
        this.waitCountDownLatch(this.statusLatch);
        return this.desc;
    }

    public StatisticData getStatisticData() {
        return this.statisticData;
    }

    @Override
    public ParcelableInputStream getInputStream() throws RemoteException {
        this.waitCountDownLatch(this.streamLatch);
        return this.inputStream;
    }

    @Override
    public int getStatusCode() throws RemoteException {
        this.waitCountDownLatch(this.statusLatch);
        return this.statusCode;
    }

    @Override
    public Map<String, List<String>> getConnHeadFields() throws RemoteException {
        this.waitCountDownLatch(this.statusLatch);
        return this.header;
    }

    @Override
    public void cancel() throws RemoteException {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public void setFuture(ParcelableFuture parcelableFuture) {
        this.future = parcelableFuture;
    }

    @Override
    public void onFinished(NetworkEvent.FinishEvent finishEvent, Object object) {
        if (this.inputStream != null) {
            this.inputStream.writeEnd();
        }
        this.statusCode = finishEvent.getHttpCode();
        this.desc = finishEvent.getDesc() != null ? finishEvent.getDesc() : d.a(this.statusCode);
        this.statisticData = finishEvent.getStatisticData();
        this.streamLatch.countDown();
        this.statusLatch.countDown();
    }

    private void waitCountDownLatch(CountDownLatch countDownLatch) throws RemoteException {
        try {
            if (!countDownLatch.await(this.config.e(), TimeUnit.MILLISECONDS)) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
                throw this.buildRemoteException("wait time out");
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            throw this.buildRemoteException("thread interrupt");
        }
    }

    private RemoteException buildRemoteException(String string) {
        if (Build.VERSION.SDK_INT >= 15) {
            return new RemoteException(string);
        }
        return new RemoteException();
    }

    @Override
    public boolean onResponseCode(int n2, Map<String, List<String>> map, Object object) {
        this.statusCode = n2;
        this.desc = d.a(this.statusCode);
        this.header = map;
        this.statusLatch.countDown();
        return false;
    }

    @Override
    public void onInputStreamGet(ParcelableInputStream parcelableInputStream, Object object) {
        this.inputStream = (ParcelableInputStreamImpl)parcelableInputStream;
        this.streamLatch.countDown();
    }
}

