/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.rogers.receiver;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.fshows.android.rogers.manager.HuaWeiPushManager;
import com.fshows.android.rogers.manager.PushChannel;
import com.fshows.android.rogers.mix.MixPushMessage;
import com.fshows.android.rogers.push.IPushChannel;
import com.huawei.hms.support.api.push.PushReceiver;
import org.json.JSONArray;
import org.json.JSONObject;

public class HuaWeiMessageReceiver
extends PushReceiver
implements IPushChannel {
    private static final String TAG = HuaWeiMessageReceiver.class.getSimpleName();

    @Override
    public String getPushName() {
        return PushChannel.huawei.name();
    }

    public void onToken(Context context, String token, Bundle bundle) {
        super.onToken(context, token, bundle);
        Log.d((String)TAG, (String)("register is success: " + token));
        MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
        mixPushMessage.setCid(token);
        HuaWeiPushManager.sMixMessageProvider.onReceiveClientId(context, mixPushMessage);
    }

    public boolean onPushMsg(Context context, byte[] bytes, Bundle bundle) {
        try {
            String msg = new String(bytes, "UTF-8");
            Log.e((String)TAG, (String)("onPushMsg: " + msg));
            JSONObject msgObject = new JSONObject(msg);
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            mixPushMessage.setContent(msgObject.getString("extend_content"));
            HuaWeiPushManager.sMixMessageProvider.onReceivePassThroughMessage(context, mixPushMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void onEvent(Context context, PushReceiver.Event event, Bundle extras) {
        super.onEvent(context, event, extras);
        if (PushReceiver.Event.NOTIFICATION_OPENED.equals((Object)event) || PushReceiver.Event.NOTIFICATION_CLICK_BTN.equals((Object)event)) {
            String message = extras.getString("pushMsg");
            Log.e((String)TAG, (String)("message: " + message));
            try {
                JSONArray jsonArray = new JSONArray(message);
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                String content = jsonObject.getString("extend_content");
                JSONObject extObject = new JSONObject(content);
                JSONObject msgObject = extObject.getJSONObject("on_message");
                MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
                mixPushMessage.setMsgObject(msgObject.toString());
                HuaWeiPushManager.sMixMessageProvider.onNotificationMessageClicked(context, mixPushMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

