/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class SoInstallMgrSdk {
    private static final String ARMEABI = "armeabi";
    private static final String X86 = "x86";
    private static final String MIPS = "mips";
    static Context mContext = null;
    private static final int EventID_SO_INIT = 21033;
    static final String LOGTAG = "INIT_SO";

    public static void init(Context context) {
        mContext = context;
    }

    public static boolean initSo(String string, int n2) {
        return SoInstallMgrSdk.initSo(string, n2, null);
    }

    public static boolean initSo(String string, int n2, ClassLoader classLoader) {
        boolean bl;
        try {
            if (classLoader == null) {
                System.loadLibrary(string);
            } else {
                Runtime runtime = Runtime.getRuntime();
                Object object = new Class[]{String.class, ClassLoader.class};
                object = Runtime.class.getDeclaredMethod("loadLibrary", (Class<?>)object);
                ((Method)object).setAccessible(true);
                ((Method)object).invoke((Object)runtime, string, classLoader);
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
            unsatisfiedLinkError.printStackTrace();
        }
        catch (Error error) {
            bl = false;
            error.printStackTrace();
        }
        try {
            if (!bl) {
                String string2;
                if (SoInstallMgrSdk.isExist(string, n2)) {
                    boolean bl2 = SoInstallMgrSdk._loadUnzipSo(string, n2, classLoader);
                    if (bl2) {
                        return bl2;
                    }
                    SoInstallMgrSdk.removeSoIfExit(string, n2);
                }
                if (!(string2 = SoInstallMgrSdk._cpuType()).equalsIgnoreCase(MIPS) && !string2.equalsIgnoreCase(X86)) {
                    try {
                        bl = SoInstallMgrSdk.unZipSelectedFiles(string, n2, classLoader);
                    }
                    catch (ZipException zipException) {
                        zipException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
            unsatisfiedLinkError.printStackTrace();
        }
        catch (Error error) {
            bl = false;
            error.printStackTrace();
        }
        return bl;
    }

    private static String _getFieldReflectively(Build build, String string) {
        try {
            return Build.class.getField(string).get(build).toString();
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    private static String _cpuType() {
        String string = SoInstallMgrSdk._getFieldReflectively(new Build(), "CPU_ABI");
        if (string == null || string.length() == 0 || string.equals("Unknown")) {
            string = ARMEABI;
        }
        return string.toLowerCase();
    }

    static String _targetSoFile(String string, int n2) {
        Object object = mContext;
        if (object == null) {
            return "";
        }
        String string2 = "/data/data/" + object.getPackageName() + "/files";
        if ((object = object.getFilesDir()) != null) {
            string2 = ((File)object).getPath();
        }
        return string2 + "/lib" + string + "bk" + n2 + ".so";
    }

    static void removeSoIfExit(String object, int n2) {
        object = SoInstallMgrSdk._targetSoFile((String)object, n2);
        if (((File)(object = new File((String)object))).exists()) {
            ((File)object).delete();
        }
    }

    static boolean isExist(String string, int n2) {
        string = SoInstallMgrSdk._targetSoFile(string, n2);
        return new File(string).exists();
    }

    static boolean _loadUnzipSo(String string, int n2, ClassLoader classLoader) {
        boolean bl;
        try {
            if (SoInstallMgrSdk.isExist(string, n2)) {
                if (classLoader == null) {
                    System.load(SoInstallMgrSdk._targetSoFile(string, n2));
                } else {
                    Runtime runtime = Runtime.getRuntime();
                    Object object = new Class[]{String.class, ClassLoader.class};
                    object = Runtime.class.getDeclaredMethod("load", (Class<?>)object);
                    ((Method)object).setAccessible(true);
                    ((Method)object).invoke((Object)runtime, SoInstallMgrSdk._targetSoFile(string, n2), classLoader);
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
            unsatisfiedLinkError.printStackTrace();
        }
        catch (Error error) {
            bl = false;
            error.printStackTrace();
        }
        return bl;
    }

    static boolean unZipSelectedFiles(String string, int n2, ClassLoader classLoader) throws ZipException, IOException {
        block29: {
            Object object = "lib/armeabi/lib" + string + ".so";
            try {
                block28: {
                    Object object2 = "";
                    Object object3 = mContext;
                    if (object3 == null) {
                        return false;
                    }
                    Object object4 = object3.getApplicationInfo();
                    if (object4 != null) {
                        object2 = ((ApplicationInfo)object4).sourceDir;
                    }
                    object2 = new ZipFile((String)object2);
                    object4 = ((ZipFile)object2).entries();
                    while (object4.hasMoreElements()) {
                        int n3;
                        AbstractInterruptibleChannel abstractInterruptibleChannel;
                        block26: {
                            ZipEntry zipEntry = (ZipEntry)object4.nextElement();
                            if (!zipEntry.getName().startsWith((String)object)) continue;
                            object = null;
                            object4 = null;
                            abstractInterruptibleChannel = null;
                            n3 = 0;
                            try {
                                int n4;
                                SoInstallMgrSdk.removeSoIfExit(string, n2);
                                object = ((ZipFile)object2).getInputStream(zipEntry);
                                object4 = object3.openFileOutput("lib" + string + "bk" + n2 + ".so", 0);
                                abstractInterruptibleChannel = ((FileOutputStream)object4).getChannel();
                                object3 = new byte[1024];
                                while ((n4 = ((InputStream)object).read((byte[])object3)) > 0) {
                                    ((FileChannel)abstractInterruptibleChannel).write(ByteBuffer.wrap((byte[])object3, 0, n4));
                                    n3 += n4;
                                }
                                if (object == null) break block26;
                            }
                            catch (Throwable throwable) {
                                if (object != null) {
                                    try {
                                        ((InputStream)object).close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                                if (abstractInterruptibleChannel != null) {
                                    try {
                                        abstractInterruptibleChannel.close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                                if (object4 != null) {
                                    try {
                                        ((FileOutputStream)object4).close();
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                                ((ZipFile)object2).close();
                                throw throwable;
                            }
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (abstractInterruptibleChannel != null) {
                            try {
                                abstractInterruptibleChannel.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (object4 != null) {
                            try {
                                ((FileOutputStream)object4).close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        ((ZipFile)object2).close();
                        if (n3 > 0) {
                            return SoInstallMgrSdk._loadUnzipSo(string, n2, classLoader);
                        }
                        break block28;
                    }
                    break block29;
                }
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }
}

