/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.text.TextUtils;
import com.taobao.accs.AccsException;
import com.taobao.accs.utl.ALog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AccsClientConfig {
    public static final int SECURITY_TAOBAO = 0;
    public static final int SECURITY_OPEN = 1;
    public static final int SECURITY_OFF = 2;
    public static final String[] DEFAULT_CENTER_HOSTS = new String[]{"msgacs.m.taobao.com", "msgacs.wapa.taobao.com", "msgacs.waptest.taobao.com"};
    private static String[] DEFAULT_CHANNEL_HOSTS = new String[]{"accscdn.m.taobao.com", "acs.wapa.taobao.com", "acs.waptest.taobao.com"};
    @ENV
    public static int mEnv = 0;
    private static Map<String, AccsClientConfig> mReleaseConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
    private static Map<String, AccsClientConfig> mPreviewConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
    private static Map<String, AccsClientConfig> mDebugConfigs = new ConcurrentHashMap<String, AccsClientConfig>(1);
    public static final String DEFAULT_CONFIGTAG = "default";
    private String mAppKey;
    private String mAppSecret;
    private String mInappHost;
    private String mChannelHost;
    private int mSecurity;
    private String mAuthCode;
    private int mInappPubKey;
    private int mChannelPubKey;
    private boolean mKeepalive;
    private boolean mAutoUnit;
    private String mTag;
    private int mConfigEnv;
    private boolean mDisableChannel;

    protected AccsClientConfig() {
    }

    @Deprecated
    public static AccsClientConfig getConfig(String string) {
        Object object;
        switch (mEnv) {
            case 1: {
                object = mPreviewConfigs;
                break;
            }
            case 2: {
                object = mDebugConfigs;
                break;
            }
            default: {
                object = mReleaseConfigs;
            }
        }
        for (AccsClientConfig accsClientConfig : object.values()) {
            if (!accsClientConfig.mAppKey.equals(string) || accsClientConfig.mConfigEnv != mEnv) continue;
            return accsClientConfig;
        }
        ALog.e("AccsClientConfig", "getConfig null!", new Object[0]);
        return null;
    }

    public static AccsClientConfig getConfigByTag(String object) {
        Map<String, AccsClientConfig> map;
        switch (mEnv) {
            case 1: {
                map = mPreviewConfigs;
                break;
            }
            case 2: {
                map = mDebugConfigs;
                break;
            }
            default: {
                map = mReleaseConfigs;
            }
        }
        object = map.get(object);
        if (object == null) {
            ALog.e("AccsClientConfig", "getConfig null!", new Object[0]);
        }
        return object;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public String getInappHost() {
        return this.mInappHost;
    }

    public String getChannelHost() {
        return this.mChannelHost;
    }

    public int getSecurity() {
        return this.mSecurity;
    }

    public String getAuthCode() {
        return this.mAuthCode;
    }

    public int getInappPubKey() {
        return this.mInappPubKey;
    }

    public int getChannelPubKey() {
        return this.mChannelPubKey;
    }

    public boolean isKeepalive() {
        return this.mKeepalive;
    }

    public boolean isAutoUnit() {
        return this.mAutoUnit;
    }

    public String getTag() {
        return this.mTag;
    }

    public int getConfigEnv() {
        return this.mConfigEnv;
    }

    public boolean getDisableChannel() {
        return this.mDisableChannel;
    }

    public String toString() {
        return "AccsClientConfig{mAppKey=" + this.mAppKey + ", mAppSecret=" + this.mAppSecret + ", mInappHost=" + this.mInappHost + ", mChannelHost=" + this.mChannelHost + ", mSecurity=" + this.mSecurity + ", mAuthCode=" + this.mAuthCode + ", mInappPubKey=" + this.mInappPubKey + ", mChannelPubKey=" + this.mChannelPubKey + ", mKeepalive=" + this.mKeepalive + ", mAutoUnit=" + this.mAutoUnit + ", mConfigEnv=" + this.mConfigEnv + ", mTag=" + this.mTag + ", mDisableChannel=" + this.mDisableChannel;
    }

    public static class Builder {
        private String mAppKey;
        private String mTag;
        private String mAppSecret;
        private String mInappHost;
        private String mChannelHost;
        private String mAuthCode;
        private int mInappPubKey = -1;
        private int mChannelPubKey = -1;
        private boolean mKeepalive = true;
        private boolean mAutoUnit = true;
        private int mConfigEnv = -1;
        private boolean mDisableChannel = false;

        public Builder setAppKey(String string) {
            this.mAppKey = string;
            return this;
        }

        public Builder setAppSecret(String string) {
            this.mAppSecret = string;
            return this;
        }

        public Builder setInappHost(String string) {
            this.mInappHost = string;
            return this;
        }

        public Builder setChannelHost(String string) {
            this.mChannelHost = string;
            return this;
        }

        public Builder setAutoCode(String string) {
            this.mAuthCode = string;
            return this;
        }

        public Builder setInappPubKey(int n2) {
            this.mInappPubKey = n2;
            return this;
        }

        public Builder setChannelPubKey(int n2) {
            this.mChannelPubKey = n2;
            return this;
        }

        public Builder setKeepAlive(boolean bl) {
            this.mKeepalive = bl;
            return this;
        }

        public Builder setAutoUnit(boolean bl) {
            this.mAutoUnit = bl;
            return this;
        }

        public Builder setConfigEnv(@ENV int n2) {
            this.mConfigEnv = n2;
            return this;
        }

        public Builder setTag(String string) {
            this.mTag = string;
            return this;
        }

        public Builder setDisableChannel(boolean bl) {
            this.mDisableChannel = bl;
            return this;
        }

        public AccsClientConfig build() throws AccsException {
            Map map;
            if (TextUtils.isEmpty((CharSequence)this.mAppKey)) {
                throw new AccsException("appkey null");
            }
            AccsClientConfig accsClientConfig = new AccsClientConfig();
            accsClientConfig.mAppKey = this.mAppKey;
            accsClientConfig.mAppSecret = this.mAppSecret;
            accsClientConfig.mAuthCode = this.mAuthCode;
            accsClientConfig.mKeepalive = this.mKeepalive;
            accsClientConfig.mAutoUnit = this.mAutoUnit;
            accsClientConfig.mInappPubKey = this.mInappPubKey;
            accsClientConfig.mChannelPubKey = this.mChannelPubKey;
            accsClientConfig.mInappHost = this.mInappHost;
            accsClientConfig.mChannelHost = this.mChannelHost;
            accsClientConfig.mTag = this.mTag;
            accsClientConfig.mConfigEnv = this.mConfigEnv;
            accsClientConfig.mDisableChannel = this.mDisableChannel;
            if (accsClientConfig.mConfigEnv < 0) {
                accsClientConfig.mConfigEnv = mEnv;
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mAppSecret)) {
                accsClientConfig.mSecurity = 0;
            } else {
                accsClientConfig.mSecurity = 2;
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mInappHost)) {
                accsClientConfig.mInappHost = DEFAULT_CENTER_HOSTS[mEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mChannelHost)) {
                accsClientConfig.mChannelHost = DEFAULT_CHANNEL_HOSTS[mEnv];
            }
            if (TextUtils.isEmpty((CharSequence)accsClientConfig.mTag)) {
                accsClientConfig.mTag = accsClientConfig.mAppKey;
            }
            switch (accsClientConfig.mConfigEnv) {
                case 1: {
                    map = mPreviewConfigs;
                    break;
                }
                case 2: {
                    map = mDebugConfigs;
                    break;
                }
                default: {
                    map = mReleaseConfigs;
                }
            }
            map.put(accsClientConfig.getTag(), accsClientConfig);
            ALog.i("AccsClientConfig_" + accsClientConfig.getTag(), "build", "config", accsClientConfig.toString());
            return accsClientConfig;
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ENV {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface SECURITY_TYPE {
    }
}

