/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl.adapter;

import android.os.RemoteException;
import anet.channel.b.a;
import anetwork.channel.aidl.ParcelableInputStream;
import anetwork.channel.entity.i;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ParcelableInputStreamImpl
extends ParcelableInputStream.Stub {
    private static final String TAG = "anet.ParcelableInputStreamImpl";
    private static final a EOS = a.a(0);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private LinkedList<a> byteList = new LinkedList();
    private int blockIndex;
    private int blockOffset;
    private int contentLength;
    private int receivedLength = 0;
    private int rto = 10000;
    private String url = "";
    private String seqNo = "";
    final ReentrantLock lock = new ReentrantLock();
    final Condition newDataArrive = this.lock.newCondition();

    public void write(a a2) {
        if (this.isClosed.get()) {
            return;
        }
        this.lock.lock();
        try {
            this.byteList.add(a2);
            this.receivedLength += a2.b();
            this.newDataArrive.signal();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void writeEnd() {
        this.write(EOS);
        if (anet.channel.util.a.a(1)) {
            anet.channel.util.a.a(TAG, "set EOS flag to stream", this.seqNo, new Object[0]);
        }
        if (this.contentLength != 0 && this.contentLength != this.receivedLength) {
            anet.channel.util.a.d(TAG, "data length no match!", this.seqNo, "ContentLength", this.contentLength, "Received", this.receivedLength, "url", this.url);
        }
    }

    private void recycleCurrentItem() {
        this.lock.lock();
        try {
            this.byteList.set(this.blockIndex, EOS).c();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() throws RemoteException {
        if (this.isClosed.get()) {
            throw new RuntimeException("Stream is closed");
        }
        int n2 = 0;
        this.lock.lock();
        try {
            if (this.blockIndex == this.byteList.size()) {
                return 0;
            }
            ListIterator<a> listIterator = this.byteList.listIterator(this.blockIndex);
            while (listIterator.hasNext()) {
                n2 += listIterator.next().b();
            }
        }
        finally {
            this.lock.unlock();
        }
        return n2 -= this.blockOffset;
    }

    @Override
    public void close() throws RemoteException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.lock.lock();
            try {
                for (a a2 : this.byteList) {
                    if (a2 == EOS) continue;
                    a2.c();
                }
                this.byteList.clear();
                this.byteList = null;
                this.blockIndex = -1;
                this.blockOffset = -1;
                this.contentLength = 0;
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public int readByte() throws RemoteException {
        int n2;
        if (this.isClosed.get()) {
            throw new RuntimeException("Stream is closed");
        }
        this.lock.lock();
        try {
            while (true) {
                if (this.blockIndex == this.byteList.size() && !this.newDataArrive.await(this.rto, TimeUnit.MILLISECONDS)) {
                    this.close();
                    throw new RuntimeException("await timeout.");
                }
                a a2 = this.byteList.get(this.blockIndex);
                if (a2 == EOS) {
                    n2 = -1;
                    break;
                }
                if (this.blockOffset < a2.b()) {
                    n2 = a2.a()[this.blockOffset];
                    ++this.blockOffset;
                    break;
                }
                this.recycleCurrentItem();
                ++this.blockIndex;
                this.blockOffset = 0;
            }
        }
        catch (InterruptedException interruptedException) {
            this.close();
            throw new RuntimeException("await interrupt");
        }
        finally {
            this.lock.unlock();
        }
        return n2;
    }

    @Override
    public int readBytes(byte[] byArray, int n2, int n3) throws RemoteException {
        int n4;
        if (this.isClosed.get()) {
            throw new RuntimeException("Stream is closed");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n5 = n2;
        n3 = n2 + n3;
        this.lock.lock();
        try {
            while (n5 < n3) {
                if (this.blockIndex == this.byteList.size() && !this.newDataArrive.await(this.rto, TimeUnit.MILLISECONDS)) {
                    this.close();
                    throw new RuntimeException("await timeout.");
                }
                a a2 = this.byteList.get(this.blockIndex);
                if (a2 != EOS) {
                    int n6;
                    int n7 = a2.b() - this.blockOffset;
                    if (n7 < (n6 = n3 - n5)) {
                        System.arraycopy(a2.a(), this.blockOffset, byArray, n5, n7);
                        n5 += n7;
                        this.recycleCurrentItem();
                        ++this.blockIndex;
                        this.blockOffset = 0;
                        continue;
                    }
                    System.arraycopy(a2.a(), this.blockOffset, byArray, n5, n6);
                    this.blockOffset += n6;
                    n5 += n6;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            this.close();
            throw new RuntimeException("await interrupt");
        }
        finally {
            this.lock.unlock();
        }
        if ((n4 = n5 - n2) > 0) {
            return n4;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws RemoteException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    @Override
    public long skip(int n2) throws RemoteException {
        int n3 = 0;
        this.lock.lock();
        try {
            a a2;
            while (n3 < n2 && this.blockIndex != this.byteList.size() && (a2 = this.byteList.get(this.blockIndex)) != EOS) {
                n3 = a2.b();
                if (n3 - this.blockOffset < n2 - 0) {
                    n3 = 0 + (n3 - this.blockOffset);
                    this.recycleCurrentItem();
                    ++this.blockIndex;
                    this.blockOffset = 0;
                    break;
                }
                n3 = n2;
                this.blockOffset += 0;
            }
        }
        finally {
            this.lock.unlock();
        }
        return n3;
    }

    @Override
    public int length() throws RemoteException {
        return this.contentLength;
    }

    public void init(i i2, int n2) {
        this.contentLength = n2;
        this.seqNo = i2.f();
        this.url = i2.k();
        this.rto = i2.d();
    }
}

