/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.type.mch.RedpacketSendType;
import com.foxinmy.weixin4j.type.mch.RedpacketStatus;
import com.foxinmy.weixin4j.type.mch.RedpacketType;
import com.foxinmy.weixin4j.util.DateUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RedpacketRecord
extends XmlResult {
    private static final long serialVersionUID = 929959747323918458L;
    @XmlElement(name="mch_billno")
    @JSONField(name="mch_billno")
    private String outTradeNo;
    @XmlElement(name="mch_id")
    @JSONField(name="mch_id")
    private String mchId;
    @XmlElement(name="detail_id")
    @JSONField(name="detail_id")
    private String repacketId;
    @XmlElement(name="status")
    private String status;
    @XmlElement(name="send_type")
    @JSONField(name="send_type")
    private String sendType;
    @XmlElement(name="hb_type")
    @JSONField(name="hb_type")
    private String hbType;
    @XmlElement(name="total_num")
    @JSONField(name="total_num")
    private int totalNum;
    @XmlElement(name="total_amount")
    @JSONField(name="total_amount")
    private int totalAmount;
    @XmlElement(name="reason")
    private String reason;
    @XmlElement(name="send_time")
    @JSONField(name="send_time")
    private String sendTime;
    @XmlElement(name="refund_time")
    @JSONField(name="refund_time")
    private String refundTime;
    @XmlElement(name="refund_amount")
    @JSONField(name="refund_amount")
    private Integer refundAmount;
    @XmlElement(name="wishing")
    private String wishing;
    @XmlElement(name="remark")
    private String remark;
    @XmlElement(name="act_name")
    @JSONField(name="act_name")
    private String actName;
    @XmlElement(name="hbinfo")
    @XmlElementWrapper(name="hblist")
    @JSONField(name="hblist")
    private List<RedpacketReceiver> receivers;

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getRepacketId() {
        return this.repacketId;
    }

    @JSONField(serialize=false)
    public RedpacketStatus getFormatStatus() {
        return this.status != null ? RedpacketStatus.valueOf(this.status.toUpperCase()) : null;
    }

    @JSONField(serialize=false)
    public RedpacketSendType getFormatSendType() {
        return this.sendType != null ? RedpacketSendType.valueOf(this.sendType) : null;
    }

    @JSONField(serialize=false)
    public RedpacketType getFomatHbType() {
        return this.hbType != null ? RedpacketType.valueOf(this.hbType) : null;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSendType() {
        return this.sendType;
    }

    public String getHbType() {
        return this.hbType;
    }

    public int getTotalNum() {
        return this.totalNum;
    }

    public int getTotalAmount() {
        return this.totalAmount;
    }

    @JSONField(serialize=false)
    public double getFormatTotalAmount() {
        return (double)this.totalAmount / 100.0;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    @JSONField(serialize=false)
    public Date getFormatSendTime() {
        return this.sendTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.sendTime) : null;
    }

    public String getRefundTime() {
        return this.refundTime;
    }

    @JSONField(serialize=false)
    public Date getFormatRefundTime() {
        return this.refundTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.refundTime) : null;
    }

    public Integer getRefundAmount() {
        return this.refundAmount;
    }

    @JSONField(serialize=false)
    public double getFormatRefundAmount() {
        return this.refundAmount != null ? (double)this.refundAmount.intValue() / 100.0 : 0.0;
    }

    public String getWishing() {
        return this.wishing;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getActName() {
        return this.actName;
    }

    public List<RedpacketReceiver> getReceivers() {
        return this.receivers;
    }

    @Override
    public String toString() {
        return "RedpacketRecord [outTradeNo=" + this.outTradeNo + ", mchId=" + this.mchId + ", repacketId=" + this.repacketId + ", status=" + this.status + ", sendType=" + this.sendType + ", hbType=" + this.hbType + ", totalNum=" + this.totalNum + ", totalAmount=" + this.getFormatTotalAmount() + ", reason=" + this.reason + ", sendTime=" + this.sendTime + ", refundTime=" + this.refundTime + ", refundAmount=" + this.getFormatRefundAmount() + ", wishing=" + this.wishing + ", remark=" + this.remark + ", actName=" + this.actName + ", receivers=" + this.receivers + "]";
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class RedpacketReceiver
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XmlElement(name="openid")
        private String openId;
        @XmlElement(name="status")
        private RedpacketStatus status;
        private int amount;
        @XmlElement(name="rcv_time")
        @JSONField(name="rcv_time")
        private String receiveTime;

        public String getOpenId() {
            return this.openId;
        }

        public RedpacketStatus getStatus() {
            return this.status;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getReceiveTime() {
            return this.receiveTime;
        }

        @JSONField(serialize=false)
        public double getFormatAmount() {
            return (double)this.amount / 100.0;
        }

        @JSONField(serialize=false)
        public Date getFormatReceiveTime() {
            return this.receiveTime != null ? DateUtil.parse2yyyyMMddHHmmss(this.receiveTime) : null;
        }

        public String toString() {
            return "RedpacketReceiver [openId=" + this.openId + ", status=" + (Object)((Object)this.status) + ", amount=" + this.getFormatAmount() + ", receiveTime=" + this.receiveTime + "]";
        }
    }
}

