/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.paging;

import com.foxinmy.weixin4j.model.paging.Sort;
import java.io.Serializable;

public class Pageable
implements Serializable {
    private static final long serialVersionUID = -8051554878205756307L;
    private final int page;
    private final int size;
    private Sort sort;

    public Pageable(int page, int size) {
        if (page < 1) {
            throw new IllegalArgumentException("Page index must not be less than one!");
        }
        if (size < 1) {
            throw new IllegalArgumentException("Page size must not be less than one!");
        }
        this.page = page;
        this.size = size;
    }

    public Pageable(int page, int size, Sort.Direction direction, String ... properties) {
        this(page, size, new Sort(direction, properties));
    }

    public Pageable(int page, int size, Sort sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public static Pageable get() {
        return new Pageable(1, 20);
    }

    public int getPageSize() {
        return this.size;
    }

    public int getPageNumber() {
        return this.page;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public int getOffset() {
        return (this.page - 1) * this.size;
    }

    public boolean hasPrevious() {
        return this.page > 1;
    }

    public Pageable next() {
        return new Pageable(this.getPageNumber() + 1, this.getPageSize(), this.getSort());
    }

    public Pageable previous() {
        return this.getPageNumber() == 1 ? this : new Pageable(this.getPageNumber() - 1, this.getPageSize(), this.getSort());
    }

    public Pageable first() {
        return new Pageable(1, this.getPageSize(), this.getSort());
    }

    public String toString() {
        return "Pageable [page=" + this.page + ", size=" + this.size + ", sort=" + this.sort + "]";
    }
}

