/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.support.okhttp;

import com.foxinmy.weixin4j.http.AbstractHttpResponse;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpStatus;
import com.foxinmy.weixin4j.http.HttpVersion;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Response;

public class OkHttpResponse3
extends AbstractHttpResponse {
    private final Response response;
    private HttpHeaders headers;
    private HttpVersion protocol;
    private HttpStatus status;

    public OkHttpResponse3(Response response, byte[] content) {
        super(content);
        this.response = response;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            Headers headers = this.response.headers();
            for (int i = 0; i < headers.size(); ++i) {
                this.headers.add(headers.name(i), headers.value(i));
            }
        }
        return this.headers;
    }

    @Override
    public HttpVersion getProtocol() {
        if (this.protocol == null) {
            String protocol = this.response.protocol().toString().split("/")[0];
            boolean keepAlive = "keep-alive".equalsIgnoreCase(this.response.header("Connection"));
            if (this.response.protocol() == Protocol.HTTP_1_0) {
                return new HttpVersion(protocol, 1, 0, keepAlive);
            }
            if (this.response.protocol() == Protocol.HTTP_1_1) {
                return new HttpVersion(protocol, 1, 1, keepAlive);
            }
            if (this.response.protocol() == Protocol.HTTP_2) {
                return new HttpVersion(protocol, 2, 0, keepAlive);
            }
            if (this.response.protocol() == Protocol.SPDY_3) {
                return new HttpVersion(protocol, 3, 0, keepAlive);
            }
            this.protocol = new HttpVersion(protocol, keepAlive);
        }
        return this.protocol;
    }

    @Override
    public HttpStatus getStatus() {
        if (this.status == null) {
            this.status = new HttpStatus(this.response.code(), this.response.message());
        }
        return this.status;
    }

    @Override
    public void close() {
        this.response.close();
    }
}

