/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.apistarter.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.Collection;
import java.util.Map;

public class JacksonJsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> String convertString(T value) {
        try {
            return objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T convertObject(String content, Class<T> valueType) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        try {
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T convertCollection(String content, Class<? extends Collection> collectionClass, Class<?> clazz) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        CollectionType valueType = objectMapper.getTypeFactory().constructCollectionType(collectionClass, clazz);
        try {
            return (T)objectMapper.readValue(content, (JavaType)valueType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T convertCollection(String content, TypeReference<T> valueTypeRef) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        try {
            return (T)objectMapper.readValue(content, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> Map<K, V> convertMap(String json, Class<K> kClazz, Class<V> vClazz) {
        ObjectMapper objectMapper = new ObjectMapper();
        MapType javaType = objectMapper.getTypeFactory().constructMapType(Map.class, kClazz, vClazz);
        try {
            return (Map)objectMapper.readValue(json, (JavaType)javaType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

