/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.apistarter.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class IdCardNoValidatorUtils {
    private static final Pattern pattern = Pattern.compile("^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$");
    private static final Integer[] factor = new Integer[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] parity = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final Map<String, String> provMap = new HashMap<String, String>(){
        {
            this.put("11", "\u5317\u4eac");
            this.put("12", "\u5929\u6d25");
            this.put("13", "\u6cb3\u5317");
            this.put("14", "\u5c71\u897f");
            this.put("15", "\u5185\u8499\u53e4");
            this.put("21", "\u8fbd\u5b81");
            this.put("22", "\u5409\u6797");
            this.put("23", "\u9ed1\u9f99\u6c5f");
            this.put("31", "\u4e0a\u6d77");
            this.put("32", "\u6c5f\u82cf");
            this.put("33", "\u6d59\u6c5f");
            this.put("34", "\u5b89\u5fbd");
            this.put("35", "\u798f\u5efa");
            this.put("36", "\u6c5f\u897f");
            this.put("37", "\u5c71\u4e1c");
            this.put("41", "\u6cb3\u5357");
            this.put("42", "\u6e56\u5317");
            this.put("43", "\u6e56\u5357");
            this.put("44", "\u5e7f\u4e1c");
            this.put("45", "\u5e7f\u897f");
            this.put("46", "\u6d77\u5357");
            this.put("50", "\u91cd\u5e86");
            this.put("51", "\u56db\u5ddd");
            this.put("52", "\u8d35\u5dde");
            this.put("53", "\u4e91\u5357");
            this.put("54", "\u897f\u85cf");
            this.put("61", "\u9655\u897f");
            this.put("62", "\u7518\u8083");
            this.put("63", "\u9752\u6d77");
            this.put("64", "\u5b81\u590f");
            this.put("65", "\u65b0\u7586");
            this.put("71", "\u53f0\u6e7e");
            this.put("81", "\u9999\u6e2f");
            this.put("82", "\u6fb3\u95e8");
        }
    };

    public static boolean isValid(String idCardNo) {
        if (!pattern.matcher(idCardNo).matches()) {
            return false;
        }
        if (!IdCardNoValidatorUtils.checkCode(idCardNo)) {
            return false;
        }
        String date = idCardNo.substring(6, 14);
        if (!IdCardNoValidatorUtils.checkBirthday(date)) {
            return false;
        }
        return IdCardNoValidatorUtils.checkProv(idCardNo.substring(0, 2));
    }

    private static boolean checkCode(String idCardNo) {
        String code = idCardNo.substring(0, 17);
        String[] split = code.split("");
        int sum = 0;
        for (int i = 0; i < split.length; ++i) {
            sum += Integer.parseInt(split[i]) * factor[i];
        }
        return idCardNo.endsWith(parity[sum % 11]);
    }

    private static boolean checkBirthday(String birthday) {
        String year = birthday.substring(0, 4);
        String month = birthday.substring(4, 6);
        String date = birthday.substring(6, 8);
        String dateStr = year + "-" + month + "-" + date;
        return IdCardNoValidatorUtils.checkDateValid(dateStr);
    }

    private static boolean checkProv(String s) {
        if (StringUtils.hasText((String)s)) {
            String value = provMap.get(s);
            return StringUtils.hasText((String)value);
        }
        return false;
    }

    private static boolean checkDateValid(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setLenient(false);
        try {
            simpleDateFormat.parse(dateStr);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

