/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.apistarter.handler;

import com.fengwenyi.api.result.IReturnCode;
import com.fengwenyi.api.result.ResponseTemplate;
import com.fengwenyi.apistarter.enums.ApiResult;
import com.fengwenyi.apistarter.exception.ApiException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseTemplate<Void> missingServletRequestParameterExceptionHandler(HttpServletRequest request, MissingServletRequestParameterException e) {
        log.error("MissingServletRequestParameterException, uri:{}", (Object)request.getRequestURI());
        log.error("msg={}", (Object)e.getParameterName());
        return ResponseTemplate.fail((IReturnCode)ApiResult.PARAM_MISS, (String)("\u53c2\u6570\u7f3a\u5931\u5f02\u5e38: [" + e.getParameterName() + "]"));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseTemplate<Void> handleParamCheckException(HttpServletRequest request, MethodArgumentNotValidException e) {
        log.error("MethodArgumentNotValidException, uri:{}", (Object)request.getRequestURI());
        BindingResult bindingResult = e.getBindingResult();
        StringJoiner errMsgJoiner = new StringJoiner(",", "[", "]");
        if (bindingResult.hasErrors()) {
            List allErrors = bindingResult.getAllErrors();
            for (ObjectError objectError : allErrors) {
                String msg = objectError.getDefaultMessage();
                if (!StringUtils.hasText((String)msg)) continue;
                errMsgJoiner.add(msg);
            }
        }
        log.error("msg={}", (Object)errMsgJoiner);
        return ResponseTemplate.fail((IReturnCode)ApiResult.PARAM_VALIDATED, (String)("\u53c2\u6570\u68c0\u9a8c\u5931\u8d25: " + errMsgJoiner));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseTemplate<Void> constraintViolationExceptionHandler(HttpServletRequest request, ConstraintViolationException e) {
        log.error("ConstraintViolationException, uri:{}", (Object)request.getRequestURI());
        Set constraintViolations = e.getConstraintViolations();
        StringJoiner errMsgJoiner = new StringJoiner(",", "[", "]");
        for (ConstraintViolation constraintViolation : constraintViolations) {
            String errMsg = constraintViolation.getMessageTemplate();
            if (!StringUtils.hasText((String)errMsg)) continue;
            errMsgJoiner.add(errMsg);
        }
        log.error("msg={}", (Object)errMsgJoiner);
        return ResponseTemplate.fail((IReturnCode)ApiResult.PARAM_VALIDATED, (String)("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: " + errMsgJoiner));
    }

    @ExceptionHandler(value={ApiException.class})
    public ResponseTemplate<Void> apiExceptionHandler(HttpServletRequest request, ApiException e) {
        log.info("ApiException, uri:{}", (Object)request.getRequestURI());
        IReturnCode returnCode = e.getReturnCode();
        String message = e.getMessage();
        if (Objects.isNull(returnCode)) {
            log.error("msg={}", (Object)message);
            return ResponseTemplate.fail((String)message);
        }
        if (StringUtils.hasText((String)message)) {
            log.error("code={}, message={}", (Object)returnCode.getCode(), (Object)message);
            return ResponseTemplate.fail((IReturnCode)returnCode, (String)message);
        }
        log.error("code={}, message={}", (Object)returnCode.getCode(), (Object)returnCode.getMessage());
        return ResponseTemplate.fail((IReturnCode)returnCode);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseTemplate<Void> exceptionHandler(HttpServletRequest request, Exception e) {
        log.error("Exception, uri:{}", (Object)request.getRequestURI(), (Object)e);
        return ResponseTemplate.fail();
    }
}

