/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.java.ImportSorter;
import com.diffplug.spotless.java.LibJavaPreconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class ImportOrderStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean WILDCARDS_LAST_DEFAULT = false;
    private static final boolean SEMANTIC_SORT_DEFAULT = false;
    private static final Set<String> TREAT_AS_PACKAGE_DEFAULT = Set.of();
    private static final Set<String> TREAT_AS_CLASS_DEFAULT = Set.of();
    private final String lineFormat;

    public static ImportOrderStep forGroovy() {
        return new ImportOrderStep("import %s");
    }

    public static ImportOrderStep forJava() {
        return new ImportOrderStep("import %s;");
    }

    private ImportOrderStep(String lineFormat) {
        this.lineFormat = lineFormat;
    }

    public FormatterStep createFrom(String ... importOrder) {
        return this.createFrom(false, false, TREAT_AS_PACKAGE_DEFAULT, TREAT_AS_CLASS_DEFAULT, importOrder);
    }

    public FormatterStep createFrom(boolean wildcardsLast, boolean semanticSort, Set<String> treatAsPackage, Set<String> treatAsClass, String ... importOrder) {
        List<String> importOrderList = LibJavaPreconditions.requireElementsNonNull(Arrays.asList(importOrder));
        return this.createFrom(wildcardsLast, semanticSort, treatAsPackage, treatAsClass, () -> importOrderList);
    }

    public FormatterStep createFrom(File importsFile) {
        return this.createFrom(false, false, TREAT_AS_PACKAGE_DEFAULT, TREAT_AS_CLASS_DEFAULT, importsFile);
    }

    public FormatterStep createFrom(boolean wildcardsLast, boolean semanticSort, Set<String> treatAsPackage, Set<String> treatAsClass, File importsFile) {
        Objects.requireNonNull(importsFile);
        return this.createFrom(wildcardsLast, semanticSort, treatAsPackage, treatAsClass, () -> ImportOrderStep.getImportOrder(importsFile));
    }

    private FormatterStep createFrom(boolean wildcardsLast, boolean semanticSort, Set<String> treatAsPackage, Set<String> treatAsClass, Supplier<List<String>> importOrder) {
        return FormatterStep.create("importOrder", new State(importOrder.get(), this.lineFormat, wildcardsLast, semanticSort, treatAsPackage, treatAsClass), SerializedFunction.identity(), State::toFormatter);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    private static List<String> getImportOrder(File importsFile) {
        List list;
        block8: {
            Stream<String> lines = Files.lines(importsFile.toPath());
            try {
                list = lines.filter(line -> !line.startsWith("#")).map(ImportOrderStep::splitIntoIndexAndName).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toCollection(ArrayList::new));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            lines.close();
        }
        return list;
    }

    private static Map.Entry<Integer, String> splitIntoIndexAndName(String line) {
        String[] pieces = line.split("=");
        Integer index = Integer.valueOf(pieces[0]);
        String name = pieces.length == 2 ? pieces[1] : "";
        return new AbstractMap.SimpleImmutableEntry<Integer, String>(index, name);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> importOrder;
        private final String lineFormat;
        private final boolean wildcardsLast;
        private final boolean semanticSort;
        private final TreeSet<String> treatAsPackage;
        private final TreeSet<String> treatAsClass;

        State(List<String> importOrder, String lineFormat, boolean wildcardsLast, boolean semanticSort, @Nullable Set<String> treatAsPackage, @Nullable Set<String> treatAsClass) {
            this.importOrder = importOrder;
            this.lineFormat = lineFormat;
            this.wildcardsLast = wildcardsLast;
            this.semanticSort = semanticSort;
            this.treatAsPackage = treatAsPackage == null ? null : new TreeSet<String>(treatAsPackage);
            this.treatAsClass = treatAsClass == null ? null : new TreeSet<String>(treatAsClass);
        }

        FormatterFunc toFormatter() {
            return raw -> new ImportSorter(this.importOrder, this.wildcardsLast, this.semanticSort, this.treatAsPackage, this.treatAsClass).format(raw, this.lineFormat);
        }
    }
}

