/*
 * Decompiled with CFR 0.152.
 */
package com.didispace.swagger.butler;

import com.didispace.swagger.butler.SwaggerButlerProperties;
import com.didispace.swagger.butler.SwaggerResourceProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

public class SwaggerResourcesProcessor
implements SwaggerResourcesProvider {
    @Autowired
    private RouteLocator routeLocator;
    @Autowired
    private SwaggerButlerProperties swaggerButlerConfig;

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        List routes = this.routeLocator.getRoutes();
        for (Route route : routes) {
            String routeName = route.getId();
            SwaggerResourceProperties resourceProperties = this.swaggerButlerConfig.getResources().get(routeName);
            if (!this.swaggerButlerConfig.getAutoGenerateFromZuulRoutes().booleanValue() && resourceProperties == null || this.swaggerButlerConfig.getAutoGenerateFromZuulRoutes().booleanValue() && this.swaggerButlerConfig.needIgnore(routeName)) continue;
            String name = routeName;
            if (resourceProperties != null && resourceProperties.getName() != null) {
                name = resourceProperties.getName();
            }
            String swaggerPath = this.swaggerButlerConfig.getApiDocsPath();
            if (resourceProperties != null && resourceProperties.getApiDocsPath() != null) {
                swaggerPath = resourceProperties.getApiDocsPath();
            }
            String location = route.getFullPath().replace("**", swaggerPath);
            String swaggerVersion = this.swaggerButlerConfig.getSwaggerVersion();
            if (resourceProperties != null && resourceProperties.getSwaggerVersion() != null) {
                swaggerVersion = resourceProperties.getSwaggerVersion();
            }
            resources.add(this.swaggerResource(name, location, swaggerVersion));
        }
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location, String version) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion(version);
        return swaggerResource;
    }
}

