/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.google.common.base.Optional;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Conditions {
    private final Map<Column, Condition> conditions = new LinkedHashMap<Column, Condition>();

    public Conditions(Conditions conditions) {
        for (Map.Entry<Column, Condition> entry : conditions.conditions.entrySet()) {
            this.conditions.put(entry.getKey(), entry.getValue());
        }
    }

    public void add(Condition condition, ShardingRule shardingRule) {
        if (shardingRule.isShardingColumn(condition.getColumn())) {
            this.conditions.put(condition.getColumn(), condition);
        }
    }

    @Deprecated
    public void add(Condition condition) {
        this.conditions.put(condition.getColumn(), condition);
    }

    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    public Optional<Condition> find(Column column) {
        return Optional.fromNullable((Object)this.conditions.get(column));
    }

    public Conditions() {
    }

    public Map<Column, Condition> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return "Conditions(conditions=" + this.getConditions() + ")";
    }
}

