/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.lexer.analyzer;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.TokenType;
import java.util.HashMap;
import java.util.Map;

public final class Dictionary {
    private final Map<String, Keyword> tokens = new HashMap<String, Keyword>(1024);

    public Dictionary(Keyword ... dialectKeywords) {
        this.fill(dialectKeywords);
    }

    private void fill(Keyword ... dialectKeywords) {
        for (DefaultKeyword defaultKeyword : DefaultKeyword.values()) {
            this.tokens.put(defaultKeyword.name(), defaultKeyword);
        }
        for (Keyword keyword : dialectKeywords) {
            this.tokens.put(keyword.toString(), keyword);
        }
    }

    TokenType findTokenType(String literals, TokenType defaultTokenType) {
        String key = null == literals ? null : literals.toUpperCase();
        return this.tokens.containsKey(key) ? (TokenType)this.tokens.get(key) : defaultTokenType;
    }

    TokenType findTokenType(String literals) {
        String key;
        String string = key = null == literals ? null : literals.toUpperCase();
        if (this.tokens.containsKey(key)) {
            return this.tokens.get(key);
        }
        throw new IllegalArgumentException();
    }
}

