/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.lexer;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.analyzer.CharType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.analyzer.Dictionary;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.analyzer.Tokenizer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Token;
import java.beans.ConstructorProperties;

public class Lexer {
    private final String input;
    private final Dictionary dictionary;
    private int offset;
    private Token currentToken;

    public final void nextToken() {
        this.skipIgnoredToken();
        this.currentToken = this.isVariableBegin() ? new Tokenizer(this.input, this.dictionary, this.offset).scanVariable() : (this.isNCharBegin() ? new Tokenizer(this.input, this.dictionary, ++this.offset).scanChars() : (this.isIdentifierBegin() ? new Tokenizer(this.input, this.dictionary, this.offset).scanIdentifier() : (this.isHexDecimalBegin() ? new Tokenizer(this.input, this.dictionary, this.offset).scanHexDecimal() : (this.isNumberBegin() ? new Tokenizer(this.input, this.dictionary, this.offset).scanNumber() : (this.isSymbolBegin() ? new Tokenizer(this.input, this.dictionary, this.offset).scanSymbol() : (this.isCharsBegin() ? new Tokenizer(this.input, this.dictionary, this.offset).scanChars() : (this.isEnd() ? new Token(Assist.END, "", this.offset) : new Token(Assist.ERROR, "", this.offset))))))));
        this.offset = this.currentToken.getEndPosition();
    }

    private void skipIgnoredToken() {
        this.offset = new Tokenizer(this.input, this.dictionary, this.offset).skipWhitespace();
        while (this.isHintBegin()) {
            this.offset = new Tokenizer(this.input, this.dictionary, this.offset).skipHint();
            this.offset = new Tokenizer(this.input, this.dictionary, this.offset).skipWhitespace();
        }
        while (this.isCommentBegin()) {
            this.offset = new Tokenizer(this.input, this.dictionary, this.offset).skipComment();
            this.offset = new Tokenizer(this.input, this.dictionary, this.offset).skipWhitespace();
        }
    }

    protected boolean isHintBegin() {
        return false;
    }

    protected boolean isCommentBegin() {
        char current = this.getCurrentChar(0);
        char next = this.getCurrentChar(1);
        return '/' == current && '/' == next || '-' == current && '-' == next || '/' == current && '*' == next;
    }

    protected boolean isVariableBegin() {
        return false;
    }

    protected boolean isSupportNChars() {
        return false;
    }

    private boolean isNCharBegin() {
        return this.isSupportNChars() && 'N' == this.getCurrentChar(0) && '\'' == this.getCurrentChar(1);
    }

    private boolean isIdentifierBegin() {
        return this.isIdentifierBegin(this.getCurrentChar(0));
    }

    private boolean isIdentifierBegin(char ch) {
        return CharType.isAlphabet(ch) || '`' == ch || '_' == ch || '$' == ch;
    }

    private boolean isHexDecimalBegin() {
        return '0' == this.getCurrentChar(0) && 'x' == this.getCurrentChar(1);
    }

    private boolean isNumberBegin() {
        return CharType.isDigital(this.getCurrentChar(0)) || '.' == this.getCurrentChar(0) && CharType.isDigital(this.getCurrentChar(1)) && !this.isIdentifierBegin(this.getCurrentChar(-1)) || '-' == this.getCurrentChar(0) && ('.' == this.getCurrentChar(0) || CharType.isDigital(this.getCurrentChar(1)));
    }

    private boolean isSymbolBegin() {
        return CharType.isSymbol(this.getCurrentChar(0));
    }

    private boolean isCharsBegin() {
        return '\'' == this.getCurrentChar(0) || '\"' == this.getCurrentChar(0);
    }

    private boolean isEnd() {
        return this.offset >= this.input.length();
    }

    protected final char getCurrentChar(int offset) {
        return this.offset + offset >= this.input.length() ? (char)'\u001a' : this.input.charAt(this.offset + offset);
    }

    @ConstructorProperties(value={"input", "dictionary"})
    public Lexer(String input, Dictionary dictionary) {
        this.input = input;
        this.dictionary = dictionary;
    }

    public String getInput() {
        return this.input;
    }

    public Token getCurrentToken() {
        return this.currentToken;
    }
}

