/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.hint;

import com.dangdang.ddframe.rdb.sharding.api.HintManager;
import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.hint.ShardingKey;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class HintManagerHolder {
    public static final String DB_TABLE_NAME = "DB_TABLE_NAME";
    public static final String DB_COLUMN_NAME = "DB_COLUMN_NAME";
    private static final ThreadLocal<HintManager> HINT_MANAGER_HOLDER = new ThreadLocal();

    public static void setHintManager(HintManager hintManager) {
        Preconditions.checkState((null == HINT_MANAGER_HOLDER.get() ? 1 : 0) != 0, (Object)"HintManagerHolder has previous value, please clear first.");
        HINT_MANAGER_HOLDER.set(hintManager);
    }

    public static boolean isUseShardingHint() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isShardingHint();
    }

    public static Optional<ShardingValue<?>> getDatabaseShardingValue(ShardingKey shardingKey) {
        return HintManagerHolder.isUseShardingHint() ? Optional.fromNullable(HINT_MANAGER_HOLDER.get().getDatabaseShardingValue(shardingKey)) : Optional.absent();
    }

    public static Optional<ShardingValue<?>> getTableShardingValue(ShardingKey shardingKey) {
        return HintManagerHolder.isUseShardingHint() ? Optional.fromNullable(HINT_MANAGER_HOLDER.get().getTableShardingValue(shardingKey)) : Optional.absent();
    }

    public static boolean isMasterRouteOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isMasterRouteOnly();
    }

    public static boolean isDatabaseShardingOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HINT_MANAGER_HOLDER.get().isDatabaseShardingOnly();
    }

    public static void clear() {
        HINT_MANAGER_HOLDER.remove();
    }

    private HintManagerHolder() {
    }
}

