/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api;

import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Collections;

public final class ShardingValue<T extends Comparable<?>> {
    private final String logicTableName;
    private final String columnName;
    private final T value;
    private final Collection<T> values;
    private final Range<T> valueRange;

    public ShardingValue(String logicTableName, String columnName, T value) {
        this(logicTableName, columnName, value, Collections.emptyList(), null);
    }

    public ShardingValue(String logicTableName, String columnName, Collection<T> values) {
        this(logicTableName, columnName, null, values, null);
    }

    public ShardingValue(String logicTableName, String columnName, Range<T> valueRange) {
        this(logicTableName, columnName, null, Collections.emptyList(), valueRange);
    }

    public ShardingValueType getType() {
        if (null != this.value) {
            return ShardingValueType.SINGLE;
        }
        if (!this.values.isEmpty()) {
            return ShardingValueType.LIST;
        }
        return ShardingValueType.RANGE;
    }

    private ShardingValue(String logicTableName, String columnName, T value, Collection<T> values, Range<T> valueRange) {
        this.logicTableName = logicTableName;
        this.columnName = columnName;
        this.value = value;
        this.values = values;
        this.valueRange = valueRange;
    }

    public String getLogicTableName() {
        return this.logicTableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public T getValue() {
        return this.value;
    }

    public Collection<T> getValues() {
        return this.values;
    }

    public Range<T> getValueRange() {
        return this.valueRange;
    }

    public String toString() {
        return "ShardingValue(logicTableName=" + this.getLogicTableName() + ", columnName=" + this.getColumnName() + ", value=" + this.getValue() + ", values=" + this.getValues() + ", valueRange=" + this.getValueRange() + ")";
    }

    public static enum ShardingValueType {
        SINGLE,
        LIST,
        RANGE;

    }
}

