/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.transaction;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.orm.annotation.TransactionType;
import com.frameworkset.orm.transaction.TransactionException;
import com.frameworkset.orm.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCTransaction {
    private static Logger logger = LoggerFactory.getLogger(JDBCTransaction.class);
    private Map<Object, TransactionEntity> txentities = new HashMap<Object, TransactionEntity>(1);
    private Stack<TransactionEntity> executeStack = new Stack();
    private int count = 0;
    TransactionType currenttxtype;
    JDBCTransaction parent_tx = null;
    private int status = 5;

    public TransactionType getTXType() {
        return this.currenttxtype;
    }

    JDBCTransaction(TransactionType currenttxtype) {
        this.currenttxtype = currenttxtype;
    }

    JDBCTransaction(JDBCTransaction parent_tx, TransactionType currenttxtype) {
        this.parent_tx = parent_tx;
        this.currenttxtype = currenttxtype;
    }

    public Connection getConnection() throws TransactionException {
        return this.getConnection(null);
    }

    public void printStackTrace() {
        if (this.txentities != null && this.txentities.size() > 0) {
            for (Map.Entry<Object, TransactionEntity> entry : this.txentities.entrySet()) {
                if (entry.getValue() == null) continue;
                entry.getValue().printStackTrace();
            }
        }
    }

    protected void begin() throws TransactionException {
        if (this.wasRolledBack()) {
            throw new TransactionException("JDBCTransaction.begin() failed:TX has been RollBacked.");
        }
        if (this.wasCommitted()) {
            throw new TransactionException("JDBCTransaction.begin() failed:TX has been commited.");
        }
        if (this.status == 1) {
            throw new TransactionException("JDBCTransaction.begin() failed:TX has been MARKED ROLLBACK.");
        }
        this.increament();
    }

    protected void increament() {
        ++this.count;
    }

    public Connection getConnectionFromDS(DataSource datasource) throws TransactionException {
        if (this.wasRolledBack()) {
            throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnectionFromDS()\uff1aTX was RolledBack."));
        }
        if (this.wasCommitted()) {
            throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnectionFromDS\uff1aTX was committed."));
        }
        if (this.currenttxtype != TransactionManager.RW_TRANSACTION && this.status == 1) {
            throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnectionFromDS\uff1aTX was remarked rollingback."));
        }
        TransactionEntity txentity = null;
        try {
            txentity = this.txentities.get(datasource);
            if (this.status != 0) {
                this.status = 0;
            }
            Connection con = null;
            if (txentity == null) {
                con = datasource.getConnection();
                if (con == null) {
                    throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnectionFromDS\uff1aRequest connection  from datasource return null!"));
                }
                txentity = new TransactionEntity(con);
                txentity.increament();
                txentity.setStatus(0);
                this.txentities.put(datasource, txentity);
                this.executeStack.push(txentity);
            } else {
                if (txentity.getStatus() == 3 || txentity.getStatus() == 4 || txentity.getStatus() == 9) {
                    throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnectionFromDS\uff1aTransactionEntity.getStatus() == Status.STATUS_COMMITTED || TransactionEntity.getStatus() == Status.STATUS_MARKED_ROLLBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLEDBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLING_BACK"));
                }
                if (this.currenttxtype != TransactionManager.RW_TRANSACTION && txentity.getStatus() == 1) {
                    throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnectionFromDS\uff1aTransactionEntity.getStatus() == Status.STATUS_COMMITTED || TransactionEntity.getStatus() == Status.STATUS_MARKED_ROLLBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLEDBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLING_BACK"));
                }
                txentity.increament();
            }
            return txentity.getConnection();
        }
        catch (Throwable e) {
            if (txentity != null) {
                txentity.destroy();
                try {
                    this.executeStack.removeElement(txentity);
                }
                catch (Exception ie) {
                    logger.error("this.executeStack.removeElement(txentity) failed:", (Throwable)ie);
                }
                try {
                    this.txentities.remove(datasource);
                }
                catch (Exception ie) {
                    logger.error("this.txentities.remove(datasource) failed:", (Throwable)ie);
                }
            }
            throw new TransactionException(e);
        }
    }

    public Connection getConnection(String dbName) throws TransactionException {
        if (this.wasRolledBack()) {
            throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnection(dbName=" + dbName + ")\uff1aTX was RolledBack."));
        }
        if (this.wasCommitted()) {
            throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnection(dbName=" + dbName + ")\uff1aTX was committed."));
        }
        if (this.currenttxtype != TransactionManager.RW_TRANSACTION && this.status == 1) {
            throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnection(dbName=" + dbName + ")\uff1aTX was remarked rollingback."));
        }
        TransactionEntity txentity = null;
        String t_dbName = dbName == null ? SQLManager.getInstance().getDefaultDBName() : dbName;
        try {
            t_dbName = SQLManager.getRealDBNameFromExternalDBName(t_dbName);
            txentity = this.txentities.get(t_dbName);
            if (this.status != 0) {
                this.status = 0;
            }
            Connection con = null;
            if (txentity == null) {
                con = SQLManager.getInstance().requestConnection(t_dbName);
                if (con == null) {
                    throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnection(dbName=" + dbName + ")\uff1aRequest connection  from pool return null!"));
                }
                txentity = new TransactionEntity(con);
                txentity.increament();
                txentity.setStatus(0);
                this.txentities.put(t_dbName, txentity);
                this.executeStack.push(txentity);
            } else {
                if (txentity.getStatus() == 3 || txentity.getStatus() == 4 || txentity.getStatus() == 9) {
                    throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnection(dbName=" + dbName + ")\uff1aTransactionEntity.getStatus() == Status.STATUS_COMMITTED || TransactionEntity.getStatus() == Status.STATUS_MARKED_ROLLBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLEDBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLING_BACK"));
                }
                if (this.currenttxtype != TransactionManager.RW_TRANSACTION && txentity.getStatus() == 1) {
                    throw new TransactionException((Throwable)new SQLException("JDBCTransaction.getConnection(dbName=" + dbName + ")\uff1aTransactionEntity.getStatus() == Status.STATUS_COMMITTED || TransactionEntity.getStatus() == Status.STATUS_MARKED_ROLLBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLEDBACK|| TransactionEntity.getStatus() == Status.STATUS_ROLLING_BACK"));
                }
                txentity.increament();
            }
            return txentity.getConnection();
        }
        catch (Exception e) {
            if (txentity != null) {
                txentity.destroy();
                try {
                    this.executeStack.removeElement(txentity);
                }
                catch (Exception ie) {
                    logger.error("this.executeStack.removeElement(txentity) failed:", (Throwable)ie);
                }
                try {
                    this.txentities.remove(t_dbName);
                }
                catch (Exception ie) {
                    logger.error("this.txentities.remove(" + t_dbName + ") failed:", (Throwable)ie);
                }
            }
            throw new TransactionException((Throwable)e);
        }
    }

    public void closeIfRequired() throws TransactionException {
    }

    public void commitAndResetAutoCommit() throws SQLException {
    }

    public void rollbackAndResetAutoCommit() throws SQLException {
    }

    public void toggleAutoCommit() {
    }

    public boolean wasRolledBack() {
        return this.status == 4;
    }

    public boolean wasCommitted() {
        return this.status == 3;
    }

    public boolean isActive() {
        return false;
    }

    public void beforeTransactionCompletion() {
    }

    public void afterTransactionCompletion(int status) {
    }

    public void createTransaction() {
    }

    public boolean delistResource(XAResource arg0, int arg1) throws IllegalStateException, SystemException {
        return false;
    }

    public boolean enlistResource(XAResource arg0) throws RollbackException, IllegalStateException, SystemException {
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    protected void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.commit(null);
    }

    private void updataStatus(int status) {
        this.status = status;
    }

    public void decreament() {
        --this.count;
    }

    protected void commit(String dbName) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.status == 1) {
            System.out.println("\u6807\u8bb0\u4e3a\u5f85\u56de\u6eda\u7684\u4e8b\u52a1");
            throw new RollbackException("Commit " + dbName + " TX failed: TX MARKED_ROLLBACK");
        }
        this.decreament();
        if (this.count <= 0) {
            this.status = 7;
            try {
                this.commitAll();
                this.status = 3;
            }
            catch (SQLException e) {
                try {
                    this.setRollbackOnly();
                }
                catch (SystemException se) {
                    logger.error("this.setRollbackOnly(); failed:", (Throwable)se);
                }
                this.increament();
                throw new RollbackException(e.getMessage());
            }
        }
    }

    private void commitAll() throws SQLException {
        TransactionEntity txentity;
        while (this.executeStack.size() > 0 && (txentity = this.executeStack.pop()) != null) {
            txentity.commit();
        }
        this.txentities.clear();
    }

    private void rollbackAll() {
        TransactionEntity txentity;
        while (this.executeStack.size() > 0 && (txentity = this.executeStack.pop()) != null) {
            txentity.rollback();
        }
        this.txentities.clear();
    }

    public void registerSynchronization(Synchronization arg0) throws RollbackException, IllegalStateException, SystemException {
    }

    protected void rollback() throws IllegalStateException, SystemException {
        this.rollback(null);
    }

    protected void rollback(String dbName) throws IllegalStateException {
        if (this.status == 4) {
            throw new IllegalStateException("\u4e8b\u52a1\u5df2\u7ecf\u56de\u6eda");
        }
        if (this.status == 3) {
            throw new IllegalStateException("\u4e8b\u52a1\u5df2\u7ecf\u63d0\u4ea4");
        }
        this.decreament();
        if (this.count <= 0) {
            this.rollbackAll();
            this.status = 4;
        } else {
            try {
                this.setRollbackOnly();
            }
            catch (SystemException e) {
                logger.error("this.setRollbackOnly(); failed:", (Throwable)e);
            }
            if (this.currenttxtype != TransactionManager.RW_TRANSACTION) {
                this.rollbackAll();
            }
        }
    }

    protected JDBCTransaction getParent_tx() {
        return this.parent_tx;
    }

    class TransactionEntity {
        Connection con;
        private Exception createBy;
        private int status = 5;
        private boolean toggleAutoCommit = true;
        private int count;
        boolean errorflag = false;
        private static final String info = "Transaction Entity created on ";

        TransactionEntity(Connection originecon) throws SQLException {
            this.con = originecon;
            this.createBy = new Exception(info + new Date());
            try {
                this.toggleAutoCommit = this.con.getAutoCommit();
            }
            catch (SQLException e) {
                this.errorflag = true;
                throw e;
            }
            if (this.toggleAutoCommit && JDBCTransaction.this.currenttxtype != TransactionType.RW_TRANSACTION) {
                this.con.setAutoCommit(false);
            }
        }

        public void printStackTrace() {
            this.createBy.printStackTrace();
        }

        protected void increament() {
            ++this.count;
        }

        protected void decreament() {
            --this.count;
            if (this.count == 0) {
                this.status = 8;
            }
        }

        protected int getStatus() {
            return this.status;
        }

        protected void setStatus(int status) {
            this.status = status;
        }

        protected void commit() throws SQLException {
            try {
                if (this.con != null && JDBCTransaction.this.currenttxtype != TransactionType.RW_TRANSACTION) {
                    this.con.commit();
                }
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NestedSQLException(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (this.con != null && JDBCTransaction.this.currenttxtype != TransactionType.RW_TRANSACTION) {
                        this.con.setAutoCommit(this.toggleAutoCommit);
                    }
                }
                catch (SQLException e) {
                    logger.error("this.con.setAutoCommit(" + this.toggleAutoCommit + ") failed:", (Throwable)e);
                }
                try {
                    if (this.con != null) {
                        this.con.close();
                    }
                }
                catch (Exception exception) {}
                this.con = null;
            }
            this.status = 3;
        }

        protected void rollback() {
            try {
                this.status = 9;
                if (this.con != null && JDBCTransaction.this.currenttxtype != TransactionType.RW_TRANSACTION) {
                    this.con.rollback();
                }
                this.status = 4;
            }
            catch (SQLException e) {
                logger.error("this.con.rollback() failed:", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("this.con.rollback() failed:", (Throwable)e);
            }
            finally {
                this.count = 0;
                try {
                    if (this.con != null && JDBCTransaction.this.currenttxtype != TransactionType.RW_TRANSACTION) {
                        this.con.setAutoCommit(this.toggleAutoCommit);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                try {
                    if (this.con != null) {
                        this.con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.con = null;
                this.status = 4;
            }
        }

        protected void destroy() {
            if (this.con != null && !this.errorflag) {
                try {
                    if (JDBCTransaction.this.currenttxtype != TransactionType.RW_TRANSACTION) {
                        this.con.setAutoCommit(this.toggleAutoCommit);
                    }
                }
                catch (SQLException e) {
                    logger.error("this.con.setAutoCommit(" + this.toggleAutoCommit + ") failed:", (Throwable)e);
                }
                try {
                    if (!this.con.isClosed()) {
                        this.con.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected Connection getConnection() {
            return this.con;
        }
    }
}

