/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.platform;

import com.frameworkset.orm.platform.Platform;
import com.frameworkset.orm.platform.PlatformDefaultImpl;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformFactory {
    private static HashMap platforms = new HashMap();
    private static Logger log = LoggerFactory.getLogger(PlatformFactory.class);

    public static Platform getPlatformFor(String dbms) {
        Platform result = null;
        String platformName = null;
        result = (Platform)PlatformFactory.getPlatforms().get(dbms);
        if (result == null) {
            try {
                platformName = PlatformFactory.getClassnameFor(dbms);
                Class<?> platformClass = Class.forName(platformName);
                result = (Platform)platformClass.newInstance();
            }
            catch (Throwable t) {
                log.warn("problems with platform " + platformName + ": " + t.getMessage());
                log.warn("Torque will use PlatformDefaultImpl instead");
                result = new PlatformDefaultImpl();
            }
            PlatformFactory.getPlatforms().put(dbms, result);
        }
        return result;
    }

    private static String getClassnameFor(String platform) {
        String pf = "Default";
        if (platform != null) {
            pf = platform;
        }
        return "com.frameworkset.orm.platform.Platform" + pf.substring(0, 1).toUpperCase() + pf.substring(1) + "Impl";
    }

    private static HashMap getPlatforms() {
        return platforms;
    }
}

