/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.common.poolman.management.PoolManDeployer;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.common.poolman.util.SQLManager;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPoolDeployer
extends BaseTableManager
implements PoolManDeployer,
Serializable {
    public static boolean addShutdownHook = false;
    private static Logger logger = LoggerFactory.getLogger(LocalPoolDeployer.class);

    public static void shutdownHandle() {
        if (addShutdownHook) {
            return;
        }
        try {
            ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        BaseTableManager.updateTableInfo();
                        SQLManager.destroy();
                    }
                    catch (Exception e) {
                        logger.warn("Unable to properly shutdown: ", (Throwable)e);
                    }
                }
            }, (int)0x7FFFFFF6);
            addShutdownHook = true;
        }
        catch (Exception e) {
            addShutdownHook = true;
        }
    }

    @Override
    public void deployConfiguration(PoolManConfiguration config) throws Exception {
        this.startDataSources(config.getDataSources());
        LocalPoolDeployer.shutdownHandle();
    }

    @Override
    public void deployConfiguration(PoolManConfiguration config, String dbname) throws Exception {
        this.startDataSources(config.getDataSources());
    }

    public void deployConfiguration(PoolManConfiguration config, Map values) throws Exception {
        this.startDataSource(config.getDataSources(), values);
        LocalPoolDeployer.shutdownHandle();
    }

    private void startDataSources(ArrayList datasources) throws Exception {
        if (datasources == null) {
            return;
        }
        for (Properties dbprops : datasources) {
            JDBCPoolMetaData metadata = new JDBCPoolMetaData();
            BeanInfo beanInfo = Introspector.getBeanInfo(metadata.getClass());
            PropertyDescriptor[] attributes = beanInfo.getPropertyDescriptors();
            for (int n = 0; n < attributes.length; ++n) {
                String attrName = attributes[n].getName();
                if (!dbprops.containsKey(attrName.toLowerCase())) continue;
                String propsVal = dbprops.getProperty(attrName.toLowerCase());
                Class<Object> type = attributes[n].getPropertyType();
                if (type == Boolean.class) {
                    type = Boolean.TYPE;
                }
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                editor.setAsText(propsVal);
                Object value = editor.getValue();
                attributes[n].getWriteMethod().invoke((Object)metadata, value);
            }
            metadata.initDatasourceParameters();
            if (logger.isInfoEnabled()) {
                logger.info(" Created JDBC Connection Pool named {},config:{}", (Object)metadata.getName(), (Object)metadata.toString());
            }
            SQLManager.getInstance().createPool(metadata);
        }
    }

    private void startDataSource(ArrayList datasources, Map<String, String> values) throws Exception {
        if (datasources == null) {
            return;
        }
        Properties dbprops2 = null;
        for (Properties dbprops2 : datasources) {
            boolean useTemplate = false;
            if (values != null && values.size() > 0) {
                String dbname = values.get("dbname");
                String temp = (String)dbprops2.get("dbname");
                if (temp != null && dbname != null && (temp.equals(dbname) || temp.equals("${dbname}"))) {
                    useTemplate = true;
                }
            }
            JDBCPoolMetaData metadata = new JDBCPoolMetaData();
            BeanInfo beanInfo = Introspector.getBeanInfo(metadata.getClass());
            PropertyDescriptor[] attributes = beanInfo.getPropertyDescriptors();
            for (int n = 0; n < attributes.length; ++n) {
                String attrName = attributes[n].getName();
                if (!dbprops2.containsKey(attrName.toLowerCase())) continue;
                String propsVal = null;
                if (!useTemplate) {
                    propsVal = dbprops2.getProperty(attrName.toLowerCase());
                } else {
                    propsVal = values.get(attrName.toLowerCase());
                    if (propsVal == null) {
                        propsVal = dbprops2.getProperty(attrName.toLowerCase());
                    }
                }
                Class<Boolean> type = attributes[n].getPropertyType();
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                Object value = null;
                if (type.isAssignableFrom(Boolean.class)) {
                    if (propsVal != null && !propsVal.trim().equals("")) {
                        editor.setAsText(propsVal);
                        value = editor.getValue();
                    }
                } else {
                    editor.setAsText(propsVal);
                    value = editor.getValue();
                }
                attributes[n].getWriteMethod().invoke((Object)metadata, value);
            }
            metadata.initDatasourceParameters();
            if (logger.isInfoEnabled()) {
                logger.info(" Created JDBC Connection Pool named {},config:{}", (Object)metadata.getName(), (Object)metadata.toString());
            }
            JDBCPool jDBCPool = SQLManager.getInstance().createPool(metadata);
        }
    }
}

