/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vod;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Region;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.vod.FileUploadSession;
import com.baidubce.services.vod.model.CreateMediaResourceResponse;
import com.baidubce.services.vod.model.DeleteMediaResourceRequest;
import com.baidubce.services.vod.model.DeleteMediaResourceResponse;
import com.baidubce.services.vod.model.GenerateMediaDeliveryInfoRequest;
import com.baidubce.services.vod.model.GenerateMediaDeliveryInfoResponse;
import com.baidubce.services.vod.model.GenerateMediaIdRequest;
import com.baidubce.services.vod.model.GenerateMediaIdResponse;
import com.baidubce.services.vod.model.GenerateMediaPlayerCodeRequest;
import com.baidubce.services.vod.model.GenerateMediaPlayerCodeResponse;
import com.baidubce.services.vod.model.GetMediaResourceRequest;
import com.baidubce.services.vod.model.GetMediaResourceResponse;
import com.baidubce.services.vod.model.GetPlayableUrlRequest;
import com.baidubce.services.vod.model.GetPlayableUrlResponse;
import com.baidubce.services.vod.model.GetPlayerCodeRequest;
import com.baidubce.services.vod.model.GetPlayerCodeResponse;
import com.baidubce.services.vod.model.InternalCreateMediaRequest;
import com.baidubce.services.vod.model.InternalCreateMediaResponse;
import com.baidubce.services.vod.model.ListMediaResourceRequest;
import com.baidubce.services.vod.model.ListMediaResourceResponse;
import com.baidubce.services.vod.model.PublishMediaResourceRequest;
import com.baidubce.services.vod.model.PublishMediaResourceResponse;
import com.baidubce.services.vod.model.StopMediaResourceRequest;
import com.baidubce.services.vod.model.StopMediaResourceResponse;
import com.baidubce.services.vod.model.UpdateMediaResourceRequest;
import com.baidubce.services.vod.model.UpdateMediaResourceResponse;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PATH_MEDIA = "media";
    private static final String PATH_INTERNAL_MEDIA = "media/internal";
    private static final String PATH_SERVICE_CODE = "service/code";
    private static final String PATH_SERVICE_FILE = "service/file";
    private static final String PARA_PUBLISH = "publish";
    private static final String PARA_DISABLE = "disable";
    private static final String PARA_MEDIA_ID = "media_id";
    private static final String PARA_WIDTH = "width";
    private static final String PARA_HEIGHT = "height";
    private static final String PARA_AUTO_START = "auto_start";
    private static final String PARA_AUTO_START_NEW = "autostart";
    private static final String PARA_ATTRIBUTES = "attributes";
    private static final String PARA_APPLY = "apply";
    private static final String PARA_PROCESS = "process";
    private static final String PARA_GENDELIVERY = "delivery";
    private static final String PARA_GENCODE = "code";
    private static final String PARA_AK = "ak";
    private static final String PARA_PAGENO = "pageNo";
    private static final String PARA_PAGESIZE = "pageSize";
    private static final String PARA_STATUS = "status";
    private static final String PARA_BEGIN = "begin";
    private static final String PARA_END = "end";
    private static final String PARA_TITLE = "title";
    private static final int LIST_MAX_PAGESIZE = 1000;
    private static final int LIST_MIN_PAGESIZE = 1;
    private static final int MAX_SOURCE_EXTENSION_LENGTH = 10;
    private static Logger logger = LoggerFactory.getLogger(VodClient.class);
    private BosClient bosClient;
    private static final HttpResponseHandler[] responseHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VodClient(BceClientConfiguration vodConfig) {
        super(vodConfig, responseHandlers, true);
        BosClientConfiguration bosConfig = new BosClientConfiguration(vodConfig, null).withRegion(Region.CN_N1);
        this.bosClient = new BosClient(bosConfig);
    }

    VodClient(BceClientConfiguration vodConfig, BosClientConfiguration bosConfig) {
        super(vodConfig, responseHandlers, true);
        this.bosClient = new BosClient(bosConfig);
    }

    public CreateMediaResourceResponse createMediaResource(String title, String description, File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("The media file " + file.getAbsolutePath() + " doesn't exist!");
        }
        String sourceExtension = null;
        String filename = file.getName();
        if (filename.lastIndexOf(".") != -1 && ((sourceExtension = filename.substring(filename.lastIndexOf(".") + 1)).length() <= 0 || sourceExtension.length() > 10)) {
            sourceExtension = null;
        }
        GenerateMediaIdResponse generateMediaIdresponse = this.applyMedia();
        String bosKey = generateMediaIdresponse.getSourceKey();
        String mediaId = generateMediaIdresponse.getMediaId();
        String bucket = generateMediaIdresponse.getSourceBucket();
        logger.info("[bucket] = " + bucket + ", [bosKey] = " + bosKey + ", [mediaId] = " + mediaId);
        FileUploadSession session = new FileUploadSession(this.bosClient);
        CreateMediaResourceResponse response = new CreateMediaResourceResponse();
        if (session.upload(file, bucket, bosKey)) {
            InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description).withSourceExtension(sourceExtension);
            InternalCreateMediaResponse internalResponse = this.processMedia(request);
            response.setMediaId(internalResponse.getMediaId());
        }
        return response;
    }

    public CreateMediaResourceResponse createMediaResource(String sourceBucket, String sourceKey, String title, String description) {
        Validate.checkStringNotEmpty(sourceBucket, "sourceBucket should not be null or empty!");
        Validate.checkStringNotEmpty(sourceKey, "key should not be null or empty!");
        ObjectMetadata metaData = this.bosClient.getObjectMetadata(sourceBucket, sourceKey);
        Validate.checkIsTrue(metaData != null && metaData.getContentLength() > 0L, "The object corresponding to [bucket] = " + sourceBucket + ", [key] = " + sourceKey + " doesn't exist.");
        String sourceExtension = null;
        if (sourceKey.lastIndexOf(".") != -1 && ((sourceExtension = sourceKey.substring(sourceKey.lastIndexOf(".") + 1)).length() <= 0 || sourceExtension.length() > 10)) {
            sourceExtension = null;
        }
        GenerateMediaIdResponse generateMediaIdresponse = this.applyMedia();
        String mediaId = generateMediaIdresponse.getMediaId();
        String targetBucket = generateMediaIdresponse.getSourceBucket();
        String targetKey = generateMediaIdresponse.getSourceKey();
        this.bosClient.copyObject(sourceBucket, sourceKey, targetBucket, targetKey);
        InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description).withSourceExtension(sourceExtension);
        InternalCreateMediaResponse internalResponse = this.processMedia(request);
        CreateMediaResourceResponse response = new CreateMediaResourceResponse();
        response.setMediaId(internalResponse.getMediaId());
        return response;
    }

    public InternalCreateMediaResponse processMedia(InternalCreateMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_PROCESS, null);
        return this.invokeHttpClient(internalRequest, InternalCreateMediaResponse.class);
    }

    public GenerateMediaIdResponse applyMedia() {
        GenerateMediaIdRequest request = new GenerateMediaIdRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PATH_MEDIA);
        internalRequest.addParameter(PARA_APPLY, null);
        return this.invokeHttpClient(internalRequest, GenerateMediaIdResponse.class);
    }

    public GetMediaResourceResponse getMediaResource(String mediaId) {
        GetMediaResourceRequest request = new GetMediaResourceRequest().withMediaId(mediaId);
        return this.getMediaResource(request);
    }

    public GetMediaResourceResponse getMediaResource(GetMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId());
        return this.invokeHttpClient(internalRequest, GetMediaResourceResponse.class);
    }

    @Deprecated
    public ListMediaResourceResponse listMediaResources() {
        ListMediaResourceRequest request = new ListMediaResourceRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA);
        return this.invokeHttpClient(internalRequest, ListMediaResourceResponse.class);
    }

    public ListMediaResourceResponse listMediaResources(int pageNo, int pageSize, String status, Date begin, Date end, String title) {
        ListMediaResourceRequest request = new ListMediaResourceRequest().withPageNo(pageNo).withPageSize(pageSize).withStatus(status).withBegin(begin).withEnd(end).withTitle(title);
        return this.listMediaResources(request);
    }

    public ListMediaResourceResponse listMediaResources(ListMediaResourceRequest request) {
        Validate.checkIsTrue(request.getPageNo() > 0, "pageNo should greater than 0!");
        Validate.checkIsTrue(request.getPageSize() >= 1 && request.getPageSize() <= 1000, "pageSize is not Valid!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA);
        internalRequest.addParameter(PARA_PAGENO, String.valueOf(request.getPageNo()));
        internalRequest.addParameter(PARA_PAGESIZE, String.valueOf(request.getPageSize()));
        if (request.getStatus() != null) {
            internalRequest.addParameter(PARA_STATUS, request.getStatus());
        }
        if (request.getBegin() != null) {
            internalRequest.addParameter(PARA_BEGIN, DateUtils.formatAlternateIso8601Date(request.getBegin()));
        }
        if (request.getEnd() != null) {
            internalRequest.addParameter(PARA_END, DateUtils.formatAlternateIso8601Date(request.getEnd()));
        }
        if (request.getTitle() != null) {
            internalRequest.addParameter(PARA_TITLE, request.getTitle());
        }
        return this.invokeHttpClient(internalRequest, ListMediaResourceResponse.class);
    }

    public UpdateMediaResourceResponse updateMediaResource(String mediaId, String title, String description) {
        UpdateMediaResourceRequest request = new UpdateMediaResourceRequest().withMediaId(mediaId).withTitle(title).withDescription(description);
        return this.updateMediaResource(request);
    }

    public UpdateMediaResourceResponse updateMediaResource(UpdateMediaResourceRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_ATTRIBUTES, null);
        return this.invokeHttpClient(internalRequest, UpdateMediaResourceResponse.class);
    }

    public StopMediaResourceResponse stopMediaResource(String mediaId) {
        StopMediaResourceRequest request = new StopMediaResourceRequest().withMediaId(mediaId);
        return this.stopMediaResource(request);
    }

    public StopMediaResourceResponse stopMediaResource(StopMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_DISABLE, null);
        return this.invokeHttpClient(internalRequest, StopMediaResourceResponse.class);
    }

    public PublishMediaResourceResponse publishMediaResource(String mediaId) {
        PublishMediaResourceRequest request = new PublishMediaResourceRequest().withMediaId(mediaId);
        return this.publishMediaResource(request);
    }

    public PublishMediaResourceResponse publishMediaResource(PublishMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_PUBLISH, null);
        return this.invokeHttpClient(internalRequest, PublishMediaResourceResponse.class);
    }

    public DeleteMediaResourceResponse deleteMediaResource(String mediaId) {
        DeleteMediaResourceRequest request = new DeleteMediaResourceRequest().withMediaId(mediaId);
        return this.deleteMediaResource(request);
    }

    public DeleteMediaResourceResponse deleteMediaResource(DeleteMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PATH_MEDIA, request.getMediaId());
        return this.invokeHttpClient(internalRequest, DeleteMediaResourceResponse.class);
    }

    @Deprecated
    public GetPlayableUrlResponse getPlayableUrl(String mediaId) {
        GetPlayableUrlRequest request = new GetPlayableUrlRequest().withMediaId(mediaId);
        return this.getPlayableUrl(request);
    }

    @Deprecated
    public GetPlayableUrlResponse getPlayableUrl(GetPlayableUrlRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_SERVICE_FILE);
        internalRequest.addParameter(PARA_MEDIA_ID, request.getMediaId());
        return this.invokeHttpClient(internalRequest, GetPlayableUrlResponse.class);
    }

    @Deprecated
    public GetPlayerCodeResponse getPlayerCode(String mediaId, int width, int height, boolean autoStart) {
        GetPlayerCodeRequest request = new GetPlayerCodeRequest().withMediaId(mediaId).withWidth(width).withHeight(height).withAutoStart(autoStart);
        return this.getPlayerCode(request);
    }

    @Deprecated
    public GetPlayerCodeResponse getPlayerCode(GetPlayerCodeRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        Validate.checkIsTrue(request.getHeight() > 0, "Height of playback view should be positive!");
        Validate.checkIsTrue(request.getWidth() > 0, "Width of playback view should be positive!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_SERVICE_CODE);
        internalRequest.addParameter(PARA_MEDIA_ID, request.getMediaId());
        internalRequest.addParameter(PARA_WIDTH, Integer.toString(request.getWidth()));
        internalRequest.addParameter(PARA_HEIGHT, Integer.toString(request.getHeight()));
        internalRequest.addParameter(PARA_AUTO_START, Boolean.toString(request.isAutoStart()));
        return this.invokeHttpClient(internalRequest, GetPlayerCodeResponse.class);
    }

    public GenerateMediaDeliveryInfoResponse generateMediaDeliveryInfo(String mediaId) {
        GenerateMediaDeliveryInfoRequest request = new GenerateMediaDeliveryInfoRequest().withMediaId(mediaId);
        return this.generateMediaDeliveryInfo(request);
    }

    public GenerateMediaDeliveryInfoResponse generateMediaDeliveryInfo(GenerateMediaDeliveryInfoRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId(), PARA_GENDELIVERY);
        return this.invokeHttpClient(internalRequest, GenerateMediaDeliveryInfoResponse.class);
    }

    public GenerateMediaPlayerCodeResponse generateMediaPlayerCode(String mediaId, int width, int height, boolean autoStart) {
        GenerateMediaPlayerCodeRequest request = new GenerateMediaPlayerCodeRequest().withMediaId(mediaId).withWidth(width).withHeight(height).withAutoStart(autoStart);
        return this.generateMediaPlayerCode(request);
    }

    public GenerateMediaPlayerCodeResponse generateMediaPlayerCode(GenerateMediaPlayerCodeRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        Validate.checkIsTrue(request.getHeight() > 0, "Height of playback view should be positive!");
        Validate.checkIsTrue(request.getWidth() > 0, "Width of playback view should be positive!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId(), PARA_GENCODE);
        internalRequest.addParameter(PARA_WIDTH, Integer.toString(request.getWidth()));
        internalRequest.addParameter(PARA_HEIGHT, Integer.toString(request.getHeight()));
        internalRequest.addParameter(PARA_AUTO_START_NEW, Boolean.toString(request.isAutoStart()));
        internalRequest.addParameter(PARA_AK, this.config.getCredentials().getAccessKeyId());
        return this.invokeHttpClient(internalRequest, GenerateMediaPlayerCodeResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }

    @Override
    public boolean isRegionSupported() {
        return false;
    }
}

