/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator;

import com.baidu.unbiz.fluentvalidator.ComplexResult;
import com.baidu.unbiz.fluentvalidator.Result;
import com.baidu.unbiz.fluentvalidator.ResultCollector;
import com.baidu.unbiz.fluentvalidator.ValidationError;
import com.baidu.unbiz.fluentvalidator.ValidationResult;
import com.baidu.unbiz.fluentvalidator.util.CollectionUtil;
import com.baidu.unbiz.fluentvalidator.util.Function;

public class ResultCollectors {
    public static ResultCollector<Result> toSimple() {
        return new SimpleResultCollectorImpl();
    }

    public static ResultCollector<ComplexResult> toComplex() {
        return new ComplexResultCollectorImpl();
    }

    static class ComplexResultCollectorImpl
    implements ResultCollector<ComplexResult> {
        ComplexResultCollectorImpl() {
        }

        @Override
        public ComplexResult toResult(ValidationResult result) {
            ComplexResult ret = new ComplexResult();
            if (result.isSuccess()) {
                ret.setIsSuccess(true);
            } else {
                ret.setIsSuccess(false);
                ret.setErrors(result.getErrors());
            }
            ret.setTimeElapsed(result.getTimeElapsed());
            return ret;
        }
    }

    static class SimpleResultCollectorImpl
    implements ResultCollector<Result> {
        SimpleResultCollectorImpl() {
        }

        @Override
        public Result toResult(ValidationResult result) {
            Result ret = new Result();
            if (result.isSuccess()) {
                ret.setIsSuccess(true);
            } else {
                ret.setIsSuccess(false);
                ret.setErrors(CollectionUtil.transform(result.getErrors(), new Function<ValidationError, String>(){

                    @Override
                    public String apply(ValidationError input) {
                        return input.getErrorMsg();
                    }
                }));
            }
            return ret;
        }
    }
}

