/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.fluentvalidator;

import com.baidu.unbiz.fluentvalidator.AnnotationValidator;
import com.baidu.unbiz.fluentvalidator.AnnotationValidatorCache;
import com.baidu.unbiz.fluentvalidator.Closure;
import com.baidu.unbiz.fluentvalidator.DefaultValidateCallback;
import com.baidu.unbiz.fluentvalidator.ResultCollector;
import com.baidu.unbiz.fluentvalidator.ValidateCallback;
import com.baidu.unbiz.fluentvalidator.ValidationResult;
import com.baidu.unbiz.fluentvalidator.Validator;
import com.baidu.unbiz.fluentvalidator.ValidatorChain;
import com.baidu.unbiz.fluentvalidator.ValidatorContext;
import com.baidu.unbiz.fluentvalidator.able.ListAble;
import com.baidu.unbiz.fluentvalidator.able.ToStringable;
import com.baidu.unbiz.fluentvalidator.annotation.NotThreadSafe;
import com.baidu.unbiz.fluentvalidator.annotation.Stateful;
import com.baidu.unbiz.fluentvalidator.exception.RuntimeValidateException;
import com.baidu.unbiz.fluentvalidator.registry.Registry;
import com.baidu.unbiz.fluentvalidator.registry.impl.SimpleRegistry;
import com.baidu.unbiz.fluentvalidator.support.GroupingHolder;
import com.baidu.unbiz.fluentvalidator.util.ArrayUtil;
import com.baidu.unbiz.fluentvalidator.util.CollectionUtil;
import com.baidu.unbiz.fluentvalidator.util.Function;
import com.baidu.unbiz.fluentvalidator.util.Preconditions;
import com.baidu.unbiz.fluentvalidator.util.ReflectionUtil;
import com.baidu.unbiz.fluentvalidator.validator.element.IterableValidatorElement;
import com.baidu.unbiz.fluentvalidator.validator.element.MultiValidatorElement;
import com.baidu.unbiz.fluentvalidator.validator.element.ValidatorElement;
import com.baidu.unbiz.fluentvalidator.validator.element.ValidatorElementList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
@Stateful
public class FluentValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluentValidator.class);
    private ValidatorElementList validatorElementList = new ValidatorElementList();
    private boolean isFailFast = true;
    private ValidatorContext context = new ValidatorContext();
    private ValidationResult result = new ValidationResult();
    protected ValidateCallback defaultCb = new DefaultValidateCallback();
    private Registry registry = new SimpleRegistry();
    private int lastAddCount = 0;
    private Class<?>[] groups;
    private Class<?>[] excludeGroups;

    public FluentValidator putAttribute2Context(String key, Object value) {
        if (this.context == null) {
            this.context = new ValidatorContext();
        }
        this.context.setAttribute(key, value);
        return this;
    }

    public FluentValidator putClosure2Context(String key, Closure value) {
        if (this.context == null) {
            this.context = new ValidatorContext();
        }
        this.context.setClosure(key, value);
        return this;
    }

    protected FluentValidator() {
    }

    public static FluentValidator checkAll() {
        return FluentValidator.checkAll(null);
    }

    public static FluentValidator checkAll(Class ... groups) {
        return new FluentValidator().setGroups(groups);
    }

    public FluentValidator failFast() {
        this.isFailFast = true;
        return this;
    }

    public FluentValidator failOver() {
        this.isFailFast = false;
        return this;
    }

    public FluentValidator configure(Registry registry) {
        Preconditions.checkNotNull(registry, "Registry should not be NULL");
        this.registry = registry;
        return this;
    }

    public <T> FluentValidator on(T t) {
        MultiValidatorElement multiValidatorElement = this.doOn(t);
        LOGGER.debug(multiValidatorElement + " will be performed");
        this.lastAddCount = multiValidatorElement.size();
        return this;
    }

    public <T> FluentValidator onEach(T[] t) {
        if (ArrayUtil.isEmpty(t)) {
            this.lastAddCount = 0;
            return this;
        }
        return this.onEach(Arrays.asList(t));
    }

    public <T> FluentValidator onEach(Collection<T> t) {
        if (CollectionUtil.isEmpty(t)) {
            this.lastAddCount = 0;
            return this;
        }
        MultiValidatorElement multiValidatorElement = null;
        for (T element : t) {
            multiValidatorElement = this.doOn(element);
            this.lastAddCount += multiValidatorElement.size();
        }
        LOGGER.debug(String.format("Total %d of %s will be performed", t.size(), multiValidatorElement));
        return this;
    }

    protected <T> MultiValidatorElement doOn(final T t) {
        if (this.registry == null) {
            throw new RuntimeValidateException("When annotation-based validation enabled, one must use configure(Registry) method to let FluentValidator know where to search and get validator instances");
        }
        List<AnnotationValidator> anntValidatorsOfAllFields = AnnotationValidatorCache.getAnnotationValidator(this.registry, t);
        if (CollectionUtil.isEmpty(anntValidatorsOfAllFields)) {
            return new MultiValidatorElement(Collections.EMPTY_LIST);
        }
        ArrayList<ValidatorElement> elementList = CollectionUtil.createArrayList();
        for (final AnnotationValidator anntValidatorOfOneField : anntValidatorsOfAllFields) {
            Object realTarget = ReflectionUtil.invokeMethod(anntValidatorOfOneField.getMethod(), t, new Object[0]);
            if (!CollectionUtil.isEmpty(anntValidatorOfOneField.getValidators())) {
                if (!ArrayUtil.hasIntersection(anntValidatorOfOneField.getGroups(), this.groups)) {
                    LOGGER.debug(String.format("Current groups: %s not match %s", Arrays.toString(this.groups), anntValidatorOfOneField));
                    continue;
                }
                if (!ArrayUtil.isEmpty(this.excludeGroups) && ArrayUtil.hasIntersection(anntValidatorOfOneField.getGroups(), this.excludeGroups)) {
                    LOGGER.debug(String.format("Current groups: %s will be ignored because you specify %s", Arrays.toString(this.excludeGroups), anntValidatorOfOneField));
                    continue;
                }
                for (final Validator v : anntValidatorOfOneField.getValidators()) {
                    elementList.add(new ValidatorElement(realTarget, v, new ToStringable(){

                        @Override
                        public String toString() {
                            return String.format("%s#%s@%s", t.getClass().getSimpleName(), anntValidatorOfOneField.getField().getName(), v);
                        }
                    }));
                }
            }
            if (!anntValidatorOfOneField.isCascade()) continue;
            Field field = anntValidatorOfOneField.getField();
            if (Collection.class.isAssignableFrom(field.getType())) {
                this.onEach((Collection)realTarget);
                continue;
            }
            if (field.getType().isArray()) {
                this.onEach(ArrayUtil.toWrapperIfPrimitive(realTarget));
                continue;
            }
            this.on(realTarget);
        }
        MultiValidatorElement m = new MultiValidatorElement(elementList);
        this.validatorElementList.add(m);
        return m;
    }

    public <T> FluentValidator on(T t, Validator<T> v) {
        Preconditions.checkNotNull(v, "Validator should not be NULL");
        this.doAdd(new ValidatorElement(t, v));
        this.lastAddCount = 1;
        return this;
    }

    public <T> FluentValidator on(T t, ValidatorChain chain) {
        Preconditions.checkNotNull(chain, "ValidatorChain should not be NULL");
        if (CollectionUtil.isEmpty(chain.getValidators())) {
            this.lastAddCount = 0;
        } else {
            for (Validator v : chain.getValidators()) {
                this.doAdd(new ValidatorElement(t, v));
            }
            this.lastAddCount = chain.getValidators().size();
        }
        return this;
    }

    public <T> FluentValidator onEach(T[] t, Validator<T> v) {
        Preconditions.checkNotNull(v, "Validator should not be NULL");
        if (ArrayUtil.isEmpty(t)) {
            this.lastAddCount = 0;
            return this;
        }
        return this.onEach(Arrays.asList(t), v);
    }

    public <T> FluentValidator onEach(Collection<T> t, final Validator<T> v) {
        Preconditions.checkNotNull(v, "Validator should not be NULL");
        if (CollectionUtil.isEmpty(t)) {
            this.lastAddCount = 0;
        } else {
            List<ValidatorElement> elementList = CollectionUtil.transform(t, new Function<T, ValidatorElement>(){

                @Override
                public ValidatorElement apply(T elem) {
                    return new ValidatorElement(elem, v);
                }
            });
            this.lastAddCount = t.size();
            this.doAdd(new IterableValidatorElement(elementList));
        }
        return this;
    }

    protected void doAdd(ListAble<ValidatorElement> listAble) {
        this.validatorElementList.add(listAble);
        LOGGER.debug(listAble + " will be performed");
    }

    public FluentValidator when(boolean expression) {
        if (!expression) {
            for (int i = 0; i < this.lastAddCount; ++i) {
                this.validatorElementList.getList().removeLast();
            }
        }
        return this;
    }

    public FluentValidator doValidate() {
        return this.doValidate(this.defaultCb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluentValidator doValidate(ValidateCallback cb) {
        Preconditions.checkNotNull(cb, "ValidateCallback should not be NULL");
        if (this.validatorElementList.isEmpty()) {
            LOGGER.debug("Nothing to validate");
            return this;
        }
        this.context.setResult(this.result);
        LOGGER.debug("Start to validate through " + this.validatorElementList);
        long start = System.currentTimeMillis();
        try {
            GroupingHolder.setGrouping(this.groups);
            for (ValidatorElement element : this.validatorElementList.getAllValidatorElements()) {
                Object target = element.getTarget();
                Validator v = element.getValidator();
                try {
                    if (!v.accept(this.context, target) || v.validate(this.context, target)) continue;
                    this.result.setIsSuccess(false);
                    if (!this.isFailFast) continue;
                    break;
                }
                catch (Exception e) {
                    try {
                        v.onException(e, this.context, target);
                        cb.onUncaughtException(v, e, target);
                    }
                    catch (Exception e1) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.error(v + " onException or onUncaughtException throws exception due to " + e1.getMessage(), (Throwable)e1);
                        }
                        throw new RuntimeValidateException(e1);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error(v + " failed due to " + e.getMessage(), (Throwable)e);
                    }
                    throw new RuntimeValidateException(e);
                }
            }
            if (this.result.isSuccess()) {
                cb.onSuccess(this.validatorElementList);
            } else {
                cb.onFail(this.validatorElementList, this.result.getErrors());
            }
        }
        finally {
            GroupingHolder.clean();
            int timeElapsed = (int)(System.currentTimeMillis() - start);
            LOGGER.debug("End to validate through" + this.validatorElementList + " costing " + timeElapsed + "ms with " + "isSuccess=" + this.result.isSuccess());
            this.result.setTimeElapsed(timeElapsed);
        }
        return this;
    }

    public <T> T result(ResultCollector<T> resultCollector) {
        return resultCollector.toResult(this.result);
    }

    public FluentValidator setGroups(Class<?>[] groups) {
        this.groups = groups;
        return this;
    }

    public FluentValidator setIsFailFast(boolean isFailFast) {
        this.isFailFast = isFailFast;
        return this;
    }

    public FluentValidator setExcludeGroups(Class<?>[] excludeGroups) {
        this.excludeGroups = excludeGroups;
        return this;
    }
}

