/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.ant.groovy.GroovycSupport;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.remote.DistributedConfig;
import com.atlassian.maven.plugin.clover.DistributedCoverage;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.instrumentation.MainInstrumenter;
import com.atlassian.maven.plugin.clover.internal.instrumentation.TestInstrumenter;
import com.atlassian.maven.plugin.clover.internal.scanner.LanguageFileExtensionFilter;
import com.atlassian.maven.plugin.clover.internal.scanner.MainSourceScanner;
import com.atlassian.maven.plugin.clover.internal.scanner.TestSourceScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverInstrumentInternalMojo
extends AbstractCloverMojo
implements CompilerConfiguration {
    private List<Artifact> pluginArtifacts;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    protected List repositories;
    private String includesList = null;
    private String excludesList = null;
    private Set<String> includes = new HashSet<String>(Arrays.asList("**/*.java", "**/*.groovy"));
    private Set<String> excludes = new HashSet<String>();
    private Map<String, String> methodContexts = new HashMap<String, String>();
    private Map<String, String> statementContexts = new HashMap<String, String>();
    private boolean includesAllSourceRoots;
    private boolean includesTestSourceRoots;
    private boolean useFullyQualifiedJavaLang;
    private boolean useCloverClassifier = true;
    private String encoding;
    private int staleMillis;
    private DistributedCoverage distributedCoverage;
    private String instrumentation;
    private long cloveredArtifactExpiryInMillis;
    private String scope;
    private boolean copyExcludedFiles = true;
    private boolean skipGroverJar = false;
    private File groverJar;
    private boolean setTestFailureIgnore = false;
    private static Map<String, String> originalSrcMap = new HashMap<String, String>();
    private static Map<String, String> originalSrcTestMap = new HashMap<String, String>();

    public static String getOriginalSrcDir(String module) {
        return originalSrcMap.get(module);
    }

    public static String getOriginalSrcTestDir(String module) {
        return originalSrcTestMap.get(module);
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping clover instrumentation.");
            return;
        }
        this.configureTestFailureIgnore();
        CloverInstrumentInternalMojo.resetSrcDirsOriginal(this.getProject().getArtifact(), this);
        File outDir = new File(this.cloverOutputDirectory, this.getSrcName());
        String cloverOutputSourceDirectory = outDir.getPath();
        String cloverOutputTestSourceDirectory = new File(this.cloverOutputDirectory, this.getSrcTestName()).getPath();
        new File(this.resolveCloverDatabase()).getParentFile().mkdirs();
        super.execute();
        this.logArtifacts("before changes");
        MainInstrumenter mainInstrumenter = new MainInstrumenter(this, cloverOutputSourceDirectory);
        TestInstrumenter testInstrumenter = new TestInstrumenter(this, cloverOutputTestSourceDirectory);
        if (this.isJavaProject()) {
            mainInstrumenter.instrument();
            if (this.includesTestSourceRoots) {
                testInstrumenter.instrument();
            }
        }
        this.addCloverDependencyToCompileClasspath();
        this.swizzleCloverDependencies();
        String originalSrcDir = mainInstrumenter.redirectSourceDirectories();
        originalSrcMap.put(this.getProject().getId(), originalSrcDir);
        if (this.includesTestSourceRoots) {
            String originalSrcTestDir = testInstrumenter.redirectSourceDirectories();
            originalSrcTestMap.put(this.getProject().getId(), originalSrcTestDir);
        }
        this.injectGrover(outDir);
        this.redirectOutputDirectories();
        this.redirectArtifact();
        this.logArtifacts("after changes");
    }

    private void configureTestFailureIgnore() {
        if (this.setTestFailureIgnore) {
            this.getLog().debug((CharSequence)"Configuring testFailureIgnore=true and failOnViolation=false");
            Properties properties = this.getProject().getProperties();
            properties.put("maven.test.failure.ignore", "true");
            properties.put("checkstyle.failOnViolation", "false");
            properties.put("pmd.failOnViolation", "false");
        }
    }

    private void injectGrover(File outDir) {
        if (this.skipGroverJar) {
            this.getLog().info((CharSequence)"Generation of Clover Groovy configuration is disabled. No Groovy instrumentation will occur.");
            return;
        }
        InstrumentationConfig config = new InstrumentationConfig();
        config.setProjectName(this.getProject().getName());
        config.setInitstring(this.resolveCloverDatabase());
        config.setTmpDir(outDir);
        List<File> includeFiles = this.calcIncludedFilesForGroovy();
        this.getLog().debug((CharSequence)("Clover including the following files for Groovy instrumentation: " + includeFiles));
        config.setIncludedFiles(includeFiles);
        config.setEnabled(true);
        config.setEncoding(this.getEncoding());
        config.setDistributedConfig(this.getDistributedCoverage() == null ? null : new DistributedConfig(this.getDistributedCoverage().getConfigString()));
        try {
            File groverJar = GroovycSupport.extractGroverJar((File)this.groverJar, (boolean)false);
            File groverConfigDir = GroovycSupport.newConfigDir((InstrumentationConfig)config, (File)new File(this.getProject().getBuild().getOutputDirectory()));
            Resource groverConfigResource = new Resource();
            groverConfigResource.setDirectory(groverConfigDir.getPath());
            this.getProject().addResource(groverConfigResource);
            Artifact cloverArtifact = this.findCloverArtifact(this.pluginArtifacts);
            Artifact groverArtifact = this.artifactFactory.createBuildArtifact(cloverArtifact.getGroupId(), "grover", cloverArtifact.getVersion(), "jar");
            groverArtifact.setFile(groverJar);
            groverArtifact.setScope("system");
            this.addArtifactDependency(groverArtifact);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not create Clover Groovy configuration file. No Groovy instrumentation will occur. " + e.getMessage()), (Throwable)e);
        }
    }

    protected List<File> calcIncludedFilesForGroovy() {
        MainSourceScanner groovyMainScanner = new MainSourceScanner(this, this.getProject().getBuild().getOutputDirectory());
        ArrayList<File> mainGroovyFiles = this.extractIncludes(groovyMainScanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.GROOVY_LANGUAGE, false));
        TestSourceScanner groovyTestScanner = new TestSourceScanner(this, this.getProject().getBuild().getOutputDirectory());
        ArrayList<File> testGroovyFiles = this.extractIncludes(groovyTestScanner.getSourceFilesToInstrument(LanguageFileExtensionFilter.GROOVY_LANGUAGE, false));
        ArrayList<File> allSources = new ArrayList<File>(mainGroovyFiles);
        allSources.addAll(testGroovyFiles);
        return allSources;
    }

    private ArrayList<File> extractIncludes(Map<String, String[]> srcFiles) {
        ArrayList<File> includeFiles = new ArrayList<File>();
        for (String dirName : srcFiles.keySet()) {
            String[] includes;
            for (String include : includes = srcFiles.get(dirName)) {
                includeFiles.add(new File(dirName, include));
            }
        }
        return includeFiles;
    }

    public static void resetSrcDirsOriginal(Artifact artifact, CompilerConfiguration config) {
        if (originalSrcMap.containsKey(artifact.getId())) {
            String sourceDirectory = originalSrcMap.get(artifact.getId());
            MainInstrumenter mainInstrumenter = new MainInstrumenter(config, sourceDirectory);
            mainInstrumenter.redirectSourceDirectories();
        }
        if (originalSrcTestMap.containsKey(artifact.getId())) {
            String testDirectory = originalSrcTestMap.get(artifact.getId());
            TestInstrumenter instrumenter = new TestInstrumenter(config, testDirectory);
            instrumenter.redirectSourceDirectories();
        }
    }

    protected String getSrcTestName() {
        return "src-test";
    }

    protected String getSrcName() {
        return "src";
    }

    private boolean isJavaProject() {
        ArtifactHandler artifactHandler = this.getProject().getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            this.getLog().warn((CharSequence)("The reported language of this project is " + artifactHandler.getLanguage() + ", attempting to instrument sources anyway."));
        }
        return true;
    }

    protected void redirectOutputDirectories() {
        this.getProject().getBuild().setDirectory(this.cloverOutputDirectory);
        this.getProject().getBuild().setOutputDirectory(new File(this.cloverOutputDirectory, "classes").getPath());
        this.getProject().getBuild().setTestOutputDirectory(new File(this.cloverOutputDirectory, "test-classes").getPath());
    }

    protected void redirectArtifact() {
        if (!this.getProject().getPackaging().equals("pom")) {
            Artifact oldArtifact = this.getProject().getArtifact();
            Artifact newArtifact = this.artifactFactory.createArtifactWithClassifier(oldArtifact.getGroupId(), oldArtifact.getArtifactId(), oldArtifact.getVersion(), oldArtifact.getType(), "clover");
            this.getProject().setArtifact(newArtifact);
            String finalName = this.getProject().getBuild().getFinalName() == null ? this.getProject().getArtifactId() + "-" + this.getProject().getVersion() : this.getProject().getBuild().getFinalName();
            this.getProject().getBuild().setFinalName(finalName + (this.useCloverClassifier ? "-clover" : ""));
        }
    }

    private void swizzleCloverDependencies() {
        Set<Artifact> swizzledDependencyArtifacts = this.swizzleCloverDependencies(this.getProject().getDependencyArtifacts());
        Set artifacts = this.getProject().getArtifacts();
        Set dependencyArtifacts = this.getProject().getDependencyArtifacts();
        artifacts.removeAll(dependencyArtifacts);
        Set<Artifact> swizzledArtifacts = this.swizzleCloverDependencies(artifacts);
        swizzledArtifacts.addAll(swizzledDependencyArtifacts);
        this.getProject().setDependencyArtifacts(swizzledDependencyArtifacts);
        this.getProject().setArtifacts(swizzledArtifacts);
    }

    protected Set<Artifact> swizzleCloverDependencies(Set<Artifact> artifacts) {
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.getClassifier() == null) {
                Artifact cloveredArtifact = this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), "clover");
                try {
                    this.artifactResolver.resolve(cloveredArtifact, new ArrayList(), this.localRepository);
                    cloveredArtifact.setScope(artifact.getScope());
                    if (cloveredArtifact.getFile().lastModified() + this.cloveredArtifactExpiryInMillis < artifact.getFile().lastModified()) {
                        this.getLog().warn((CharSequence)("Using [" + artifact.getId() + "], built on " + new Date(artifact.getFile().lastModified()) + " even though a Clovered version exists " + "but it's older (lastModified: " + new Date(cloveredArtifact.getFile().lastModified()) + " ) and could fail the build. Please consider running Clover again on that " + "dependency's project."));
                        resolvedArtifacts.add(artifact);
                        continue;
                    }
                    resolvedArtifacts.add(cloveredArtifact);
                }
                catch (ArtifactResolutionException e) {
                    this.getLog().warn((CharSequence)("Skipped dependency [" + artifact.getId() + "] due to resolution error: " + e.getMessage()));
                    resolvedArtifacts.add(artifact);
                }
                catch (ArtifactNotFoundException e) {
                    this.getLog().debug((CharSequence)("Skipped dependency [" + artifact.getId() + "] as the clovered artifact could not be found"));
                    resolvedArtifacts.add(artifact);
                }
                continue;
            }
            this.getLog().debug((CharSequence)("Skipped dependency [" + artifact.getId() + "] as it has a classifier"));
            resolvedArtifacts.add(artifact);
        }
        return resolvedArtifacts;
    }

    protected Artifact findCloverArtifact(List<Artifact> pluginArtifacts) {
        Artifact cloverArtifact = null;
        Iterator<Artifact> artifactsIterator = pluginArtifacts.iterator();
        while (artifactsIterator.hasNext() && cloverArtifact == null) {
            Artifact artifact = artifactsIterator.next();
            if (!"com.cenqua.clover".equals(artifact.getGroupId()) || !"clover".equals(artifact.getArtifactId())) continue;
            cloverArtifact = artifact;
        }
        return cloverArtifact;
    }

    private void addCloverDependencyToCompileClasspath() throws MojoExecutionException {
        Artifact cloverArtifact = this.findCloverArtifact(this.pluginArtifacts);
        if (cloverArtifact == null) {
            throw new MojoExecutionException("Couldn't find [com.cenqua.clover:clover] artifact in plugin dependencies");
        }
        String jarScope = this.scope == null ? "provided" : this.scope;
        cloverArtifact = this.artifactFactory.createArtifact(cloverArtifact.getGroupId(), cloverArtifact.getArtifactId(), cloverArtifact.getVersion(), jarScope, cloverArtifact.getType());
        try {
            this.artifactResolver.resolve(cloverArtifact, this.repositories, this.localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Could not resolve the clover artifact ( " + cloverArtifact.getId() + " ) in the localRepository: " + this.localRepository.getUrl(), (Exception)((Object)e));
        }
        this.addArtifactDependency(cloverArtifact);
    }

    private void addArtifactDependency(Artifact cloverArtifact) {
        LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>(this.getProject().getDependencyArtifacts());
        set.add(cloverArtifact);
        this.getProject().setDependencyArtifacts(set);
    }

    private void logArtifacts(String message) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("[Clover] List of dependency artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getDependencyArtifacts());
            this.getLog().debug((CharSequence)("[Clover] List of artifacts " + message + ":"));
            this.logArtifacts(this.getProject().getArtifacts());
        }
    }

    private void logArtifacts(Set<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("[Clover]   Artifact [" + artifact.getId() + "], scope = [" + artifact.getScope() + "]"));
        }
    }

    protected void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    protected void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    @Override
    public Set<String> getIncludes() {
        if (this.includesList == null) {
            return this.includes;
        }
        return new HashSet<String>(Arrays.asList(this.includesList.split(",")));
    }

    @Override
    public Set<String> getExcludes() {
        if (this.excludesList == null) {
            return this.excludes;
        }
        this.excludes.addAll(Arrays.asList(this.excludesList.split(",")));
        return this.excludes;
    }

    @Override
    public boolean includesAllSourceRoots() {
        return this.includesAllSourceRoots;
    }

    @Override
    public boolean isUseFullyQualifiedJavaLang() {
        return this.useFullyQualifiedJavaLang;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Map<String, String> getMethodContexts() {
        return this.methodContexts;
    }

    @Override
    public Map<String, String> getStatementContexts() {
        return this.statementContexts;
    }

    @Override
    public int getStaleMillis() {
        return this.staleMillis;
    }

    @Override
    public String getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public boolean copyExcludedFiles() {
        return this.copyExcludedFiles;
    }

    @Override
    public DistributedCoverage getDistributedCoverage() {
        return this.distributedCoverage;
    }
}

