/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.maven.plugin.clover.CloverSetupMojo;
import com.atlassian.maven.plugin.clover.MvnLogBuildListener;
import com.atlassian.maven.plugin.clover.MvnLogger;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.CloverSnapshotTask;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.test.optimization.SnapshotPrinter;
import java.io.File;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class CloverSnapshotMojo
extends AbstractCloverMojo {
    private String span;
    private boolean forceSnapshot;

    public void execute() throws MojoExecutionException {
        MavenProject lastProject = (MavenProject)this.getReactorProjects().get(this.getReactorProjects().size() - 1);
        MavenProject thisProject = this.getProject();
        if (this.isSingleCloverDatabase() && !thisProject.equals((Object)lastProject) && !this.forceSnapshot) {
            this.getLog().info((CharSequence)"Skipping snapshot until the final project in the reactor.");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping snapshot.");
            return;
        }
        if (!new File(this.resolveCloverDatabase()).exists()) {
            this.getLog().info((CharSequence)(this.resolveCloverDatabase() + " does not exist. Skipping snapshot creation."));
            return;
        }
        CloverSnapshotTask task = this.createSnapshotTask();
        task.setInitString(this.resolveCloverDatabase());
        task.setDebug(this.debug);
        if (this.span != null) {
            task.setSpan(this.span);
        } else if (CloverSetupMojo.START_DATE != null) {
            long timeSinceStart = new Date().getTime() - CloverSetupMojo.START_DATE.getTime();
            String interval = (timeSinceStart + 1000L) / 1000L + "s";
            this.getLog().info((CharSequence)("No span specified, using span of: " + interval));
            task.setSpan(interval);
        }
        this.snapshot = new ConfigUtil(this).resolveSnapshotFile(this.snapshot);
        this.snapshot.getParentFile().mkdirs();
        this.getLog().info((CharSequence)("Saving snapshot to: " + this.snapshot));
        task.setFile(this.snapshot);
        this.execTask(task);
        if (this.getLog().isDebugEnabled() || this.debug) {
            String cpLocation = this.snapshot != null ? this.snapshot.getPath() : task.getInitString() + ".snapshot";
            SnapshotPrinter.prettyPrint((Snapshot)Snapshot.loadFrom((String)cpLocation), (Logger)new MvnLogger(this.getLog()), (int)3);
        }
    }

    protected void execTask(CloverSnapshotTask task) {
        task.execute();
    }

    CloverSnapshotTask createSnapshotTask() {
        CloverSnapshotTask task = new CloverSnapshotTask();
        Project antProj = new Project();
        antProj.init();
        antProj.addBuildListener((BuildListener)new MvnLogBuildListener(this.getLog()));
        task.setProject(antProj);
        task.init();
        return task;
    }
}

