/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.worker;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelProcessor;
import com.alicloud.openservices.tablestore.tunnel.worker.TunnelWorker;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelWorkerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TunnelWorker.class);
    private static final int CORE_POOL_SIZE = 32;
    private static final int KEEP_ALIVE_SECONDS = 60;
    private static final int MAX_CORE_POOL_SIZE = 1000;
    private static final int BLOCKING_QUEUE_SIZE = 16;
    private static final int HEARTBEAT_MIN_INTERVAL_SEC = 5;
    private long heartbeatTimeoutInSec = 300L;
    private long heartbeatIntervalInSec = 30L;
    private long checkpointIntervalInMillis = 5000L;
    private String clientTag = System.getProperty("os.name");
    private IChannelProcessor channelProcessor;
    private ThreadPoolExecutor readRecordsExecutor = this.newDefaultThreadPool("read-records-executor-");
    private ThreadPoolExecutor processRecordsExecutor = this.newDefaultThreadPool("process-records-executor-");

    public TunnelWorkerConfig(IChannelProcessor processor) {
        this.channelProcessor = processor;
    }

    public long getHeartbeatTimeoutInSec() {
        return this.heartbeatTimeoutInSec;
    }

    public void setHeartbeatTimeoutInSec(long heartbeatTimeoutInSec) {
        Preconditions.checkArgument(heartbeatTimeoutInSec > this.heartbeatIntervalInSec, "heartbeat timeout should larger than heartbeat interval.");
        this.heartbeatTimeoutInSec = heartbeatTimeoutInSec;
    }

    public long getHeartbeatIntervalInSec() {
        return this.heartbeatIntervalInSec;
    }

    public void setHeartbeatIntervalInSec(long heartbeatIntervalInSec) {
        Preconditions.checkArgument(heartbeatIntervalInSec > 5L, "heartbeat interval must greater than or equal to %d seconds.", 5);
        this.heartbeatIntervalInSec = heartbeatIntervalInSec;
    }

    public String getClientTag() {
        return this.clientTag;
    }

    public void setClientTag(String clientTag) {
        this.clientTag = clientTag;
    }

    public IChannelProcessor getChannelProcessor() {
        return this.channelProcessor;
    }

    public void setChannelProcessor(IChannelProcessor channelProcessor) {
        this.channelProcessor = channelProcessor;
    }

    public long getCheckpointIntervalInMillis() {
        return this.checkpointIntervalInMillis;
    }

    public void setCheckpointIntervalInMillis(long checkpointIntervalInMillis) {
        this.checkpointIntervalInMillis = checkpointIntervalInMillis;
    }

    public ThreadPoolExecutor getReadRecordsExecutor() {
        return this.readRecordsExecutor;
    }

    public void setReadRecordsExecutor(ThreadPoolExecutor readRecordsExecutor) {
        this.readRecordsExecutor = readRecordsExecutor;
    }

    public ThreadPoolExecutor getProcessRecordsExecutor() {
        return this.processRecordsExecutor;
    }

    public void setProcessRecordsExecutor(ThreadPoolExecutor processRecordsExecutor) {
        this.processRecordsExecutor = processRecordsExecutor;
    }

    private ThreadPoolExecutor newDefaultThreadPool(final String threadPrefix) {
        return new ThreadPoolExecutor(32, 1000, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(16), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                String threadName = threadPrefix + this.counter.getAndIncrement();
                LOG.info("TunnelWorkerConfig new thread: " + threadName);
                return new Thread(r, threadName);
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void shutdown() {
        LOG.info("shutdown read records executor");
        this.readRecordsExecutor.shutdownNow();
        LOG.info("shutdown process records executor");
        this.processRecordsExecutor.shutdownNow();
    }
}

