/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model.query;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.timestream.internal.Utils;
import com.alicloud.openservices.tablestore.timestream.model.GetRangeIterator;
import com.alicloud.openservices.tablestore.timestream.model.GetRowIterator;
import com.alicloud.openservices.tablestore.timestream.model.PointIterator;
import com.alicloud.openservices.tablestore.timestream.model.TimeRange;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataQuery {
    private AsyncClient asyncClient;
    private String tableName;
    private List<String> columnToGet = new ArrayList<String>();
    private TimeRange timeRange;
    private long timestamp = -1L;

    public DataQuery(AsyncClient asyncClient, String tableName) {
        this.asyncClient = asyncClient;
        this.tableName = tableName;
    }

    protected void setColumnToGet(String ... columns) {
        this.columnToGet = Arrays.asList(columns);
    }

    protected void setTimeRange(TimeRange timeRange) {
        if (this.timestamp != -1L) {
            throw new ClientException("The timestamp has been set.");
        }
        this.timeRange = timeRange;
    }

    protected void setTimestamp(long timestamp, TimeUnit unit) {
        if (this.timeRange != null) {
            throw new ClientException("time range has been set");
        }
        if (timestamp < 0L) {
            throw new ClientException("timestamp must be positive");
        }
        this.timestamp = unit.toMicros(timestamp);
    }

    private PointIterator getTimestreamWithRange(TimestreamIdentifier identifier) {
        RangeRowQueryCriteria rangeRowQueryCriteria = new RangeRowQueryCriteria(this.tableName);
        long start = 0L;
        long end = Long.MAX_VALUE;
        if (this.timeRange != null) {
            start = this.timeRange.getBeginTime();
            end = this.timeRange.getEndTime();
        }
        PrimaryKeyBuilder beginPk = Utils.convertIdentifierToPK(identifier);
        beginPk.addPrimaryKeyColumn("s", PrimaryKeyValue.fromLong(start));
        PrimaryKeyBuilder endPk = Utils.convertIdentifierToPK(identifier);
        endPk.addPrimaryKeyColumn("s", PrimaryKeyValue.fromLong(end));
        rangeRowQueryCriteria.setInclusiveStartPrimaryKey(beginPk.build());
        rangeRowQueryCriteria.setExclusiveEndPrimaryKey(endPk.build());
        rangeRowQueryCriteria.setMaxVersions(1);
        rangeRowQueryCriteria.addColumnsToGet(this.columnToGet);
        GetRangeRequest request = new GetRangeRequest();
        request.setRangeRowQueryCriteria(rangeRowQueryCriteria);
        return new PointIterator(new GetRangeIterator(this.asyncClient, request), identifier);
    }

    private PointIterator getTimestreamWithTimestamp(TimestreamIdentifier identifier) {
        SingleRowQueryCriteria singleRowQueryCriteria = new SingleRowQueryCriteria(this.tableName);
        PrimaryKeyBuilder pkBuilder = Utils.convertIdentifierToPK(identifier);
        pkBuilder.addPrimaryKeyColumn("s", PrimaryKeyValue.fromLong(this.timestamp));
        singleRowQueryCriteria.setPrimaryKey(pkBuilder.build());
        singleRowQueryCriteria.setMaxVersions(1);
        singleRowQueryCriteria.addColumnsToGet(this.columnToGet);
        GetRowRequest request = new GetRowRequest(singleRowQueryCriteria);
        return new PointIterator(new GetRowIterator(this.asyncClient, request), identifier);
    }

    protected PointIterator getTimestream(TimestreamIdentifier identifier) {
        if (this.timestamp == -1L) {
            return this.getTimestreamWithRange(identifier);
        }
        return this.getTimestreamWithTimestamp(identifier);
    }

    public List<String> getSelectColumn() {
        return this.columnToGet;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

