/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.model.Request;

public class ComputeSplitsBySizeRequest
implements Request {
    private String tableName = null;
    private long splitUnitCount = 0L;
    private long splitUnitSizeInByte = 0x6400000L;

    public ComputeSplitsBySizeRequest() {
        this(null, 0L);
    }

    public ComputeSplitsBySizeRequest(ComputeSplitsBySizeRequest request) {
        this(request.getTableName(), request.getSplitSizeIn100MB());
    }

    public ComputeSplitsBySizeRequest(String tableName, long splitSizeIn100MB) {
        this.tableName = tableName;
        this.splitUnitCount = splitSizeIn100MB;
        this.splitUnitSizeInByte = 0x6400000L;
    }

    public ComputeSplitsBySizeRequest(String tableName, long splitUnitCount, long splitUnitSizeInByte) {
        this.tableName = tableName;
        this.splitUnitCount = splitUnitCount;
        this.splitUnitSizeInByte = splitUnitSizeInByte;
    }

    @Override
    public String getOperationName() {
        return "ComputeSplitPointsBySize";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public long getSplitSizeIn100MB() {
        return this.splitUnitCount * this.splitUnitSizeInByte / 0x6400000L;
    }

    public long getSplitUnitCount() {
        return this.splitUnitCount;
    }

    public long getSplitUnitSizeInByte() {
        return this.splitUnitSizeInByte;
    }

    public void setSplitSizeIn100MB(long splitSizeIn100MB) {
        this.splitUnitCount = splitSizeIn100MB;
        this.splitUnitSizeInByte = 0x6400000L;
    }

    public void setSplitSizeInByte(long splitUnitCount, long splitUnitSizeInByte) {
        this.splitUnitCount = splitUnitCount;
        this.splitUnitSizeInByte = splitUnitSizeInByte;
    }
}

