/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.ResponseContentWithMeta;
import com.alicloud.openservices.tablestore.core.http.ResponseMessage;
import com.alicloud.openservices.tablestore.core.protocol.ResultParseException;
import com.alicloud.openservices.tablestore.core.protocol.ResultParser;
import com.alicloud.openservices.tablestore.model.Response;
import com.aliyun.ots.thirdparty.com.google.protobuf.Message;
import com.aliyun.ots.thirdparty.com.google.protobuf.UninitializedMessageException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBufferParser
implements ResultParser {
    private static Logger logger = LoggerFactory.getLogger(ProtocolBufferParser.class);
    private Message message;
    private String traceId;

    public ProtocolBufferParser(Message message, String traceId) {
        this.message = message;
        this.traceId = traceId;
    }

    @Override
    public Object getObject(ResponseMessage response) throws ResultParseException {
        Map<String, String> headers = response.getHeadersMap();
        String requestId = headers.get("x-ots-requestid");
        if (requestId == null) {
            throw new ClientException("The required header is missing: x-ots-requestid");
        }
        try {
            Message result = this.message.newBuilderForType().mergeFrom(response.getContent()).buildPartial();
            if (!result.isInitialized()) {
                throw new UninitializedMessageException(result).asInvalidProtocolBufferException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("PBResponseMessage: {}, RequestId: {}, TraceId: {}", new Object[]{result.toString(), requestId, this.traceId});
            }
            return new ResponseContentWithMeta(result, new Response(requestId));
        }
        catch (Exception e) {
            throw new ResultParseException("Failed to parse response as protocol buffer message.", e);
        }
    }
}

