/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.util.Args;
import java.io.Serializable;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class LogStore
implements Serializable {
    private static final long serialVersionUID = 7408057477332043832L;
    private String logStoreName = "";
    private int ttl = -1;
    private int shardCount = -1;
    private boolean enableWebTracking = false;
    private boolean appendMeta = false;
    private boolean mAutoSplit = false;
    private int mMaxSplitShard = -1;
    private int createTime = -1;
    private int lastModifyTime = -1;
    private long preserveStorage = -1L;
    private long usedStorage = 0L;
    private String description;

    public LogStore() {
    }

    public LogStore(String logStoreName, int ttl, int shardCount) {
        this.logStoreName = logStoreName;
        this.ttl = ttl;
        this.shardCount = shardCount;
    }

    public LogStore(String logStoreName, int ttl, int shardCount, boolean enableWebTracking) {
        this.logStoreName = logStoreName;
        this.ttl = ttl;
        this.shardCount = shardCount;
        this.enableWebTracking = enableWebTracking;
    }

    public LogStore(LogStore logStore) {
        Args.notNull(logStore, "LogStore must not be null");
        this.logStoreName = logStore.GetLogStoreName();
        this.ttl = logStore.GetTtl();
        this.shardCount = logStore.GetShardCount();
        this.createTime = logStore.GetCreateTime();
        this.lastModifyTime = logStore.GetLastModifyTime();
        this.enableWebTracking = logStore.isEnableWebTracking();
        this.appendMeta = logStore.isAppendMeta();
        this.mAutoSplit = logStore.ismAutoSplit();
        this.mMaxSplitShard = logStore.getmMaxSplitShard();
        this.preserveStorage = logStore.preserveStorage;
        this.usedStorage = logStore.usedStorage;
        this.description = logStore.getDescription();
    }

    public long getPreserveStorage() {
        return this.preserveStorage;
    }

    public void setPreserveStorage(long preserveStorage) {
        this.preserveStorage = preserveStorage;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public void setUsedStorage(long usedStorage) {
        this.usedStorage = usedStorage;
    }

    public int getmMaxSplitShard() {
        return this.mMaxSplitShard;
    }

    public void setmMaxSplitShard(int mMaxSplitShard) {
        this.mMaxSplitShard = mMaxSplitShard;
    }

    public boolean ismAutoSplit() {
        return this.mAutoSplit;
    }

    public void setmAutoSplit(boolean mAutoSplit) {
        this.mAutoSplit = mAutoSplit;
    }

    public boolean isEnableWebTracking() {
        return this.enableWebTracking;
    }

    public void setEnableWebTracking(boolean enableWebTracking) {
        this.enableWebTracking = enableWebTracking;
    }

    public boolean isAppendMeta() {
        return this.appendMeta;
    }

    public void setAppendMeta(boolean appendMeta) {
        this.appendMeta = appendMeta;
    }

    public String GetLogStoreName() {
        return this.logStoreName;
    }

    public int GetTtl() {
        return this.ttl;
    }

    public int GetShardCount() {
        return this.shardCount;
    }

    public int GetCreateTime() {
        return this.createTime;
    }

    public int GetLastModifyTime() {
        return this.lastModifyTime;
    }

    public void SetLogStoreName(String logStoreName) {
        this.logStoreName = logStoreName;
    }

    public void SetTtl(int ttl) {
        this.ttl = ttl;
    }

    public void SetShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JSONObject ToRequestJson() {
        JSONObject logStoreDict = new JSONObject();
        logStoreDict.put((Object)"logstoreName", (Object)this.GetLogStoreName());
        logStoreDict.put((Object)"ttl", (Object)this.GetTtl());
        logStoreDict.put((Object)"shardCount", (Object)this.GetShardCount());
        logStoreDict.put((Object)"enable_tracking", (Object)this.isEnableWebTracking());
        logStoreDict.put((Object)"autoSplit", (Object)this.ismAutoSplit());
        logStoreDict.put((Object)"maxSplitShard", (Object)this.getmMaxSplitShard());
        logStoreDict.put((Object)"appendMeta", (Object)this.isAppendMeta());
        logStoreDict.put((Object)"description", (Object)this.getDescription());
        JSONObject resourceQuota = new JSONObject();
        JSONObject storage = new JSONObject();
        storage.put((Object)"preserved", (Object)this.preserveStorage);
        resourceQuota.put((Object)"storage", (Object)storage);
        logStoreDict.put((Object)"resourceQuota", (Object)resourceQuota);
        return logStoreDict;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        JSONObject logStoreDict = this.ToRequestJson();
        logStoreDict.put((Object)"createTime", (Object)this.GetCreateTime());
        logStoreDict.put((Object)"lastModifyTime", (Object)this.GetLastModifyTime());
        return logStoreDict;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            JSONObject resourceQuotaJson;
            this.SetLogStoreName(dict.getString("logstoreName"));
            this.SetTtl(dict.getInt("ttl"));
            this.SetShardCount(dict.getInt("shardCount"));
            if (dict.containsKey((Object)"enable_tracking")) {
                this.setEnableWebTracking(dict.getBoolean("enable_tracking"));
            }
            if (dict.containsKey((Object)"createTime")) {
                this.createTime = dict.getInt("createTime");
            }
            if (dict.containsKey((Object)"lastModifyTime")) {
                this.lastModifyTime = dict.getInt("lastModifyTime");
            }
            if (dict.containsKey((Object)"autoSplit")) {
                this.mAutoSplit = dict.getBoolean("autoSplit");
            }
            if (dict.containsKey((Object)"maxSplitShard")) {
                this.mMaxSplitShard = dict.getInt("maxSplitShard");
            }
            boolean bl = this.appendMeta = dict.containsKey((Object)"appendMeta") && dict.getBoolean("appendMeta");
            if (dict.containsKey((Object)"description")) {
                this.description = dict.getString("description");
            }
            if (dict.containsKey((Object)"resourceQuota") && (resourceQuotaJson = dict.getJSONObject("resourceQuota")).containsKey((Object)"storage")) {
                JSONObject storageJson = resourceQuotaJson.getJSONObject("storage");
                if (storageJson.containsKey((Object)"preserved")) {
                    this.preserveStorage = storageJson.getLong("preserved");
                }
                if (storageJson.containsKey((Object)"used")) {
                    this.usedStorage = storageJson.getLong("used");
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateLogStore", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String logStoreString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)logStoreString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateLogStore", e.getMessage(), e, "");
        }
    }
}

