/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.AliyunOSSSource;
import com.aliyun.openservices.log.common.DataSource;
import com.aliyun.openservices.log.common.DataSourceType;
import com.aliyun.openservices.log.common.JDBCSource;
import com.aliyun.openservices.log.common.JobConfiguration;
import net.sf.json.JSONObject;

public class IngestionConfiguration
extends JobConfiguration {
    private String logstore;
    private DataSource source;

    public String getLogstore() {
        return this.logstore;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public DataSource getSource() {
        return this.source;
    }

    public void setSource(DataSource source) {
        this.source = source;
    }

    @Override
    public void deserialize(JSONObject value) {
        this.logstore = value.getString("logstore");
        JSONObject jsonObject = value.getJSONObject("source");
        DataSourceType kind = DataSourceType.fromString(jsonObject.getString("type"));
        if (kind == DataSourceType.ALIYUN_OSS) {
            this.source = new AliyunOSSSource();
            this.source.deserialize(jsonObject);
        }
        if (kind == DataSourceType.JDBC) {
            this.source = new JDBCSource();
            this.source.deserialize(jsonObject);
        }
    }
}

