/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.JobConfiguration;
import com.aliyun.openservices.log.common.Notification;
import com.aliyun.openservices.log.common.NotificationType;
import com.aliyun.openservices.log.internal.Unmarshaller;
import com.aliyun.openservices.log.util.JsonUtils;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

abstract class DashboardBasedJobConfiguration
extends JobConfiguration {
    @JSONField
    private String dashboard;
    @JSONField
    private List<Notification> notificationList;

    DashboardBasedJobConfiguration() {
    }

    public String getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(String dashboard) {
        this.dashboard = dashboard;
    }

    public List<Notification> getNotificationList() {
        return this.notificationList;
    }

    public void setNotificationList(List<Notification> notificationList) {
        this.notificationList = notificationList;
    }

    abstract Notification makeQualifiedNotification(NotificationType var1);

    @Override
    public void deserialize(JSONObject value) {
        this.dashboard = value.getString("dashboard");
        this.notificationList = JsonUtils.readList(value, "notificationList", new Unmarshaller<Notification>(){

            @Override
            public Notification unmarshal(JSONArray value, int index) {
                JSONObject item = value.getJSONObject(index);
                NotificationType notificationType = NotificationType.fromString(item.getString("type"));
                if (notificationType == null) {
                    return null;
                }
                Notification notification = DashboardBasedJobConfiguration.this.makeQualifiedNotification(notificationType);
                notification.deserialize(item);
                return notification;
            }
        });
    }
}

