/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log;

import com.aliyun.openservices.log.LogService;
import com.aliyun.openservices.log.common.ACL;
import com.aliyun.openservices.log.common.Chart;
import com.aliyun.openservices.log.common.Config;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.ConsumerGroup;
import com.aliyun.openservices.log.common.Dashboard;
import com.aliyun.openservices.log.common.Domain;
import com.aliyun.openservices.log.common.EtlJob;
import com.aliyun.openservices.log.common.EtlMeta;
import com.aliyun.openservices.log.common.Histogram;
import com.aliyun.openservices.log.common.Index;
import com.aliyun.openservices.log.common.InternalLogStore;
import com.aliyun.openservices.log.common.LZ4Encoder;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.LogStore;
import com.aliyun.openservices.log.common.Logging;
import com.aliyun.openservices.log.common.Logs;
import com.aliyun.openservices.log.common.LogtailProfile;
import com.aliyun.openservices.log.common.Machine;
import com.aliyun.openservices.log.common.MachineGroup;
import com.aliyun.openservices.log.common.MachineList;
import com.aliyun.openservices.log.common.OdpsShipperConfig;
import com.aliyun.openservices.log.common.OssShipperConfig;
import com.aliyun.openservices.log.common.Project;
import com.aliyun.openservices.log.common.QueriedLog;
import com.aliyun.openservices.log.common.SavedSearch;
import com.aliyun.openservices.log.common.Shard;
import com.aliyun.openservices.log.common.ShipperConfig;
import com.aliyun.openservices.log.common.ShipperTask;
import com.aliyun.openservices.log.common.ShipperTasksStatistic;
import com.aliyun.openservices.log.common.TagContent;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.client.ClientConnectionContainer;
import com.aliyun.openservices.log.http.client.ClientConnectionHelper;
import com.aliyun.openservices.log.http.client.ClientConnectionStatus;
import com.aliyun.openservices.log.http.client.ClientException;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.client.ServiceException;
import com.aliyun.openservices.log.http.comm.DefaultServiceClient;
import com.aliyun.openservices.log.http.comm.RequestMessage;
import com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.aliyun.openservices.log.http.comm.ServiceClient;
import com.aliyun.openservices.log.http.comm.TimeoutServiceClient;
import com.aliyun.openservices.log.http.utils.CodingUtils;
import com.aliyun.openservices.log.http.utils.DateUtil;
import com.aliyun.openservices.log.request.ApplyConfigToMachineGroupRequest;
import com.aliyun.openservices.log.request.ApproveMachineGroupRequest;
import com.aliyun.openservices.log.request.BasicRequest;
import com.aliyun.openservices.log.request.BatchGetLogRequest;
import com.aliyun.openservices.log.request.ClearLogStoreStorageRequest;
import com.aliyun.openservices.log.request.ConsumerGroupGetCheckPointRequest;
import com.aliyun.openservices.log.request.ConsumerGroupHeartBeatRequest;
import com.aliyun.openservices.log.request.ConsumerGroupUpdateCheckPointRequest;
import com.aliyun.openservices.log.request.CreateAlertRequest;
import com.aliyun.openservices.log.request.CreateChartRequest;
import com.aliyun.openservices.log.request.CreateConfigRequest;
import com.aliyun.openservices.log.request.CreateConsumerGroupRequest;
import com.aliyun.openservices.log.request.CreateDashboardRequest;
import com.aliyun.openservices.log.request.CreateDomainRequest;
import com.aliyun.openservices.log.request.CreateETLRequest;
import com.aliyun.openservices.log.request.CreateEtlJobRequest;
import com.aliyun.openservices.log.request.CreateExportRequest;
import com.aliyun.openservices.log.request.CreateIndexRequest;
import com.aliyun.openservices.log.request.CreateIngestionRequest;
import com.aliyun.openservices.log.request.CreateJobRequest;
import com.aliyun.openservices.log.request.CreateJobScheduleRequest;
import com.aliyun.openservices.log.request.CreateLogStoreRequest;
import com.aliyun.openservices.log.request.CreateLoggingRequest;
import com.aliyun.openservices.log.request.CreateMachineGroupRequest;
import com.aliyun.openservices.log.request.CreateRebuildIndexRequest;
import com.aliyun.openservices.log.request.CreateReportRequest;
import com.aliyun.openservices.log.request.CreateSavedSearchRequest;
import com.aliyun.openservices.log.request.DeleteAlertRequest;
import com.aliyun.openservices.log.request.DeleteChartRequest;
import com.aliyun.openservices.log.request.DeleteConfigRequest;
import com.aliyun.openservices.log.request.DeleteDashboardRequest;
import com.aliyun.openservices.log.request.DeleteDomainRequest;
import com.aliyun.openservices.log.request.DeleteETLRequest;
import com.aliyun.openservices.log.request.DeleteEtlJobRequest;
import com.aliyun.openservices.log.request.DeleteExportRequest;
import com.aliyun.openservices.log.request.DeleteIndexRequest;
import com.aliyun.openservices.log.request.DeleteIngestionRequest;
import com.aliyun.openservices.log.request.DeleteJobRequest;
import com.aliyun.openservices.log.request.DeleteJobScheduleRequest;
import com.aliyun.openservices.log.request.DeleteLogStoreRequest;
import com.aliyun.openservices.log.request.DeleteLoggingRequest;
import com.aliyun.openservices.log.request.DeleteMachineGroupRequest;
import com.aliyun.openservices.log.request.DeleteRebuildIndexRequest;
import com.aliyun.openservices.log.request.DeleteReportRequest;
import com.aliyun.openservices.log.request.DeleteSavedSearchRequest;
import com.aliyun.openservices.log.request.DeleteShardRequest;
import com.aliyun.openservices.log.request.DisableAlertRequest;
import com.aliyun.openservices.log.request.DisableJobRequest;
import com.aliyun.openservices.log.request.DisableReportRequest;
import com.aliyun.openservices.log.request.EnableAlertRequest;
import com.aliyun.openservices.log.request.EnableJobRequest;
import com.aliyun.openservices.log.request.EnableReportRequest;
import com.aliyun.openservices.log.request.GetAlertRequest;
import com.aliyun.openservices.log.request.GetAppliedConfigsRequest;
import com.aliyun.openservices.log.request.GetAppliedMachineGroupRequest;
import com.aliyun.openservices.log.request.GetChartRequest;
import com.aliyun.openservices.log.request.GetConfigRequest;
import com.aliyun.openservices.log.request.GetContextLogsRequest;
import com.aliyun.openservices.log.request.GetCursorRequest;
import com.aliyun.openservices.log.request.GetCursorTimeRequest;
import com.aliyun.openservices.log.request.GetDashboardRequest;
import com.aliyun.openservices.log.request.GetETLRequest;
import com.aliyun.openservices.log.request.GetEtlJobRequest;
import com.aliyun.openservices.log.request.GetExportRequest;
import com.aliyun.openservices.log.request.GetHistogramsRequest;
import com.aliyun.openservices.log.request.GetIndexRequest;
import com.aliyun.openservices.log.request.GetIngestionRequest;
import com.aliyun.openservices.log.request.GetJobRequest;
import com.aliyun.openservices.log.request.GetJobScheduleRequest;
import com.aliyun.openservices.log.request.GetLogStoreRequest;
import com.aliyun.openservices.log.request.GetLoggingRequest;
import com.aliyun.openservices.log.request.GetLogsRequest;
import com.aliyun.openservices.log.request.GetLogtailProfileRequest;
import com.aliyun.openservices.log.request.GetMachineGroupRequest;
import com.aliyun.openservices.log.request.GetProjectLogsRequest;
import com.aliyun.openservices.log.request.GetRebuildIndexRequest;
import com.aliyun.openservices.log.request.GetReportRequest;
import com.aliyun.openservices.log.request.GetSavedSearchRequest;
import com.aliyun.openservices.log.request.ListACLRequest;
import com.aliyun.openservices.log.request.ListAlertRequest;
import com.aliyun.openservices.log.request.ListConfigRequest;
import com.aliyun.openservices.log.request.ListDashboardRequest;
import com.aliyun.openservices.log.request.ListDomainsRequest;
import com.aliyun.openservices.log.request.ListETLRequest;
import com.aliyun.openservices.log.request.ListEtlJobRequest;
import com.aliyun.openservices.log.request.ListEtlMetaRequest;
import com.aliyun.openservices.log.request.ListExportRequest;
import com.aliyun.openservices.log.request.ListIngestionRequest;
import com.aliyun.openservices.log.request.ListJobSchedulesRequest;
import com.aliyun.openservices.log.request.ListJobsRequest;
import com.aliyun.openservices.log.request.ListLogStoresRequest;
import com.aliyun.openservices.log.request.ListMachineGroupRequest;
import com.aliyun.openservices.log.request.ListProjectRequest;
import com.aliyun.openservices.log.request.ListRebuildIndexRequest;
import com.aliyun.openservices.log.request.ListReportRequest;
import com.aliyun.openservices.log.request.ListSavedSearchRequest;
import com.aliyun.openservices.log.request.ListShardRequest;
import com.aliyun.openservices.log.request.ListTopicsRequest;
import com.aliyun.openservices.log.request.MergeShardsRequest;
import com.aliyun.openservices.log.request.PullLogsRequest;
import com.aliyun.openservices.log.request.PutLogsRequest;
import com.aliyun.openservices.log.request.RemoveConfigFromMachineGroupRequest;
import com.aliyun.openservices.log.request.SplitShardRequest;
import com.aliyun.openservices.log.request.StartExportRequest;
import com.aliyun.openservices.log.request.StartIngestionRequest;
import com.aliyun.openservices.log.request.StartJobScheduleRequest;
import com.aliyun.openservices.log.request.StopExportRequest;
import com.aliyun.openservices.log.request.StopIngestionRequest;
import com.aliyun.openservices.log.request.StopJobScheduleRequest;
import com.aliyun.openservices.log.request.StopRebuildIndexRequest;
import com.aliyun.openservices.log.request.UpdateACLRequest;
import com.aliyun.openservices.log.request.UpdateAlertRequest;
import com.aliyun.openservices.log.request.UpdateChartRequest;
import com.aliyun.openservices.log.request.UpdateConfigRequest;
import com.aliyun.openservices.log.request.UpdateDashboardRequest;
import com.aliyun.openservices.log.request.UpdateETLRequest;
import com.aliyun.openservices.log.request.UpdateEtlJobRequest;
import com.aliyun.openservices.log.request.UpdateExportRequest;
import com.aliyun.openservices.log.request.UpdateIndexRequest;
import com.aliyun.openservices.log.request.UpdateIngestionRequest;
import com.aliyun.openservices.log.request.UpdateJobRequest;
import com.aliyun.openservices.log.request.UpdateJobScheduleRequest;
import com.aliyun.openservices.log.request.UpdateLogStoreRequest;
import com.aliyun.openservices.log.request.UpdateLoggingRequest;
import com.aliyun.openservices.log.request.UpdateMachineGroupMachineRequest;
import com.aliyun.openservices.log.request.UpdateMachineGroupRequest;
import com.aliyun.openservices.log.request.UpdateProjectRequest;
import com.aliyun.openservices.log.request.UpdateReportRequest;
import com.aliyun.openservices.log.request.UpdateSavedSearchRequest;
import com.aliyun.openservices.log.response.ApplyConfigToMachineGroupResponse;
import com.aliyun.openservices.log.response.ApproveMachineGroupResponse;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.log.response.BatchModifyEtlMetaStatusResponse;
import com.aliyun.openservices.log.response.ClearLogStoreStorageResponse;
import com.aliyun.openservices.log.response.ConsumerGroupCheckPointResponse;
import com.aliyun.openservices.log.response.ConsumerGroupHeartBeatResponse;
import com.aliyun.openservices.log.response.ConsumerGroupUpdateCheckPointResponse;
import com.aliyun.openservices.log.response.CreateAlertResponse;
import com.aliyun.openservices.log.response.CreateChartResponse;
import com.aliyun.openservices.log.response.CreateConfigResponse;
import com.aliyun.openservices.log.response.CreateConsumerGroupResponse;
import com.aliyun.openservices.log.response.CreateDashboardResponse;
import com.aliyun.openservices.log.response.CreateDomainResponse;
import com.aliyun.openservices.log.response.CreateETLResponse;
import com.aliyun.openservices.log.response.CreateEtlJobResponse;
import com.aliyun.openservices.log.response.CreateEtlMetaResponse;
import com.aliyun.openservices.log.response.CreateExportResponse;
import com.aliyun.openservices.log.response.CreateIndexResponse;
import com.aliyun.openservices.log.response.CreateIngestionResponse;
import com.aliyun.openservices.log.response.CreateJobResponse;
import com.aliyun.openservices.log.response.CreateJobScheduleResponse;
import com.aliyun.openservices.log.response.CreateLogStoreInternalResponse;
import com.aliyun.openservices.log.response.CreateLogStoreResponse;
import com.aliyun.openservices.log.response.CreateLoggingResponse;
import com.aliyun.openservices.log.response.CreateMachineGroupResponse;
import com.aliyun.openservices.log.response.CreateProjectResponse;
import com.aliyun.openservices.log.response.CreateRebuildResponse;
import com.aliyun.openservices.log.response.CreateReportResponse;
import com.aliyun.openservices.log.response.CreateSavedSearchResponse;
import com.aliyun.openservices.log.response.CreateShipperResponse;
import com.aliyun.openservices.log.response.DeleteAlertResponse;
import com.aliyun.openservices.log.response.DeleteChartResponse;
import com.aliyun.openservices.log.response.DeleteConfigResponse;
import com.aliyun.openservices.log.response.DeleteConsumerGroupResponse;
import com.aliyun.openservices.log.response.DeleteDashboardResponse;
import com.aliyun.openservices.log.response.DeleteDomainResponse;
import com.aliyun.openservices.log.response.DeleteETLResponse;
import com.aliyun.openservices.log.response.DeleteEtlJobResponse;
import com.aliyun.openservices.log.response.DeleteEtlMetaResponse;
import com.aliyun.openservices.log.response.DeleteExportResponse;
import com.aliyun.openservices.log.response.DeleteIndexResponse;
import com.aliyun.openservices.log.response.DeleteIngestionResponse;
import com.aliyun.openservices.log.response.DeleteJobResponse;
import com.aliyun.openservices.log.response.DeleteJobScheduleResponse;
import com.aliyun.openservices.log.response.DeleteLogStoreResponse;
import com.aliyun.openservices.log.response.DeleteLoggingResponse;
import com.aliyun.openservices.log.response.DeleteMachineGroupResponse;
import com.aliyun.openservices.log.response.DeleteProjectResponse;
import com.aliyun.openservices.log.response.DeleteRebuildIndexResponse;
import com.aliyun.openservices.log.response.DeleteReportResponse;
import com.aliyun.openservices.log.response.DeleteSavedSearchResponse;
import com.aliyun.openservices.log.response.DeleteShardResponse;
import com.aliyun.openservices.log.response.DeleteShipperResponse;
import com.aliyun.openservices.log.response.DisableAlertResponse;
import com.aliyun.openservices.log.response.DisableJobResponse;
import com.aliyun.openservices.log.response.DisableReportResponse;
import com.aliyun.openservices.log.response.EnableAlertResponse;
import com.aliyun.openservices.log.response.EnableJobResponse;
import com.aliyun.openservices.log.response.EnableReportResponse;
import com.aliyun.openservices.log.response.GetAlertResponse;
import com.aliyun.openservices.log.response.GetAppliedConfigResponse;
import com.aliyun.openservices.log.response.GetAppliedMachineGroupsResponse;
import com.aliyun.openservices.log.response.GetChartResponse;
import com.aliyun.openservices.log.response.GetConfigResponse;
import com.aliyun.openservices.log.response.GetContextLogsResponse;
import com.aliyun.openservices.log.response.GetCursorResponse;
import com.aliyun.openservices.log.response.GetCursorTimeResponse;
import com.aliyun.openservices.log.response.GetDashboardResponse;
import com.aliyun.openservices.log.response.GetETLResponse;
import com.aliyun.openservices.log.response.GetEtlJobResponse;
import com.aliyun.openservices.log.response.GetExportResponse;
import com.aliyun.openservices.log.response.GetHistogramsResponse;
import com.aliyun.openservices.log.response.GetIndexResponse;
import com.aliyun.openservices.log.response.GetIndexStringResponse;
import com.aliyun.openservices.log.response.GetIngestionResponse;
import com.aliyun.openservices.log.response.GetJobResponse;
import com.aliyun.openservices.log.response.GetJobScheduleResponse;
import com.aliyun.openservices.log.response.GetLogStoreResponse;
import com.aliyun.openservices.log.response.GetLoggingResponse;
import com.aliyun.openservices.log.response.GetLogsResponse;
import com.aliyun.openservices.log.response.GetLogtailProfileResponse;
import com.aliyun.openservices.log.response.GetMachineGroupResponse;
import com.aliyun.openservices.log.response.GetProjectResponse;
import com.aliyun.openservices.log.response.GetRebuildIndexResponse;
import com.aliyun.openservices.log.response.GetReportResponse;
import com.aliyun.openservices.log.response.GetSavedSearchResponse;
import com.aliyun.openservices.log.response.GetShipperResponse;
import com.aliyun.openservices.log.response.GetShipperTasksResponse;
import com.aliyun.openservices.log.response.ListACLResponse;
import com.aliyun.openservices.log.response.ListAlertResponse;
import com.aliyun.openservices.log.response.ListConfigResponse;
import com.aliyun.openservices.log.response.ListConsumerGroupResponse;
import com.aliyun.openservices.log.response.ListDashboardResponse;
import com.aliyun.openservices.log.response.ListDomainsResponse;
import com.aliyun.openservices.log.response.ListETLResponse;
import com.aliyun.openservices.log.response.ListEtlJobResponse;
import com.aliyun.openservices.log.response.ListEtlMetaNameResponse;
import com.aliyun.openservices.log.response.ListEtlMetaResponse;
import com.aliyun.openservices.log.response.ListExportResponse;
import com.aliyun.openservices.log.response.ListIngestionResponse;
import com.aliyun.openservices.log.response.ListJobSchedulesResponse;
import com.aliyun.openservices.log.response.ListJobsResponse;
import com.aliyun.openservices.log.response.ListLogStoresResponse;
import com.aliyun.openservices.log.response.ListMachineGroupResponse;
import com.aliyun.openservices.log.response.ListMachinesResponse;
import com.aliyun.openservices.log.response.ListProjectResponse;
import com.aliyun.openservices.log.response.ListRebuildIndexResponse;
import com.aliyun.openservices.log.response.ListReportResponse;
import com.aliyun.openservices.log.response.ListSavedSearchResponse;
import com.aliyun.openservices.log.response.ListShardResponse;
import com.aliyun.openservices.log.response.ListShipperResponse;
import com.aliyun.openservices.log.response.ListTopicsResponse;
import com.aliyun.openservices.log.response.PullLogsResponse;
import com.aliyun.openservices.log.response.PutLogsResponse;
import com.aliyun.openservices.log.response.RemoveConfigFromMachineGroupResponse;
import com.aliyun.openservices.log.response.RetryShipperTasksResponse;
import com.aliyun.openservices.log.response.StartExportResponse;
import com.aliyun.openservices.log.response.StartIngestionResponse;
import com.aliyun.openservices.log.response.StartJobScheduleResponse;
import com.aliyun.openservices.log.response.StopExportResponse;
import com.aliyun.openservices.log.response.StopIngestionResponse;
import com.aliyun.openservices.log.response.StopJobScheduleResponse;
import com.aliyun.openservices.log.response.StopRebuildIndexResponse;
import com.aliyun.openservices.log.response.UpdateACLResponse;
import com.aliyun.openservices.log.response.UpdateAlertResponse;
import com.aliyun.openservices.log.response.UpdateChartResponse;
import com.aliyun.openservices.log.response.UpdateConfigResponse;
import com.aliyun.openservices.log.response.UpdateConsumerGroupResponse;
import com.aliyun.openservices.log.response.UpdateDashboardResponse;
import com.aliyun.openservices.log.response.UpdateETLResponse;
import com.aliyun.openservices.log.response.UpdateEtlJobResponse;
import com.aliyun.openservices.log.response.UpdateEtlMetaResponse;
import com.aliyun.openservices.log.response.UpdateExportResponse;
import com.aliyun.openservices.log.response.UpdateIndexResponse;
import com.aliyun.openservices.log.response.UpdateIngestionResponse;
import com.aliyun.openservices.log.response.UpdateJobResponse;
import com.aliyun.openservices.log.response.UpdateJobScheduleResponse;
import com.aliyun.openservices.log.response.UpdateLogStoreInternalResponse;
import com.aliyun.openservices.log.response.UpdateLogStoreResponse;
import com.aliyun.openservices.log.response.UpdateLoggingResponse;
import com.aliyun.openservices.log.response.UpdateMachineGroupMachineResponse;
import com.aliyun.openservices.log.response.UpdateMachineGroupResponse;
import com.aliyun.openservices.log.response.UpdateProjectResponse;
import com.aliyun.openservices.log.response.UpdateReportResponse;
import com.aliyun.openservices.log.response.UpdateSavedSearchResponse;
import com.aliyun.openservices.log.response.UpdateShipperResponse;
import com.aliyun.openservices.log.util.Args;
import com.aliyun.openservices.log.util.DigestUtils;
import com.aliyun.openservices.log.util.JsonUtils;
import com.aliyun.openservices.log.util.NetworkUtils;
import com.aliyun.openservices.log.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.Deflater;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.codec.binary.Base64;

public class Client
implements LogService {
    private String httpType;
    private String hostName;
    private String accessId;
    private String accessKey;
    private String sourceIp;
    private ServiceClient serviceClient;
    private String securityToken;
    private String realIpForConsole;
    private Boolean useSSLForConsole;
    private String userAgent = "sls-java-sdk-v-0.6.1";
    private boolean mUUIDTag = false;
    private Boolean mUseDirectMode = false;
    private String realServerIP = null;
    private String resourceOwnerAccount = null;

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getRealIpForConsole() {
        return this.realIpForConsole;
    }

    public void setRealIpForConsole(String realIpForConsole) {
        this.realIpForConsole = realIpForConsole;
    }

    public boolean isUseSSLForConsole() {
        return this.useSSLForConsole;
    }

    public void setUseSSLForConsole(boolean useSSLForConsole) {
        this.useSSLForConsole = useSSLForConsole;
    }

    public void ClearConsoleResources() {
        this.realIpForConsole = null;
        this.useSSLForConsole = null;
    }

    public void EnableUUIDTag() {
        this.mUUIDTag = true;
    }

    public void DisableUUIDTag() {
        this.mUUIDTag = false;
    }

    public String GetSecurityToken() {
        return this.securityToken;
    }

    @Deprecated
    public void SetSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void RemoveSecurityToken() {
        this.securityToken = null;
    }

    public void EnableDirectMode() {
        this.mUseDirectMode = true;
    }

    public void DisableDirectMode() {
        this.mUseDirectMode = false;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public void setResourceOwnerAccount(String resourceOwnerAccount) {
        this.resourceOwnerAccount = resourceOwnerAccount;
    }

    public Client(String endpoint, String accessId, String accessKey) {
        this(endpoint, accessId, accessKey, NetworkUtils.getLocalMachineIP());
    }

    public Client(String endpoint, String accessId, String accessKey, ClientConfiguration configuration) {
        this(endpoint, accessId, accessKey, NetworkUtils.getLocalMachineIP(), configuration);
    }

    public Client(String endpoint, String accessId, String accessKey, String SourceIp) {
        this(endpoint, accessId, accessKey, SourceIp, Consts.HTTP_CONNECT_MAX_COUNT, Consts.HTTP_CONNECT_TIME_OUT, Consts.HTTP_SEND_TIME_OUT);
    }

    @Deprecated
    public Client(String endpoint, String accessId, String accessKey, String sourceIp, boolean compressFlag, int connectMaxCount, int connectTimeout, int sendTimeout) {
        this(endpoint, accessId, accessKey, sourceIp, connectMaxCount, connectTimeout, sendTimeout);
    }

    @Deprecated
    public Client(String endpoint, String accessId, String accessKey, String sourceIp, int connectMaxCount, int connectTimeout, int sendTimeout) {
        this.configure(endpoint, accessId, accessKey, sourceIp);
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(connectMaxCount);
        clientConfig.setConnectionTimeout(connectTimeout);
        clientConfig.setSocketTimeout(sendTimeout);
        this.serviceClient = new DefaultServiceClient(clientConfig);
    }

    public Client(String endpoint, String accessId, String accessKey, ServiceClient serviceClient) {
        this.configure(endpoint, accessId, accessKey, NetworkUtils.getLocalMachineIP());
        this.serviceClient = serviceClient;
    }

    private void configure(String endpoint, String accessId, String accessKey, String sourceIp) {
        Args.notNullOrEmpty(endpoint, "endpoint");
        Args.notNullOrEmpty(accessId, "accessId");
        Args.notNullOrEmpty(accessKey, "accessKey");
        if (endpoint.startsWith("http://")) {
            this.hostName = endpoint.substring(7);
            this.httpType = "http://";
        } else if (endpoint.startsWith("https://")) {
            this.hostName = endpoint.substring(8);
            this.httpType = "https://";
        } else {
            this.hostName = endpoint;
            this.httpType = "http://";
        }
        while (this.hostName.endsWith("/")) {
            this.hostName = this.hostName.substring(0, this.hostName.length() - 1);
        }
        if (NetworkUtils.isIPAddr(this.hostName)) {
            throw new IllegalArgumentException("EndpointInvalid", new Exception("The ip address is not supported"));
        }
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.sourceIp = sourceIp;
        if (sourceIp == null || sourceIp.isEmpty()) {
            this.sourceIp = NetworkUtils.getLocalMachineIP();
        }
    }

    public Client(String endpoint, String accessId, String accessKey, String sourceIp, ClientConfiguration config) {
        Args.notNull(config, "Config");
        this.configure(endpoint, accessId, accessKey, sourceIp);
        this.serviceClient = config.isRequestTimeoutEnabled() ? new TimeoutServiceClient(config) : new DefaultServiceClient(config);
    }

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void shutdown() {
        this.serviceClient.shutdown();
    }

    private URI GetHostURI(String project) {
        String endPointUrl = this.httpType + this.hostName;
        if (project != null && !project.isEmpty()) {
            endPointUrl = this.httpType + project + "." + this.hostName;
        }
        try {
            return new URI(endPointUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("EndpointInvalid", e);
        }
    }

    private URI GetHostURIByIp(String ip_addr) throws LogException {
        String endPointUrl = this.httpType + ip_addr;
        try {
            return new URI(endPointUrl);
        }
        catch (URISyntaxException e) {
            throw new LogException("EndpointInvalid", "Failed to get real server ip when direct mode in enabled", "");
        }
    }

    private static byte[] encodeToUtf8(String source) throws LogException {
        try {
            return source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
    }

    private static String encodeResponseBodyToUtf8String(ResponseMessage response, String requestId) throws LogException {
        byte[] body = response.GetRawBody();
        if (body == null) {
            throw new LogException("BadResponse", "The response body is null", null, requestId);
        }
        try {
            return new String(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("BadResponse", "The response is not valid utf-8 string: ", e, requestId);
        }
    }

    public GetLogtailProfileResponse ExtractLogtailProfile(Map<String, String> resHeaders, JSONObject object) throws LogException {
        try {
            int count = object.getInt("count");
            int total = object.getInt("total");
            JSONArray array = object.getJSONArray("profile");
            ArrayList<LogtailProfile> logtailProfiles = new ArrayList<LogtailProfile>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject profileObj = array.getJSONObject(i);
                LogtailProfile logtailProfile = new LogtailProfile();
                logtailProfile.FromJsonObject(profileObj);
                logtailProfiles.add(logtailProfile);
            }
            return new GetLogtailProfileResponse(resHeaders, count, total, logtailProfiles);
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), this.GetRequestId(resHeaders));
        }
    }

    public GetLogtailProfileResponse GetLogtailProfile(String project, String logstore, String source, int line, int offset) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logstore, "logstore");
        GetLogtailProfileRequest request = new GetLogtailProfileRequest(project, logstore, source, line, offset);
        return this.GetLogtailProfile(request);
    }

    public GetLogtailProfileResponse GetLogtailProfile(GetLogtailProfileRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + request.getLogStore() + "/logtailprofile";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return this.ExtractLogtailProfile(resHeaders, object);
    }

    @Override
    public GetHistogramsResponse GetHistograms(String project, String logStore, int from, int to, String topic, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetHistogramsRequest request = new GetHistogramsRequest(project, logStore, topic, query, from, to);
        return this.GetHistograms(request);
    }

    @Override
    public GetHistogramsResponse GetHistograms(GetHistogramsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + request.GetLogStore() + "/index";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray object = this.ParseResponseMessageToArray(response, requestId);
        GetHistogramsResponse histogramResponse = new GetHistogramsResponse(resHeaders);
        this.ExtractHistograms(histogramResponse, object);
        return histogramResponse;
    }

    public PutLogsResponse PutLogs(String project, String logStore, byte[] logGroupBytes, String compressType, String shardHash) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(logGroupBytes, "logGroupBytes");
        PutLogsRequest request = new PutLogsRequest(project, logStore, null, null, logGroupBytes, shardHash);
        request.SetCompressType(Consts.CompressType.fromString(compressType));
        return this.PutLogs(request);
    }

    @Override
    public PutLogsResponse PutLogs(String project, String logStore, String topic, List<LogItem> logItems, String source, String shardHash) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(logItems, "logGroup");
        PutLogsRequest request = new PutLogsRequest(project, logStore, topic, source, logItems, shardHash);
        request.SetCompressType(Consts.CompressType.LZ4);
        return this.PutLogs(request);
    }

    @Override
    public PutLogsResponse PutLogs(String project, String logStore, String topic, List<LogItem> logItems, String source) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(logItems, "logGroup");
        PutLogsRequest request = new PutLogsRequest(project, logStore, topic, source, logItems, null);
        request.SetCompressType(Consts.CompressType.LZ4);
        return this.PutLogs(request);
    }

    @Override
    public PutLogsResponse PutLogs(PutLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String shardKey = request.GetRouteKey();
        Consts.CompressType compressType = request.GetCompressType();
        CodingUtils.assertParameterNotNull((Object)compressType, "compressType");
        byte[] logBytes = request.GetLogGroupBytes();
        if (logBytes == null) {
            LogItem item;
            ArrayList<LogItem> logItems = request.GetLogItems();
            if (logItems.size() > Consts.CONST_MAX_PUT_LINES) {
                throw new LogException("InvalidLogSize", "logItems' length exceeds maximum limitation : " + Consts.CONST_MAX_PUT_LINES + " lines", "");
            }
            String topic = request.GetTopic();
            CodingUtils.assertParameterNotNull(topic, "topic");
            String source = request.GetSource();
            if (!"application/json".equals(request.getContentType())) {
                Logs.LogGroup.Builder logs = Logs.LogGroup.newBuilder();
                logs.setTopic(topic);
                if (source == null || source.isEmpty()) {
                    logs.setSource(this.sourceIp);
                } else {
                    logs.setSource(source);
                }
                ArrayList<TagContent> tags = request.GetTags();
                if (tags != null && tags.size() > 0) {
                    for (TagContent tag : tags) {
                        Logs.LogTag.Builder tagBuilder = logs.addLogTagsBuilder();
                        tagBuilder.setKey(tag.getKey());
                        tagBuilder.setValue(tag.getValue());
                    }
                }
                if (this.mUUIDTag) {
                    Logs.LogTag.Builder tagBuilder = logs.addLogTagsBuilder();
                    tagBuilder.setKey("__pack_unique_id__");
                    tagBuilder.setValue(UUID.randomUUID().toString() + "-" + String.valueOf(Math.random()));
                }
                for (int i = 0; i < logItems.size(); ++i) {
                    item = (LogItem)logItems.get(i);
                    Logs.Log.Builder log = logs.addLogsBuilder();
                    log.setTime(item.mLogTime);
                    for (LogContent content : item.mContents) {
                        CodingUtils.assertStringNotNullOrEmpty(content.mKey, "key");
                        Logs.Log.Content.Builder contentBuilder = log.addContentsBuilder();
                        contentBuilder.setKey(content.mKey);
                        if (content.mValue == null) {
                            contentBuilder.setValue("");
                            continue;
                        }
                        contentBuilder.setValue(content.mValue);
                    }
                }
                logBytes = logs.build().toByteArray();
            } else {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"__topic__", (Object)topic);
                if (source == null || source.isEmpty()) {
                    jsonObj.put((Object)"__source__", (Object)this.sourceIp);
                } else {
                    jsonObj.put((Object)"__source__", (Object)source);
                }
                JSONArray logsArray = new JSONArray();
                for (int i = 0; i < logItems.size(); ++i) {
                    item = (LogItem)logItems.get(i);
                    JSONObject jsonObjInner = new JSONObject();
                    jsonObjInner.put((Object)"__time__", (Object)item.mLogTime);
                    for (LogContent content : item.mContents) {
                        jsonObjInner.put((Object)content.mKey, (Object)content.mValue);
                    }
                    logsArray.add((Object)jsonObjInner);
                }
                jsonObj.put((Object)"__logs__", (Object)logsArray);
                JSONObject tagObj = new JSONObject();
                ArrayList<TagContent> tags = request.GetTags();
                if (tags != null && tags.size() > 0) {
                    for (TagContent tag : tags) {
                        tagObj.put((Object)tag.getKey(), (Object)tag.getValue());
                    }
                }
                if (this.mUUIDTag) {
                    tagObj.put((Object)"__pack_unique_id__", (Object)(UUID.randomUUID().toString() + "-" + String.valueOf(Math.random())));
                }
                if (tagObj.size() > 0) {
                    jsonObj.put((Object)"__tags__", (Object)tagObj);
                }
                logBytes = Client.encodeToUtf8(jsonObj.toString());
            }
        }
        if (logBytes.length > Consts.CONST_MAX_PUT_SIZE) {
            throw new LogException("InvalidLogSize", "logItems' size exceeds maximum limitation : " + Consts.CONST_MAX_PUT_SIZE + " bytes", "");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", request.getContentType());
        long originalSize = logBytes.length;
        if (compressType == Consts.CompressType.LZ4) {
            logBytes = LZ4Encoder.compressToLhLz4Chunk((byte[])logBytes.clone());
            headParameter.put("x-log-compresstype", compressType.toString());
        } else if (compressType == Consts.CompressType.GZIP) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(logBytes.length);
            Deflater compressor = new Deflater();
            compressor.setInput(logBytes);
            compressor.finish();
            byte[] buf = new byte[10240];
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                out.write(buf, 0, count);
            }
            logBytes = out.toByteArray();
            headParameter.put("x-log-compresstype", compressType.toString());
        }
        headParameter.put("x-log-bodyrawsize", String.valueOf(originalSize));
        String resourceUri = "/logstores/" + logStore;
        resourceUri = shardKey == null || shardKey.length() == 0 ? resourceUri + "/shards/lb" : resourceUri + "/shards/route?key=" + shardKey;
        Map<String, String> urlParameter = request.GetAllParams();
        long cmp_size = logBytes.length;
        for (int i = 0; i < 2; ++i) {
            String server_ip = this.realServerIP;
            ClientConnectionStatus connection_status = null;
            if (this.mUseDirectMode.booleanValue()) {
                connection_status = this.GetGlobalConnectionStatus();
                server_ip = connection_status.GetIpAddress();
            }
            try {
                ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, logBytes, null, server_ip);
                Map<String, String> resHeaders = response.getHeaders();
                PutLogsResponse putLogsResponse = new PutLogsResponse(resHeaders);
                if (connection_status != null) {
                    connection_status.AddSendDataSize(cmp_size);
                    connection_status.UpdateLastUsedTime(System.nanoTime());
                }
                return putLogsResponse;
            }
            catch (LogException e) {
                String request_id = e.GetRequestId();
                if (i == 1 || request_id != null && !request_id.isEmpty()) {
                    throw e;
                }
                if (connection_status == null) continue;
                connection_status.DisableConnection();
                continue;
            }
        }
        return null;
    }

    private ClientConnectionStatus GetGlobalConnectionStatus() throws LogException {
        ClientConnectionContainer connection_container = ClientConnectionHelper.getInstance().GetConnectionContainer(this.hostName, this.accessId, this.accessKey);
        ClientConnectionStatus connection_status = connection_container.GetGlobalConnection();
        if (connection_status == null || !connection_status.IsValidConnection()) {
            connection_container.UpdateGlobalConnection();
            connection_status = connection_container.GetGlobalConnection();
            if (connection_status == null || connection_status.GetIpAddress() == null || connection_status.GetIpAddress().isEmpty()) {
                throw new LogException("EndpointInvalid", "Failed to get real server ip when direct mode is enabled", "");
            }
        }
        return connection_status;
    }

    private ClientConnectionStatus GetShardConnectionStatus(String project, String logstore, int shard_id) throws LogException {
        ClientConnectionContainer connection_container = ClientConnectionHelper.getInstance().GetConnectionContainer(this.hostName, this.accessId, this.accessKey);
        ClientConnectionStatus connection_status = connection_container.GetShardConnection(project, logstore, shard_id);
        if (connection_status != null && connection_status.IsValidConnection()) {
            return connection_status;
        }
        return this.GetGlobalConnectionStatus();
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query);
        return this.GetLogs(request);
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query, int line, int offset, boolean reverse) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query, offset, line, reverse);
        return this.GetLogs(request);
    }

    public GetContextLogsResponse getContextLogs(String project, String logstore, String packID, String packMeta, int backLines, int forwardLines) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logstore, "logStore");
        GetContextLogsRequest request = new GetContextLogsRequest(project, logstore, packID, packMeta, backLines, forwardLines);
        return this.getContextLogs(request);
    }

    @Override
    public GetLogsResponse GetProjectLogs(String project, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(query, "query");
        GetProjectLogsRequest request = new GetProjectLogsRequest(project, query);
        return this.GetProjectLogs(request);
    }

    @Override
    public GetLogsResponse GetProjectLogs(GetProjectLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logs";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        com.alibaba.fastjson.JSONArray object = this.ParseResponseMessageToArrayWithFastJson(response, requestId);
        GetLogsResponse getLogsResponse = new GetLogsResponse(resHeaders);
        this.ExtractLogsWithFastJson(getLogsResponse, object);
        return getLogsResponse;
    }

    private com.alibaba.fastjson.JSONArray ParseResponseMessageToArrayWithFastJson(ResponseMessage response, String requestId) throws LogException {
        String returnStr = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return com.alibaba.fastjson.JSONArray.parseArray((String)returnStr);
        }
        catch (com.alibaba.fastjson.JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + returnStr, e, requestId);
        }
    }

    private com.alibaba.fastjson.JSONObject parseResponseMessageToObjectWithFastJSON(ResponseMessage response, String requestId) throws LogException {
        String returnStr = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return com.alibaba.fastjson.JSONObject.parseObject((String)returnStr);
        }
        catch (com.alibaba.fastjson.JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + returnStr, e, requestId);
        }
    }

    private void ExtractLogsWithFastJson(GetLogsResponse response, com.alibaba.fastjson.JSONArray logs) {
        try {
            for (int i = 0; i < logs.size(); ++i) {
                response.AddLog(this.extractLogFromJSON(logs.getJSONObject(i)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void extractLogsWithFastJson(GetContextLogsResponse response, com.alibaba.fastjson.JSONArray logs) {
        try {
            for (int i = 0; i < logs.size(); ++i) {
                response.addLog(this.extractLogFromJSON(logs.getJSONObject(i)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private QueriedLog extractLogFromJSON(com.alibaba.fastjson.JSONObject log) throws JSONException {
        String source = "";
        LogItem logItem = new LogItem();
        Set keySet = log.keySet();
        for (String key : keySet) {
            String value = log.getString(key);
            if (key.equals("__source__")) {
                source = value;
                continue;
            }
            if (key.equals("__time__")) {
                logItem.mLogTime = Integer.parseInt(value);
                continue;
            }
            logItem.PushBack(key, value);
        }
        return new QueriedLog(source, logItem);
    }

    @Override
    public GetLogsResponse GetLogs(GetLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logStore = request.GetLogStore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        com.alibaba.fastjson.JSONArray object = this.ParseResponseMessageToArrayWithFastJson(response, requestId);
        GetLogsResponse getLogsResponse = new GetLogsResponse(resHeaders);
        this.ExtractLogsWithFastJson(getLogsResponse, object);
        return getLogsResponse;
    }

    public GetContextLogsResponse getContextLogs(GetContextLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logStore = request.getLogstore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore;
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        com.alibaba.fastjson.JSONObject object = this.parseResponseMessageToObjectWithFastJSON(response, requestId);
        GetContextLogsResponse logsResponse = new GetContextLogsResponse(resHeaders, object);
        this.extractLogsWithFastJson(logsResponse, object.getJSONArray("logs"));
        return logsResponse;
    }

    @Override
    public ListLogStoresResponse ListLogStores(String project, int offset, int size, String logstoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ListLogStoresRequest request = new ListLogStoresRequest(project, offset, size, logstoreName);
        return this.ListLogStores(request);
    }

    @Override
    public ListLogStoresResponse ListLogStores(ListLogStoresRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores";
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ListLogStoresResponse listLogStoresResponse = new ListLogStoresResponse(resHeaders);
        listLogStoresResponse.SetLogStores(this.ExtractJsonArray("logstores", object));
        listLogStoresResponse.SetTotal(this.ExtractJsonInteger("total", object));
        return listLogStoresResponse;
    }

    @Override
    public ListTopicsResponse ListTopics(String project, String logStore, String token, int line) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(token, "token");
        ListTopicsRequest request = new ListTopicsRequest(project, logStore, token, line);
        return this.ListTopics(request);
    }

    @Override
    public ListTopicsResponse ListTopics(ListTopicsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logStore = request.GetLogStore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray json_array = this.ParseResponseMessageToArray(response, requestId);
        ListTopicsResponse listTopicResponse = new ListTopicsResponse(resHeaders);
        ArrayList<String> string_array = new ArrayList<String>();
        for (int index = 0; index < json_array.size(); ++index) {
            string_array.add(json_array.getString(index));
        }
        listTopicResponse.SetTopics(string_array);
        return listTopicResponse;
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStore, int shardId, long fromTime) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        GetCursorRequest request = new GetCursorRequest(project, logStore, shardId, fromTime);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStore, int shardId, Date fromTime) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStream");
        CodingUtils.assertParameterNotNull(fromTime, "fromTime");
        long timeStamp = Utils.dateToTimestamp(fromTime);
        GetCursorRequest request = new GetCursorRequest(project, logStore, shardId, timeStamp);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStream, int shardId, Consts.CursorMode mode) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStream, "logStream");
        GetCursorRequest request = new GetCursorRequest(project, logStream, shardId, mode);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(GetCursorRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String shardId = String.valueOf(request.GetShardId());
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        headParameter.put("Content-Length", String.valueOf(0));
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            JSONObject object = this.parseResponseBody(response, requestId);
            return new GetCursorResponse(resHeaders, object.getString("cursor"));
        }
        catch (JSONException e) {
            throw new LogException("FailToCreateCursor", e.getMessage(), e, this.GetRequestId(response.getHeaders()));
        }
    }

    @Override
    public GetCursorTimeResponse GetCursorTime(GetCursorTimeRequest request) throws LogException {
        GetCursorTimeResponse getCursorTimeResponse;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String shardId = String.valueOf(request.GetShardId());
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        headParameter.put("Content-Length", String.valueOf(0));
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            JSONObject object = this.parseResponseBody(response, requestId);
            getCursorTimeResponse = new GetCursorTimeResponse(resHeaders, object.getInt("cursor_time"));
        }
        catch (JSONException e) {
            throw new LogException("FailToCreateCursor", e.getMessage(), e, this.GetRequestId(response.getHeaders()));
        }
        return getCursorTimeResponse;
    }

    public GetCursorTimeResponse GetPrevCursorTime(String project, String logStore, int shardId, String cursor) throws LogException {
        if (cursor.isEmpty()) {
            throw new LogException("InvalidCursor", "empty cursor string", "");
        }
        long prv = Long.parseLong(new String(Base64.decodeBase64((String)cursor))) - 1L;
        if (prv < 0L) {
            throw new LogException("InvalidCursor", "this cursor has no prev value", "");
        }
        cursor = new String(Base64.encodeBase64((byte[])Long.toString(prv).getBytes()));
        GetCursorTimeRequest request = new GetCursorTimeRequest(project, logStore, shardId, cursor);
        return this.GetCursorTime(request);
    }

    @Override
    public GetCursorTimeResponse GetCursorTime(String project, String logStore, int shardId, String cursor) throws LogException {
        GetCursorTimeRequest request = new GetCursorTimeRequest(project, logStore, shardId, cursor);
        return this.GetCursorTime(request);
    }

    @Override
    public ListShardResponse SplitShard(String project, String logStore, int shardId, String midHash) throws LogException {
        Args.notNullOrEmpty(project, "project");
        Args.notNullOrEmpty(logStore, "logStore");
        Args.notNullOrEmpty(logStore, "shardId");
        return this.SplitShard(new SplitShardRequest(project, logStore, shardId, midHash));
    }

    @Override
    public ListShardResponse SplitShard(SplitShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        int shardId = request.GetShardId();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ArrayList<Shard> shards = this.ExtractShards(array, requestId);
        return new ListShardResponse(resHeaders, shards);
    }

    @Override
    public ListShardResponse MergeShards(String project, String logStore, int shardId) throws LogException {
        Args.notNullOrEmpty(project, "project");
        Args.notNullOrEmpty(logStore, "logStore");
        Args.notNullOrEmpty(logStore, "shardId");
        return this.MergeShards(new MergeShardsRequest(project, logStore, shardId));
    }

    @Override
    public ListShardResponse MergeShards(MergeShardsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        int shardId = request.GetShardId();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ArrayList<Shard> shards = this.ExtractShards(array, requestId);
        return new ListShardResponse(resHeaders, shards);
    }

    @Override
    public DeleteShardResponse DeleteShard(String project, String logStore, int shardId) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "shardId");
        return this.DeleteShard(new DeleteShardRequest(project, logStore, shardId));
    }

    @Override
    public DeleteShardResponse DeleteShard(DeleteShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        int shardId = request.GetShardId();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteShardResponse(resHeaders);
    }

    @Override
    public ListShardResponse ListShard(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.ListShard(new ListShardRequest(project, logStore));
    }

    public String GetServerIpAddress(String project) {
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/direct_mode_ip";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        HashMap<String, String> out_header = new HashMap<String, String>();
        try {
            this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter, new byte[0], out_header, null);
        }
        catch (LogException logException) {
            // empty catch block
        }
        return Utils.getOrEmpty(out_header, "x-log-hostip");
    }

    @Override
    public ListShardResponse ListShard(ListShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ArrayList<Shard> shards = this.ExtractShards(array, requestId);
        return new ListShardResponse(resHeaders, shards);
    }

    protected String GetRequestId(Map<String, String> headers) {
        return Utils.getOrEmpty(headers, "x-log-requestid");
    }

    @Override
    @Deprecated
    public BatchGetLogResponse BatchGetLog(String project, String logStore, int shardId, int count, String cursor) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.BatchGetLog(new BatchGetLogRequest(project, logStore, shardId, count, cursor));
    }

    @Override
    @Deprecated
    public BatchGetLogResponse BatchGetLog(String project, String logStore, int shardId, int count, String cursor, String end_cursor) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.BatchGetLog(new BatchGetLogRequest(project, logStore, shardId, count, cursor, end_cursor));
    }

    @Override
    @Deprecated
    public BatchGetLogResponse BatchGetLog(BatchGetLogRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String shardId = String.valueOf(request.GetShardId());
        CodingUtils.assertStringNotNullOrEmpty(shardId, "shardId");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + shardId;
        headParameter.put("Accept-Encoding", "lz4");
        headParameter.put("accept", "application/x-protobuf");
        Map<String, String> urlParameter = request.GetAllParams();
        for (int i = 0; i < 2; ++i) {
            String server_ip = this.realServerIP;
            ClientConnectionStatus connection_status = null;
            if (this.mUseDirectMode.booleanValue()) {
                connection_status = this.GetShardConnectionStatus(project, logStore, request.GetShardId());
                server_ip = connection_status.GetIpAddress();
            }
            try {
                ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter, new byte[0], null, server_ip);
                Map<String, String> resHeaders = response.getHeaders();
                byte[] rawData = response.GetRawBody();
                BatchGetLogResponse batchGetLogResponse = new BatchGetLogResponse(resHeaders, rawData);
                if (connection_status != null) {
                    connection_status.UpdateLastUsedTime(System.nanoTime());
                    connection_status.AddPullDataSize(batchGetLogResponse.GetRawSize());
                }
                return batchGetLogResponse;
            }
            catch (LogException e) {
                if (i == 1 || e.GetRequestId() != null && !e.GetRequestId().isEmpty()) {
                    throw e;
                }
                if (connection_status == null) continue;
                connection_status.DisableConnection();
                continue;
            }
        }
        return null;
    }

    @Override
    public PullLogsResponse pullLogs(PullLogsRequest request) throws LogException {
        Args.notNull(request, "request");
        String project = request.GetProject();
        String logStore = request.getLogStore();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shards/" + request.getShardId();
        headers.put("Accept-Encoding", "lz4");
        headers.put("accept", "application/x-protobuf");
        Map<String, String> urlParameter = request.GetAllParams();
        for (int i = 0; i < 2; ++i) {
            String serverIp = this.realServerIP;
            ClientConnectionStatus connectionStatus = null;
            if (this.mUseDirectMode.booleanValue()) {
                connectionStatus = this.GetShardConnectionStatus(project, logStore, request.getShardId());
                serverIp = connectionStatus.GetIpAddress();
            }
            try {
                ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headers, new byte[0], null, serverIp);
                Map<String, String> resHeaders = response.getHeaders();
                PullLogsResponse plr = new PullLogsResponse(resHeaders, response.GetRawBody());
                if (connectionStatus != null) {
                    connectionStatus.UpdateLastUsedTime(System.nanoTime());
                    connectionStatus.AddPullDataSize(plr.getRawSize());
                }
                return plr;
            }
            catch (LogException ex) {
                if (i == 1 || ex.GetRequestId() != null && !ex.GetRequestId().isEmpty()) {
                    throw ex;
                }
                if (connectionStatus == null) continue;
                connectionStatus.DisableConnection();
                continue;
            }
        }
        return null;
    }

    @Override
    public CreateConfigResponse CreateConfig(String project, Config config) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(config, "config");
        return this.CreateConfig(new CreateConfigRequest(project, config));
    }

    @Override
    public CreateConfigResponse CreateConfig(CreateConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Config config = request.GetConfig();
        CodingUtils.assertParameterNotNull(config, "config");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(config.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/configs";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateConfigResponse(resHeaders);
    }

    @Override
    public UpdateConfigResponse UpdateConfig(String project, Config config) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(config, "config");
        return this.UpdateConfig(new UpdateConfigRequest(project, config));
    }

    @Override
    public UpdateConfigResponse UpdateConfig(UpdateConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Config config = request.GetConfig();
        CodingUtils.assertParameterNotNull(config, "config");
        String configName = config.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(config.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/configs/" + configName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateConfigResponse(resHeaders);
    }

    protected Config ExtractConfigFromResponse(JSONObject dict, String requestId) throws LogException {
        Config config = new Config();
        try {
            config.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return config;
    }

    @Override
    public GetConfigResponse GetConfig(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.GetConfig(new GetConfigRequest(project, configName));
    }

    @Override
    public GetConfigResponse GetConfig(GetConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        Config config = this.ExtractConfigFromResponse(object, requestId);
        return new GetConfigResponse(resHeaders, config);
    }

    @Override
    public DeleteConfigResponse DeleteConfig(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.DeleteConfig(new DeleteConfigRequest(project, configName));
    }

    @Override
    public DeleteConfigResponse DeleteConfig(DeleteConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteConfigResponse(resHeaders);
    }

    protected List<String> ExtractConfigs(JSONObject object, String requestId) throws LogException {
        ArrayList<String> configs = new ArrayList<String>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("configs");
            for (int i = 0; i < array.size(); ++i) {
                String configName = array.getString(i);
                configs.add(configName);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return configs;
    }

    @Override
    public ListConfigResponse ListConfig(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListConfig(new ListConfigRequest(project));
    }

    @Override
    public ListConfigResponse ListConfig(String project, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListConfig(new ListConfigRequest(project, offset, size));
    }

    @Override
    public ListConfigResponse ListConfig(String project, String configName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.ListConfig(new ListConfigRequest(project, configName, offset, size));
    }

    public ListConfigResponse ListConfig(String project, String configName, String logstoreName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        CodingUtils.assertStringNotNullOrEmpty(logstoreName, "logstoreName");
        return this.ListConfig(new ListConfigRequest(project, configName, logstoreName, offset, size));
    }

    @Override
    public ListConfigResponse ListConfig(ListConfigRequest request) throws LogException {
        ListConfigResponse listConfigResponse;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.parseResponseBody(response, requestId);
            int total = object.getInt("total");
            int count = object.getInt("count");
            List<String> configs = this.ExtractConfigs(object, requestId);
            listConfigResponse = new ListConfigResponse(resHeaders, count, total, configs);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid list config json string : " + Utils.safeToString(object), e, this.GetRequestId(response.getHeaders()));
        }
        return listConfigResponse;
    }

    @Override
    public CreateMachineGroupResponse CreateMachineGroup(String project, MachineGroup group) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(group, "group");
        return this.CreateMachineGroup(new CreateMachineGroupRequest(project, group));
    }

    @Override
    public CreateMachineGroupResponse CreateMachineGroup(CreateMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        MachineGroup group = request.GetMachineGroup();
        CodingUtils.assertParameterNotNull(group, "group");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        byte[] body = Client.encodeToUtf8(group.ToRequestString());
        String resourceUri = "/machinegroups";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateMachineGroupResponse(resHeaders);
    }

    @Override
    public UpdateMachineGroupResponse UpdateMachineGroup(String project, MachineGroup group) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(group, "group");
        return this.UpdateMachineGroup(new UpdateMachineGroupRequest(project, group));
    }

    @Override
    public UpdateMachineGroupResponse UpdateMachineGroup(UpdateMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        MachineGroup group = request.GetMachineGroup();
        CodingUtils.assertParameterNotNull(group, "group");
        String groupName = group.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(group.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/machinegroups/" + groupName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateMachineGroupResponse(resHeaders);
    }

    protected MachineGroup ExtractMachineGroupFromResponse(JSONObject dict, String requestId) throws LogException {
        MachineGroup group = new MachineGroup();
        try {
            group.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return group;
    }

    protected ArrayList<String> ExtractConfigsFromResponse(JSONObject object) {
        ArrayList<String> configs = new ArrayList<String>();
        JSONArray configobj = object.getJSONArray("configs");
        for (int i = 0; i < configobj.size(); ++i) {
            configs.add(configobj.getString(i));
        }
        return configs;
    }

    protected ArrayList<String> ExtractConfigMachineGroupFromResponse(JSONObject object) {
        ArrayList<String> configs = new ArrayList<String>();
        JSONArray configobj = object.getJSONArray("machinegroups");
        for (int i = 0; i < configobj.size(); ++i) {
            configs.add(configobj.getString(i));
        }
        return configs;
    }

    @Override
    public GetAppliedConfigResponse GetAppliedConfig(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.GetAppliedConfig(new GetAppliedConfigsRequest(project, groupName));
    }

    @Override
    public GetAppliedConfigResponse GetAppliedConfig(GetAppliedConfigsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/configs";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ArrayList<String> group = this.ExtractConfigsFromResponse(object);
        return new GetAppliedConfigResponse(resHeaders, group);
    }

    @Override
    public GetAppliedMachineGroupsResponse GetAppliedMachineGroups(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.GetAppliedMachineGroups(new GetAppliedMachineGroupRequest(project, configName));
    }

    @Override
    public GetAppliedMachineGroupsResponse GetAppliedMachineGroups(GetAppliedMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs/" + configName + "/machinegroups";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ArrayList<String> group = this.ExtractConfigMachineGroupFromResponse(object);
        return new GetAppliedMachineGroupsResponse(resHeaders, group);
    }

    @Override
    public GetMachineGroupResponse GetMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.GetMachineGroup(new GetMachineGroupRequest(project, groupName));
    }

    @Override
    public GetMachineGroupResponse GetMachineGroup(GetMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        MachineGroup group = this.ExtractMachineGroupFromResponse(object, requestId);
        return new GetMachineGroupResponse(resHeaders, group);
    }

    @Override
    public ListMachinesResponse ListMachines(String project, String machineGroup, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(machineGroup, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + machineGroup + "/machines";
        headParameter.put("Content-Length", String.valueOf(0));
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return this.ExtractMachinesFromResponse(resHeaders, object);
    }

    private ListMachinesResponse ExtractMachinesFromResponse(Map<String, String> resHeaders, JSONObject dict) throws LogException {
        try {
            int count = dict.getInt("count");
            int total = dict.getInt("total");
            JSONArray array = dict.getJSONArray("machines");
            ArrayList<Machine> machines = new ArrayList<Machine>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject machine_obj = array.getJSONObject(i);
                Machine machine = new Machine();
                machine.FromJsonObject(machine_obj);
                machines.add(machine);
            }
            return new ListMachinesResponse(resHeaders, count, total, machines);
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), this.GetRequestId(resHeaders));
        }
    }

    @Override
    public ApproveMachineGroupResponse ApproveMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.ApproveMachineGroup(new ApproveMachineGroupRequest(project, groupName));
    }

    @Override
    public ApproveMachineGroupResponse ApproveMachineGroup(ApproveMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/approve";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new ApproveMachineGroupResponse(resHeaders);
    }

    @Override
    public DeleteMachineGroupResponse DeleteMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.DeleteMachineGroup(new DeleteMachineGroupRequest(project, groupName));
    }

    @Override
    public DeleteMachineGroupResponse DeleteMachineGroup(DeleteMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteMachineGroupResponse(resHeaders);
    }

    protected List<String> ExtractMachineGroups(JSONObject object, String requestId) throws LogException {
        ArrayList<String> machineGroups = new ArrayList<String>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("machinegroups");
            for (int i = 0; i < array.size(); ++i) {
                String groupName = array.getString(i);
                machineGroups.add(groupName);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid machine group json array string : " + array.toString(), e, requestId);
        }
        return machineGroups;
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListMachineGroup(new ListMachineGroupRequest(project));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListMachineGroup(new ListMachineGroupRequest(project, offset, size));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project, String groupName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.ListMachineGroup(new ListMachineGroupRequest(project, groupName, offset, size));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(ListMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        ListMachineGroupResponse listMachineGroupResponse = null;
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.parseResponseBody(response, requestId);
            int total = object.getInt("total");
            int count = object.getInt("count");
            List<String> groups = this.ExtractMachineGroups(object, requestId);
            listMachineGroupResponse = new ListMachineGroupResponse(resHeaders, count, total, groups);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json string : " + Utils.safeToString(object), e, this.GetRequestId(response.getHeaders()));
        }
        return listMachineGroupResponse;
    }

    @Override
    public ApplyConfigToMachineGroupResponse ApplyConfigToMachineGroup(String project, String groupName, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.ApplyConfigToMachineGroup(new ApplyConfigToMachineGroupRequest(project, groupName, configName));
    }

    @Override
    public ApplyConfigToMachineGroupResponse ApplyConfigToMachineGroup(ApplyConfigToMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new ApplyConfigToMachineGroupResponse(resHeaders);
    }

    @Override
    public RemoveConfigFromMachineGroupResponse RemoveConfigFromMachineGroup(String project, String groupName, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.RemoveConfigFromMachineGroup(new RemoveConfigFromMachineGroupRequest(project, groupName, configName));
    }

    @Override
    public RemoveConfigFromMachineGroupResponse RemoveConfigFromMachineGroup(RemoveConfigFromMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups/" + groupName + "/configs/" + configName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new RemoveConfigFromMachineGroupResponse(resHeaders);
    }

    @Override
    public UpdateACLResponse UpdateACL(String project, ACL acl) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(acl, "acl");
        return this.UpdateACL(new UpdateACLRequest(project, acl));
    }

    @Override
    public UpdateACLResponse UpdateACL(String project, String logStore, ACL acl) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(acl, "acl");
        return this.UpdateACL(new UpdateACLRequest(project, logStore, acl));
    }

    @Override
    public UpdateACLResponse UpdateACL(UpdateACLRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        ACL acl = request.GetACL();
        CodingUtils.assertParameterNotNull(acl, "acl");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(acl.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/";
        if (!logStore.isEmpty()) {
            resourceUri = resourceUri + "logstores/" + logStore;
        }
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateACLResponse(resHeaders);
    }

    @Override
    public ListACLResponse ListACL(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListACL(new ListACLRequest(project));
    }

    @Override
    public ListACLResponse ListACL(String project, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListACL(new ListACLRequest(project, offset, size));
    }

    @Override
    public ListACLResponse ListACL(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.ListACL(new ListACLRequest(project, logStore));
    }

    @Override
    public ListACLResponse ListACL(String project, String logStore, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.ListACL(new ListACLRequest(project, logStore, offset, size));
    }

    protected ACL ExtractACLFromResponse(JSONObject dict, String requestId) throws LogException {
        ACL acl = new ACL();
        try {
            acl.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return acl;
    }

    protected List<ACL> ExtractACLs(JSONObject object, String requestId) throws LogException {
        ArrayList<ACL> acls = new ArrayList<ACL>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("acls");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject aclDict = array.getJSONObject(i);
                ACL acl = this.ExtractACLFromResponse(aclDict, requestId);
                acls.add(acl);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid acl json array string : " + array.toString(), e, requestId);
        }
        return acls;
    }

    @Override
    public ListACLResponse ListACL(ListACLRequest request) throws LogException {
        ListACLResponse listACLResponse;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/";
        if (!logStore.isEmpty()) {
            resourceUri = resourceUri + "logstores/" + logStore;
        }
        Map<String, String> urlParameter = request.GetAllParams();
        JSONObject object = null;
        ResponseMessage response = new ResponseMessage();
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.parseResponseBody(response, requestId);
            int total = object.getInt("total");
            int count = object.getInt("count");
            List<ACL> acls = this.ExtractACLs(object, requestId);
            listACLResponse = new ListACLResponse(resHeaders, count, total, acls);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid list acl json string : " + Utils.safeToString(object), e, this.GetRequestId(response.getHeaders()));
        }
        return listACLResponse;
    }

    private int ExtractJsonInteger(String nodeKey, JSONObject object) {
        try {
            return object.getInt(nodeKey);
        }
        catch (JSONException jSONException) {
            return -1;
        }
    }

    private List<String> ExtractJsonArray(String nodeKey, JSONObject object) {
        try {
            JSONArray items = object.getJSONArray(nodeKey);
            return this.ExtractJsonArray(items);
        }
        catch (JSONException e) {
            return new ArrayList<String>();
        }
    }

    private List<String> ExtractJsonArray(JSONArray object) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (int i = 0; i < object.size(); ++i) {
                result.add(object.getString(i));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return result;
    }

    private void ExtractHistograms(GetHistogramsResponse response, JSONArray items) {
        try {
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                Histogram histogram = new Histogram(item.getInt("from"), item.getInt("to"), item.getLong("count"), item.getString("progress"));
                response.AddHistogram(histogram);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected void ErrorCheck(JSONObject object, String requestId, int httpCode) throws LogException {
        if (object.containsKey((Object)"errorCode")) {
            try {
                String errorCode = object.getString("errorCode");
                String errorMessage = object.getString("errorMessage");
                throw new LogException(httpCode, errorCode, errorMessage, requestId);
            }
            catch (JSONException e) {
                throw new LogException(httpCode, "InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
            }
        }
        throw new LogException(httpCode, "InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
    }

    private void ExtractResponseBody(ResponseMessage response) throws LogException {
        InputStream in = response.getContent();
        if (in == null) {
            return;
        }
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        String requestId = this.GetRequestId(response.getHeaders());
        try {
            int ch;
            byte[] cache = new byte[1024];
            while ((ch = in.read(cache, 0, 1024)) != -1) {
                bytestream.write(cache, 0, ch);
            }
        }
        catch (IOException e) {
            throw new LogException("BadResponse", "Io exception happened when parse the response data : ", e, requestId);
        }
        response.SetBody(bytestream.toByteArray());
    }

    private JSONObject parseResponseBody(ResponseMessage response, String requestId) throws LogException {
        String body = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return JSONObject.fromObject((Object)body);
        }
        catch (JSONException ex) {
            throw new LogException("BadResponse", "The response is not valid json string : " + body, ex, requestId);
        }
    }

    private com.alibaba.fastjson.JSONObject ParserResponseMessageWithFastJson(ResponseMessage response, String requestId) throws LogException {
        String res = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return com.alibaba.fastjson.JSONObject.parseObject((String)res);
        }
        catch (com.alibaba.fastjson.JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + res, e, requestId);
        }
    }

    private JSONArray ParseResponseMessageToArray(ResponseMessage response, String requestId) throws LogException {
        String returnStr = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            JsonConfig jsonConfig = new JsonConfig();
            jsonConfig.setIgnoreDefaultExcludes(true);
            return JSONArray.fromObject((Object)returnStr, (JsonConfig)jsonConfig);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + returnStr, e, requestId);
        }
    }

    private Map<String, String> GetCommonHeadPara(String project) {
        HashMap<String, String> headParameter = new HashMap<String, String>();
        headParameter.put("User-Agent", this.userAgent);
        headParameter.put("Content-Length", "0");
        headParameter.put("x-log-bodyrawsize", "0");
        headParameter.put("Content-Type", "application/x-protobuf");
        headParameter.put("Date", DateUtil.formatRfc822Date(new Date()));
        if (!project.isEmpty()) {
            headParameter.put("Host", project + "." + this.hostName);
        } else {
            headParameter.put("Host", this.hostName);
        }
        headParameter.put("x-log-apiversion", "0.6.0");
        headParameter.put("x-log-signaturemethod", "hmac-sha1");
        if (this.securityToken != null && !this.securityToken.isEmpty()) {
            headParameter.put("x-acs-security-token", this.securityToken);
        }
        if (this.realIpForConsole != null && !this.realIpForConsole.isEmpty()) {
            headParameter.put("x-log-ip", this.realIpForConsole);
        }
        if (this.useSSLForConsole != null) {
            headParameter.put("x-log-ssl", this.useSSLForConsole != false ? "true" : "false");
        }
        return headParameter;
    }

    private ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> urlParams, Map<String, String> headParams) throws LogException {
        return this.SendData(project, method, resourceUri, urlParams, headParams, new byte[0]);
    }

    protected ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, String requestBody) throws LogException {
        byte[] body = Client.encodeToUtf8(requestBody);
        return this.SendData(project, method, resourceUri, parameters, headers, body);
    }

    protected ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, byte[] body) throws LogException {
        return this.SendData(project, method, resourceUri, parameters, headers, body, null, null);
    }

    private ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, byte[] body, Map<String, String> outputHeader, String serverIp) throws LogException {
        ResponseMessage response;
        block16: {
            if (body.length > 0) {
                headers.put("Content-MD5", DigestUtils.md5Crypt(body));
            }
            if (this.resourceOwnerAccount != null && !this.resourceOwnerAccount.isEmpty()) {
                headers.put("x-log-resourceowneraccount", this.resourceOwnerAccount);
            }
            headers.put("Content-Length", String.valueOf(body.length));
            DigestUtils.addSignature(this.accessId, this.accessKey, method.toString(), headers, resourceUri, parameters);
            URI uri = serverIp == null ? this.GetHostURI(project) : this.GetHostURIByIp(serverIp);
            RequestMessage request = Client.BuildRequest(uri, method, resourceUri, parameters, headers, new ByteArrayInputStream(body), body.length);
            response = null;
            try {
                int statusCode;
                response = this.serviceClient.sendRequest(request, "UTF-8");
                this.ExtractResponseBody(response);
                if (outputHeader != null) {
                    outputHeader.putAll(response.getHeaders());
                }
                if ((statusCode = response.getStatusCode()) == 200) break block16;
                String requestId = this.GetRequestId(response.getHeaders());
                try {
                    JSONObject object = this.parseResponseBody(response, requestId);
                    this.ErrorCheck(object, requestId, statusCode);
                }
                catch (LogException ex) {
                    ex.SetHttpCode(response.getStatusCode());
                    throw ex;
                }
            }
            catch (ServiceException e) {
                throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
            }
            catch (ClientException e) {
                throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return response;
    }

    private static RequestMessage BuildRequest(URI endpoint, HttpMethod httpMethod, String resourceUri, Map<String, String> parameters, Map<String, String> headers, InputStream content, long size) {
        RequestMessage request = new RequestMessage();
        request.setMethod(httpMethod);
        request.setEndpoint(endpoint);
        request.setResourcePath(resourceUri);
        request.setParameters(parameters);
        request.setHeaders(headers);
        request.setContent(content);
        request.setContentLength(size);
        return request;
    }

    protected ArrayList<Shard> ExtractShards(JSONArray array, String requestId) throws LogException {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        try {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject shardDict = array.getJSONObject(i);
                int shardId = shardDict.getInt("shardID");
                String status = shardDict.getString("status");
                String begin = shardDict.getString("inclusiveBeginKey");
                String end = shardDict.getString("exclusiveEndKey");
                int createTime = shardDict.getInt("createTime");
                Shard shard = new Shard(shardId, status, begin, end, createTime);
                if (shardDict.containsKey((Object)"serverIp")) {
                    shard.setServerIp(shardDict.getString("serverIp"));
                }
                shards.add(shard);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid shard json array string : " + array.toString() + e.getMessage(), e, requestId);
        }
        return shards;
    }

    @Override
    public UpdateLogStoreInternalResponse UpdateLogStoreInternal(String project, InternalLogStore internalLogStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(internalLogStore, "InternallogStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(internalLogStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + internalLogStore.GetLogStoreName() + "?type=inner";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateLogStoreInternalResponse(resHeaders);
    }

    @Override
    public CreateLogStoreInternalResponse CreateLogStoreInternal(String project, InternalLogStore internalLogStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(internalLogStore, "InternallogStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(internalLogStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores?type=inner";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateLogStoreInternalResponse(resHeaders);
    }

    @Override
    public CreateLogStoreResponse CreateLogStore(String project, LogStore logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.CreateLogStore(new CreateLogStoreRequest(project, logStore));
    }

    @Override
    public CreateLogStoreResponse CreateLogStore(CreateLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        LogStore logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(logStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateLogStoreResponse(resHeaders);
    }

    @Override
    public DeleteLogStoreResponse DeleteLogStore(String project, String logStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        return this.DeleteLogStore(new DeleteLogStoreRequest(project, logStoreName));
    }

    @Override
    public DeleteLogStoreResponse DeleteLogStore(DeleteLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStoreName();
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStoreName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteLogStoreResponse(resHeaders);
    }

    @Override
    public ClearLogStoreStorageResponse ClearLogStoreStorage(String project, String logStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        return this.ClearLogStoreStorage(new ClearLogStoreStorageRequest(project, logStoreName));
    }

    @Override
    public ClearLogStoreStorageResponse ClearLogStoreStorage(ClearLogStoreStorageRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStoreName();
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStoreName + "/storage";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new ClearLogStoreStorageResponse(resHeaders);
    }

    @Override
    public UpdateLogStoreResponse UpdateLogStore(String project, LogStore logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.UpdateLogStore(new UpdateLogStoreRequest(project, logStore));
    }

    @Override
    public UpdateLogStoreResponse UpdateLogStore(UpdateLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        LogStore logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        String logStoreName = logStore.GetLogStoreName();
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(logStore.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStoreName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateLogStoreResponse(resHeaders);
    }

    @Override
    public GetLogStoreResponse GetLogStore(String project, String logStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        return this.GetLogStore(new GetLogStoreRequest(project, logStoreName));
    }

    private LogStore ExtractLogStoreFromResponse(JSONObject dict, String requestId) throws LogException {
        LogStore logStore = new LogStore();
        try {
            logStore.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return logStore;
    }

    @Override
    public GetLogStoreResponse GetLogStore(GetLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStoreName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        LogStore logStore = this.ExtractLogStoreFromResponse(object, requestId);
        return new GetLogStoreResponse(resHeaders, logStore);
    }

    @Override
    public CreateIndexResponse CreateIndex(String project, String logStore, String indexJsonString) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(indexJsonString, "indexJsonString");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(indexJsonString);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateIndexResponse(resHeaders);
    }

    @Override
    public CreateIndexResponse CreateIndex(String project, String logStore, Index index) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(index, "index");
        return this.CreateIndex(new CreateIndexRequest(project, logStore, index));
    }

    @Override
    public CreateIndexResponse CreateIndex(CreateIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Index index = request.GetIndex();
        CodingUtils.assertParameterNotNull(index, "index");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(index.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateIndexResponse(resHeaders);
    }

    @Override
    public UpdateIndexResponse UpdateIndex(String project, String logStore, String indexJsonString) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(indexJsonString, "indexJsonString");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(indexJsonString);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateIndexResponse(resHeaders);
    }

    @Override
    public UpdateIndexResponse UpdateIndex(String project, String logStore, Index index) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(index, "index");
        return this.UpdateIndex(new UpdateIndexRequest(project, logStore, index));
    }

    @Override
    public UpdateIndexResponse UpdateIndex(UpdateIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Index index = request.GetIndex();
        CodingUtils.assertParameterNotNull(index, "index");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(index.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/index";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateIndexResponse(resHeaders);
    }

    @Override
    public DeleteIndexResponse DeleteIndex(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.DeleteIndex(new DeleteIndexRequest(project, logStore));
    }

    @Override
    public DeleteIndexResponse DeleteIndex(DeleteIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteIndexResponse(resHeaders);
    }

    @Override
    public GetIndexResponse GetIndex(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.GetIndex(new GetIndexRequest(project, logStore));
    }

    @Override
    public GetIndexStringResponse GetIndexString(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.GetIndexString(new GetIndexRequest(project, logStore));
    }

    private Index ExtractIndexFromResponseWithFastJson(com.alibaba.fastjson.JSONObject dict, String requestId) throws LogException {
        Index index = new Index();
        try {
            index.FromJsonString(dict.toJSONString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return index;
    }

    @Override
    public GetIndexResponse GetIndex(GetIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        com.alibaba.fastjson.JSONObject object = this.ParserResponseMessageWithFastJson(response, requestId);
        Index index = this.ExtractIndexFromResponseWithFastJson(object, requestId);
        return new GetIndexResponse(resHeaders, index);
    }

    @Override
    public GetIndexStringResponse GetIndexString(GetIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new GetIndexStringResponse(resHeaders, response.GetStringBody());
    }

    @Override
    public CreateShipperResponse CreateShipper(String project, String logStore, String shipperName, ShipperConfig shipConfig) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        CodingUtils.assertParameterNotNull(shipConfig, "shipConfig");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/shipper";
        JSONObject jsonBody = new JSONObject();
        jsonBody.put((Object)"shipperName", (Object)shipperName);
        jsonBody.put((Object)"targetType", (Object)shipConfig.GetShipperType());
        jsonBody.put((Object)"targetConfiguration", (Object)shipConfig.GetJsonObj());
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateShipperResponse(resHeaders);
    }

    @Override
    public UpdateShipperResponse UpdateShipper(String project, String logStore, String shipperName, ShipperConfig shipConfig) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        CodingUtils.assertParameterNotNull(shipConfig, "shipConfig");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName;
        JSONObject jsonBody = new JSONObject();
        jsonBody.put((Object)"shipperName", (Object)shipperName);
        jsonBody.put((Object)"targetType", (Object)shipConfig.GetShipperType());
        jsonBody.put((Object)"targetConfiguration", (Object)shipConfig.GetJsonObj());
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateShipperResponse(resHeaders);
    }

    @Override
    public DeleteShipperResponse DeleteShipper(String project, String logStore, String shipperName) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteShipperResponse(resHeaders);
    }

    @Override
    public GetShipperResponse GetShipperConfig(String project, String logStore, String shipperName) throws LogException {
        ShipperConfig config;
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        if (object.containsKey((Object)"targetType") && object.getString("targetType").equals("odps")) {
            config = new OdpsShipperConfig();
            config.FromJsonObj(object.getJSONObject("targetConfiguration"));
        } else if (object.containsKey((Object)"targetType") && object.getString("targetType").equals("oss")) {
            config = new OssShipperConfig();
            config.FromJsonObj(object.getJSONObject("targetConfiguration"));
        } else {
            throw new LogException("InvalidShipperType", "The return shipper config is:" + object.toString(), null, requestId);
        }
        return new GetShipperResponse(resHeaders, config);
    }

    @Override
    public ListShipperResponse ListShipper(String project, String logStore) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return new ListShipperResponse(resHeaders, this.ExtractJsonInteger("count", object), this.ExtractJsonInteger("total", object), this.ExtractJsonArray("shipper", object));
    }

    @Override
    public GetShipperTasksResponse GetShipperTasks(String project, String logStore, String shipperName, int startTime, int endTime, String statusType, int offset, int size) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        CodingUtils.assertParameterNotNull(statusType, "statusType");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName + "/tasks";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("from", String.valueOf(startTime));
        urlParameter.put("to", String.valueOf(endTime));
        urlParameter.put("status", statusType);
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        return new GetShipperTasksResponse(resHeaders, this.ExtractJsonInteger("count", object), this.ExtractJsonInteger("total", object), this.ExtractTasksStatisTic(object), this.ExtractShipperTask(object));
    }

    @Override
    public RetryShipperTasksResponse RetryShipperTasks(String project, String logStore, String shipperName, List<String> taskList) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        CodingUtils.assertParameterNotNull(taskList, "taskList");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/shipper/" + shipperName + "/tasks";
        JSONArray array = new JSONArray();
        array.addAll(taskList);
        byte[] body = Client.encodeToUtf8(array.toString());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new RetryShipperTasksResponse(resHeaders);
    }

    private ShipperTasksStatistic ExtractTasksStatisTic(JSONObject obj) {
        JSONObject statistic_obj = obj.getJSONObject("statistics");
        return new ShipperTasksStatistic(statistic_obj.getInt("running"), statistic_obj.getInt("success"), statistic_obj.getInt("fail"));
    }

    private List<ShipperTask> ExtractShipperTask(JSONObject object) {
        ArrayList<ShipperTask> res = new ArrayList<ShipperTask>();
        JSONArray array = object.getJSONArray("tasks");
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.getJSONObject(i);
            ShipperTask task = new ShipperTask();
            task.FromJsonObject(item);
            res.add(task);
        }
        return res;
    }

    @Override
    public CreateConsumerGroupResponse CreateConsumerGroup(String project, String logStore, ConsumerGroup consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.CreateConsumerGroup(new CreateConsumerGroupRequest(project, logStore, consumerGroup));
    }

    @Override
    public CreateConsumerGroupResponse CreateConsumerGroup(CreateConsumerGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ConsumerGroup consumerGroup = request.GetConsumerGroup();
        CodingUtils.assertParameterNotNull(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(consumerGroup.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + request.GetLogStore() + "/consumergroups";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateConsumerGroupResponse(resHeaders);
    }

    protected UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, Boolean inOrder, Integer timeoutInSec) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logstore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        JSONObject asJson = new JSONObject();
        if (inOrder != null) {
            asJson.put((Object)"order", (Object)inOrder);
        }
        if (timeoutInSec != null) {
            asJson.put((Object)"timeout", (Object)timeoutInSec);
        }
        byte[] body = Client.encodeToUtf8(asJson.toString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateConsumerGroupResponse(resHeaders);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, boolean inOrder, int timeoutInSec) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, (Boolean)inOrder, (Integer)timeoutInSec);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, boolean inOrder) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, (Boolean)inOrder, null);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, int timeoutInSec) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, null, (Integer)timeoutInSec);
    }

    @Override
    public DeleteConsumerGroupResponse DeleteConsumerGroup(String project, String logStore, String consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        headParameter.put("Content-Length", String.valueOf(0));
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteConsumerGroupResponse(resHeaders);
    }

    @Override
    public ListConsumerGroupResponse ListConsumerGroup(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String resourceUri = "/logstores/" + logStore + "/consumergroups";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        ArrayList<ConsumerGroup> consumerGroups = new ArrayList<ConsumerGroup>();
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        this.ExtractConsumerGroups(array, requestId, consumerGroups);
        ListConsumerGroupResponse listConsumerGroupResponse = new ListConsumerGroupResponse(resHeaders);
        listConsumerGroupResponse.SetConsumerGroups(consumerGroups);
        return listConsumerGroupResponse;
    }

    private void ExtractConsumerGroups(JSONArray array, String requestId, ArrayList<ConsumerGroup> consumerGroups) throws LogException {
        try {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject consumerGroup = array.getJSONObject(i);
                consumerGroups.add(new ConsumerGroup(consumerGroup.getString("name"), consumerGroup.getInt("timeout"), consumerGroup.getBoolean("order")));
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid consumer group json array string : " + array.toString(), e, requestId);
        }
    }

    @Override
    public ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, String consumer, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateCheckPoint(project, logStore, consumerGroup, consumer, shard, checkpoint, false);
    }

    @Override
    public ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateCheckPoint(project, logStore, consumerGroup, "", shard, checkpoint, true);
    }

    protected ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, String consumer, int shard, String checkpoint, boolean forceSuccess) throws LogException {
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        ConsumerGroupUpdateCheckPointRequest request = new ConsumerGroupUpdateCheckPointRequest(project, logStore, consumerGroup, consumer, forceSuccess, shard, checkpoint);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        byte[] body = Client.encodeToUtf8(request.GetRequestBody());
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new ConsumerGroupUpdateCheckPointResponse(resHeaders);
    }

    @Override
    public ConsumerGroupHeartBeatResponse HeartBeat(String project, String logStore, String consumerGroup, String consumer, ArrayList<Integer> shards) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        ConsumerGroupHeartBeatRequest request = new ConsumerGroupHeartBeatRequest(project, logStore, consumerGroup, consumer, shards == null ? new ArrayList() : shards);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        byte[] body = Client.encodeToUtf8(request.GetRequestBody());
        headParameter.put("Content-Type", "application/json");
        ArrayList<Integer> responseShards = new ArrayList<Integer>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        this.ExtractShards(array, requestId, responseShards);
        return new ConsumerGroupHeartBeatResponse(resHeaders, (List<Integer>)responseShards);
    }

    protected void ExtractShards(JSONArray array, String requestId, List<Integer> shards) throws LogException {
        try {
            for (int i = 0; i < array.size(); ++i) {
                shards.add(array.getInt(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid shard json array string : " + array.toString(), e, requestId);
        }
    }

    @Override
    public ConsumerGroupCheckPointResponse GetCheckPoint(String project, String logStore, String consumerGroup) throws LogException {
        return this.GetCheckPoint(project, logStore, consumerGroup, -1);
    }

    @Override
    public ConsumerGroupCheckPointResponse GetCheckPoint(String project, String logStore, String consumerGroup, int shard) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        ConsumerGroupGetCheckPointRequest request = new ConsumerGroupGetCheckPointRequest(project, logStore, consumerGroup, shard);
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        return new ConsumerGroupCheckPointResponse(resHeaders, array);
    }

    @Override
    public CreateProjectResponse CreateProject(String project, String projectDescription) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        if (projectDescription == null) {
            projectDescription = "";
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/";
        JSONObject jsonBody = new JSONObject();
        jsonBody.put((Object)"projectName", (Object)project);
        jsonBody.put((Object)"description", (Object)projectDescription);
        byte[] body = Client.encodeToUtf8(jsonBody.toString());
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateProjectResponse(resHeaders);
    }

    @Override
    public GetProjectResponse GetProject(String project) throws LogException {
        Args.notNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        GetProjectResponse getProjectResponse = new GetProjectResponse(resHeaders);
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        getProjectResponse.FromJsonObject(object);
        return getProjectResponse;
    }

    @Override
    public DeleteProjectResponse DeleteProject(String project) throws LogException {
        Args.notNullOrEmpty(project, "project");
        String resourceUri = "/";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteProjectResponse(resHeaders);
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) throws LogException {
        Args.notNull(request, "request");
        String resourceUri = "/";
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, "/", Collections.<String, String>emptyMap(), headers, JsonUtils.serialize(request.getBody()));
        return new UpdateProjectResponse(response.getHeaders());
    }

    @Override
    public UpdateMachineGroupMachineResponse AddMachineIntoMahineGroup(String project, String groupName, MachineList machineList) throws LogException {
        return this.UpdateMachineGroupMachine(project, groupName, machineList, false);
    }

    @Override
    public UpdateMachineGroupMachineResponse AddMachineIntoMachineGroup(UpdateMachineGroupMachineRequest request) throws LogException {
        return this.UpdateMachineGroupMachine(request.GetProject(), request.GetGroupName(), request.GetMachineList(), false);
    }

    @Override
    public UpdateMachineGroupMachineResponse DeleteMachineFromMachineGroup(String project, String groupName, MachineList machineList) throws LogException {
        return this.UpdateMachineGroupMachine(project, groupName, machineList, true);
    }

    @Override
    public UpdateMachineGroupMachineResponse DeleteMachineFromMachineGroup(UpdateMachineGroupMachineRequest request) throws LogException {
        return this.UpdateMachineGroupMachine(request.GetProject(), request.GetGroupName(), request.GetMachineList(), true);
    }

    protected UpdateMachineGroupMachineResponse UpdateMachineGroupMachine(String project, String groupName, MachineList machineList, boolean isDelete) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(machineList.ToRequestString());
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/machinegroups/" + groupName + "/machines";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("action", isDelete ? "delete" : "add");
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateMachineGroupMachineResponse(resHeaders);
    }

    @Override
    public ListProjectResponse ListProject() throws LogException {
        ListProjectRequest listProjectRequest = new ListProjectRequest("", 0, 500);
        return this.ListProject(listProjectRequest);
    }

    @Override
    public ListProjectResponse ListProject(String projectName, int offset, int size) throws LogException {
        ListProjectRequest listProjectRequest = new ListProjectRequest(projectName, offset, size);
        return this.ListProject(listProjectRequest);
    }

    protected List<Project> ExtractProjects(JSONObject object, String requestId) throws LogException {
        ArrayList<Project> projects = new ArrayList<Project>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("projects");
            for (int i = 0; i < array.size(); ++i) {
                Project tempProject = new Project();
                tempProject.FromJsonObject(array.getJSONObject(i));
                projects.add(tempProject);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return projects;
    }

    @Override
    public ListProjectResponse ListProject(ListProjectRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        ListProjectResponse listProjectResponse = null;
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.parseResponseBody(response, requestId);
            int total = object.getInt("total");
            int count = object.getInt("count");
            List<Project> projects = this.ExtractProjects(object, requestId);
            listProjectResponse = new ListProjectResponse(resHeaders, total, count, projects);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid list project json string : " + Utils.safeToString(object), e, this.GetRequestId(response.getHeaders()));
        }
        return listProjectResponse;
    }

    private void checkSavedSearchResource(SavedSearch savedSearch) {
        CodingUtils.assertStringNotNullOrEmpty(savedSearch.getSavedSearchName(), "savedsearchName");
        CodingUtils.assertStringNotNullOrEmpty(savedSearch.getLogstore(), "logstore");
    }

    @Override
    public CreateChartResponse createChart(CreateChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getChart().ToJsonString());
        return new CreateChartResponse(response.getHeaders());
    }

    @Override
    public UpdateChartResponse updateChart(UpdateChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts/" + request.getChartName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, urlParameter, headParameter, request.getChart().ToJsonString());
        return new UpdateChartResponse(response.getHeaders());
    }

    @Override
    public DeleteChartResponse deleteChart(DeleteChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts/" + request.getChartName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteChartResponse(response.getHeaders());
    }

    protected Chart ExtractChartFromResponse(JSONObject dict, String requestId) throws LogException {
        Chart chart = new Chart();
        try {
            chart.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return chart;
    }

    @Override
    public GetChartResponse getChart(GetChartRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards/" + request.getDashboardName() + "/charts/" + request.getChartName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        Chart chart = this.ExtractChartFromResponse(object, requestId);
        return new GetChartResponse(response.getHeaders(), chart);
    }

    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getDashboard().ToJsonString());
        return new CreateDashboardResponse(response.getHeaders());
    }

    @Override
    public UpdateDashboardResponse updateDashboard(UpdateDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards/" + request.getDashboard().getDashboardName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, urlParameter, headParameter, request.getDashboard().ToJsonString());
        return new UpdateDashboardResponse(response.getHeaders());
    }

    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards/" + request.getDashboardName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteDashboardResponse(response.getHeaders());
    }

    protected Dashboard ExtractDashboardFromResponse(JSONObject dict, String requestId) throws LogException {
        Dashboard dashboard = new Dashboard();
        try {
            dashboard.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return dashboard;
    }

    @Override
    public GetDashboardResponse getDashboard(GetDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards/" + request.getDashboardName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        Dashboard dashboard = this.ExtractDashboardFromResponse(object, requestId);
        return new GetDashboardResponse(response.getHeaders(), dashboard);
    }

    protected List<Dashboard> ExtractDashboards(JSONObject object, String requestId) throws LogException {
        ArrayList<Dashboard> dashboards = new ArrayList<Dashboard>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("dashboardItems");
            for (int index = 0; index < array.size(); ++index) {
                Dashboard dashboard = new Dashboard();
                dashboard.setDashboardName(array.getJSONObject(index).getString("dashboardName"));
                dashboard.setDisplayName(array.getJSONObject(index).getString("displayName"));
                dashboards.add(dashboard);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return dashboards;
    }

    @Override
    public ListDashboardResponse listDashboard(ListDashboardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/dashboards";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getInt("total");
        int count = object.getInt("count");
        List<Dashboard> dashboards = this.ExtractDashboards(object, requestId);
        return new ListDashboardResponse(response.getHeaders(), count, total, dashboards);
    }

    @Override
    public CreateSavedSearchResponse createSavedSearch(CreateSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        this.checkSavedSearchResource(request.getSavedSearch());
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getSavedSearch().ToJsonString());
        return new CreateSavedSearchResponse(response.getHeaders());
    }

    @Override
    public UpdateSavedSearchResponse updateSavedSearch(UpdateSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        this.checkSavedSearchResource(request.getSavedSearch());
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches/" + request.getSavedSearch().getSavedSearchName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.PUT, resourceUri, urlParameter, headParameter, request.getSavedSearch().ToJsonString());
        return new UpdateSavedSearchResponse(response.getHeaders());
    }

    @Override
    public DeleteSavedSearchResponse deleteSavedSearch(DeleteSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.assertStringNotNullOrEmpty(request.getSavedSearchName(), "savedsearchName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches/" + request.getSavedSearchName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteSavedSearchResponse(response.getHeaders());
    }

    protected SavedSearch ExtractSavedSearchFromResponse(JSONObject dict, String requestId) throws LogException {
        SavedSearch savedSearch = new SavedSearch();
        try {
            savedSearch.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return savedSearch;
    }

    @Override
    public GetSavedSearchResponse getSavedSearch(GetSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.assertStringNotNullOrEmpty(request.getSavedSearchName(), "savedsearchName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches/" + request.getSavedSearchName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        SavedSearch savedSearch = this.ExtractSavedSearchFromResponse(object, requestId);
        return new GetSavedSearchResponse(response.getHeaders(), savedSearch);
    }

    protected List<SavedSearch> ExtractSavedSearches(JSONObject object, String requestId) throws LogException {
        ArrayList<SavedSearch> savedSearches = new ArrayList<SavedSearch>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("savedsearchItems");
            for (int index = 0; index < array.size(); ++index) {
                SavedSearch savedSearch = new SavedSearch();
                savedSearch.setSavedSearchName(array.getJSONObject(index).getString("savedsearchName"));
                savedSearch.setDisplayName(array.getJSONObject(index).getString("displayName"));
                savedSearches.add(savedSearch);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return savedSearches;
    }

    @Override
    public ListSavedSearchResponse listSavedSearch(ListSavedSearchRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/savedsearches";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getInt("total");
        int count = object.getInt("count");
        List<SavedSearch> savedSearches = this.ExtractSavedSearches(object, requestId);
        return new ListSavedSearchResponse(response.getHeaders(), count, total, savedSearches);
    }

    @Override
    public CreateDomainResponse createDomain(String project, Domain domain) throws LogException {
        CreateDomainRequest request = new CreateDomainRequest(project, domain);
        return this.createDomain(request);
    }

    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest request) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.assertStringNotNullOrEmpty(request.getDomain().getDomainName(), "domainName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/domains";
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.POST, resourceUri, urlParameter, headParameter, request.getDomain().toJsonString());
        return new CreateDomainResponse(response.getHeaders());
    }

    @Override
    public DeleteDomainResponse deleteDomain(String project, String domainName) throws LogException {
        DeleteDomainRequest request = new DeleteDomainRequest(project, domainName);
        return this.deleteDomain(request);
    }

    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest request) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        CodingUtils.assertStringNotNullOrEmpty(request.getDomainName(), "domainName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/domains/" + request.getDomainName();
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteDomainResponse(response.getHeaders());
    }

    @Override
    public ListDomainsResponse listDomains(String project, String domainName, int offset, int size) throws LogException {
        ListDomainsRequest request = new ListDomainsRequest(project, domainName, offset, size);
        return this.listDomains(request);
    }

    protected List<Domain> ExtractDomains(JSONObject object, String requestId) throws LogException {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("domains");
            for (int index = 0; index < array.size(); ++index) {
                Domain domain = new Domain();
                domain.setDomainName(array.getString(index));
                domains.add(domain);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return domains;
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest request) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "projectName");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/domains";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        int total = object.getInt("total");
        int count = object.getInt("count");
        List<Domain> domains = this.ExtractDomains(object, requestId);
        return new ListDomainsResponse(response.getHeaders(), count, total, domains);
    }

    @Override
    public CreateIngestionResponse createIngestion(CreateIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public UpdateIngestionResponse updateIngestion(UpdateIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new UpdateIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public DeleteIngestionResponse deleteIngestion(DeleteIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public GetIngestionResponse getIngestion(GetIngestionRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetIngestionResponse ingestionResponse = new GetIngestionResponse(response.getHeaders());
        ingestionResponse.deserialize(responseBody, response.getRequestId());
        return ingestionResponse;
    }

    @Override
    public ListIngestionResponse listIngestion(ListIngestionRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListIngestionResponse listIngestionResponse = new ListIngestionResponse(response.getHeaders());
        listIngestionResponse.deserialize(responseBody, response.getRequestId());
        return listIngestionResponse;
    }

    @Override
    public StopIngestionResponse stopIngestion(StopIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public StartIngestionResponse startIngestion(StartIngestionRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StartIngestionResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateRebuildResponse createRebuildIndex(CreateRebuildIndexRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateRebuildResponse(responseMessage.getHeaders());
    }

    @Override
    public GetRebuildIndexResponse getRebuildIndex(GetRebuildIndexRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        JSONObject responseBody = this.parseResponseBody(message, message.getRequestId());
        GetRebuildIndexResponse response = new GetRebuildIndexResponse(message.getHeaders());
        response.deserialize(responseBody, message.getRequestId());
        return response;
    }

    @Override
    public DeleteRebuildIndexResponse deleteRebuildIndex(DeleteRebuildIndexRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteRebuildIndexResponse(responseMessage.getHeaders());
    }

    @Override
    public ListRebuildIndexResponse listRebuildIndex(ListRebuildIndexRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        JSONObject responseBody = this.parseResponseBody(message, message.getRequestId());
        ListRebuildIndexResponse response = new ListRebuildIndexResponse(message.getHeaders());
        response.deserialize(responseBody, message.getRequestId());
        return response;
    }

    @Override
    public StopRebuildIndexResponse stopRebuildIndex(StopRebuildIndexRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopRebuildIndexResponse(responseMessage.getHeaders());
    }

    @Override
    public UpdateAlertResponse updateAlert(UpdateAlertRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new UpdateAlertResponse(message.getHeaders());
    }

    @Override
    public DeleteAlertResponse deleteAlert(DeleteAlertRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteAlertResponse(responseMessage.getHeaders());
    }

    @Override
    public DeleteJobScheduleResponse deleteJobSchedule(DeleteJobScheduleRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new DeleteJobScheduleResponse(message.getHeaders());
    }

    @Override
    public DeleteETLResponse deleteETL(DeleteETLRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteETLResponse(responseMessage.getHeaders());
    }

    @Override
    public GetAlertResponse getAlert(GetAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetAlertResponse alertResponse = new GetAlertResponse(response.getHeaders());
        alertResponse.deserialize(responseBody, response.getRequestId());
        return alertResponse;
    }

    @Override
    public GetJobScheduleResponse getJobSchedule(GetJobScheduleRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        JSONObject responseBody = this.parseResponseBody(message, message.getRequestId());
        GetJobScheduleResponse response = new GetJobScheduleResponse(message.getHeaders());
        response.deserialize(responseBody, message.getRequestId());
        return response;
    }

    @Override
    public GetETLResponse getETL(GetETLRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetETLResponse etlResponse = new GetETLResponse(response.getHeaders());
        etlResponse.deserialize(responseBody, response.getRequestId());
        return etlResponse;
    }

    @Override
    public ListAlertResponse listAlert(ListAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListAlertResponse alertResponse = new ListAlertResponse(response.getHeaders());
        alertResponse.deserialize(responseBody, response.getRequestId());
        return alertResponse;
    }

    @Override
    public ListETLResponse listETL(ListETLRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListETLResponse listETLResponse = new ListETLResponse(response.getHeaders());
        listETLResponse.deserialize(responseBody, response.getRequestId());
        return listETLResponse;
    }

    @Override
    public CreateReportResponse createReport(CreateReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateReportResponse(responseMessage.getHeaders());
    }

    @Override
    public GetReportResponse getReport(GetReportRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetReportResponse getReportResponse = new GetReportResponse(response.getHeaders());
        getReportResponse.deserialize(responseBody, response.getRequestId());
        return getReportResponse;
    }

    @Override
    public UpdateReportResponse updateReport(UpdateReportRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new UpdateReportResponse(message.getHeaders());
    }

    @Override
    public UpdateETLResponse updateETL(UpdateETLRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new UpdateETLResponse(message.getHeaders());
    }

    @Override
    public DeleteReportResponse deleteReport(DeleteReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DeleteReportResponse(responseMessage.getHeaders());
    }

    @Override
    public ListReportResponse listReport(ListReportRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListReportResponse listReportResponse = new ListReportResponse(response.getHeaders());
        listReportResponse.deserialize(responseBody, response.getRequestId());
        return listReportResponse;
    }

    @Override
    public EnableReportResponse enableReport(EnableReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new EnableReportResponse(responseMessage.getHeaders());
    }

    @Override
    public DisableReportResponse disableReport(DisableReportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new DisableReportResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateEtlJobResponse createEtlJob(CreateEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        EtlJob etlJob = request.getEtlJob();
        CodingUtils.assertParameterNotNull(etlJob, "etlJob");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(etlJob.toJsonString(true, true));
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etljobs";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        return new CreateEtlJobResponse(response.getHeaders());
    }

    @Override
    public DeleteEtlJobResponse deleteEtlJob(DeleteEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String etlJobName = request.getEtlJobName();
        CodingUtils.assertStringNotNullOrEmpty(etlJobName, "etlJobName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etljobs/" + etlJobName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteEtlJobResponse(response.getHeaders());
    }

    @Override
    public UpdateEtlJobResponse updateEtlJob(UpdateEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        EtlJob etlJob = request.getEtlJob();
        CodingUtils.assertParameterNotNull(etlJob, "etlJob");
        CodingUtils.assertStringNotNullOrEmpty(etlJob.getJobName(), "etlJobName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        byte[] body = Client.encodeToUtf8(etlJob.toJsonString(false, false));
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etljobs/" + etlJob.getJobName();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        return new UpdateEtlJobResponse(response.getHeaders());
    }

    @Override
    public GetEtlJobResponse getEtlJob(GetEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String etlJobName = request.getEtlJobName();
        CodingUtils.assertStringNotNullOrEmpty(etlJobName, "etlJobName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etljobs/" + etlJobName;
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        EtlJob etlJob = new EtlJob();
        etlJob.fromJsonObject(object);
        return new GetEtlJobResponse(resHeaders, etlJob);
    }

    @Override
    public ListEtlJobResponse listEtlJob(ListEtlJobRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertStringNotNullOrEmpty(request.GetProject(), "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        String resourceUri = "/etljobs";
        headParameter.put("Content-Type", "application/json");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        ListEtlJobResponse listResp = new ListEtlJobResponse(response.getHeaders(), object.getInt("total"));
        listResp.setEtlJobNameList(this.ExtractJsonArray("etlJobNameList", object));
        return listResp;
    }

    @Override
    public CreateEtlMetaResponse createEtlMeta(String project, EtlMeta etlMeta) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMeta, "etlMeta");
        etlMeta.checkForCreate();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, etlMeta.toJsonObject().toString());
        return new CreateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public CreateEtlMetaResponse batchCreateEtlMeta(String project, ArrayList<EtlMeta> etlMetaList) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMetaList, "etlMetaList");
        if (etlMetaList.size() == 0 || etlMetaList.size() > 100) {
            throw new IllegalArgumentException("etlMetaList size not valid, should be [1, 100]");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        JSONObject requestBodyJsonObject = new JSONObject();
        JSONArray etlMetaJsonArray = new JSONArray();
        for (EtlMeta meta : etlMetaList) {
            meta.checkForCreate();
            etlMetaJsonArray.add((Object)meta.toJsonObject());
        }
        requestBodyJsonObject.put((Object)"etlMetaList", (Object)etlMetaJsonArray);
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, requestBodyJsonObject.toString());
        return new CreateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public DeleteEtlMetaResponse deleteEtlMeta(String project, String etlMetaName, String etlMetaKey) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaKey, "etlMetaKey");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("etlMetaName", etlMetaName);
        urlParameter.put("etlMetaKey", etlMetaKey);
        urlParameter.put("etlMetaTag", "__all_etl_meta_tag_match__");
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteEtlMetaResponse(response.getHeaders());
    }

    @Override
    public DeleteEtlMetaResponse deleteEtlMeta(String project, String etlMetaName, String etlMetaKey, String etlMetaTag) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaKey, "etlMetaKey");
        CodingUtils.assertParameterNotNull(etlMetaTag, "etlMetaTag");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("etlMetaName", etlMetaName);
        urlParameter.put("etlMetaKey", etlMetaKey);
        urlParameter.put("etlMetaTag", etlMetaTag);
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        return new DeleteEtlMetaResponse(response.getHeaders());
    }

    @Override
    public BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, String etlMetaTag, Consts.BatchModifyEtlMetaType type) throws LogException {
        return this.batchModifyEtlMetaStatus(project, etlMetaName, null, etlMetaTag, "all", type);
    }

    @Override
    public BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, ArrayList<String> etlMetaKeyList, Consts.BatchModifyEtlMetaType type) throws LogException {
        return this.batchModifyEtlMetaStatus(project, etlMetaName, etlMetaKeyList, "__all_etl_meta_tag_match__", type);
    }

    @Override
    public BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, ArrayList<String> etlMetaKeyList, String etlMetaTag, Consts.BatchModifyEtlMetaType type) throws LogException {
        return this.batchModifyEtlMetaStatus(project, etlMetaName, etlMetaKeyList, etlMetaTag, "list", type);
    }

    private BatchModifyEtlMetaStatusResponse batchModifyEtlMetaStatus(String project, String etlMetaName, ArrayList<String> etlMetaKeyList, String etlMetaTag, String range, Consts.BatchModifyEtlMetaType type) throws LogException {
        if (range.equals("list")) {
            if (etlMetaKeyList == null || etlMetaKeyList.size() == 0 || etlMetaKeyList.size() > 200) {
                throw new IllegalArgumentException("etlMetaKeyList size not valid, should be [1, 200]");
            }
        } else if (range.equals("all")) {
            if (etlMetaTag.equals("__all_etl_meta_tag_match__")) {
                throw new IllegalArgumentException("parameter etlMetaTag can not be `__all_etl_meta_tag_match__` when batchDelete by tag");
            }
        } else {
            throw new IllegalArgumentException("range not valid, should be `all` or `list`");
        }
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(etlMetaTag, "etlMetaTag");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("type", type.toString());
        JSONObject requestBodyJsonObject = new JSONObject();
        requestBodyJsonObject.put((Object)"etlMetaName", (Object)etlMetaName);
        requestBodyJsonObject.put((Object)"etlMetaTag", (Object)etlMetaTag);
        requestBodyJsonObject.put((Object)"range", (Object)range);
        if (range.equals("list")) {
            JSONArray etlMetaKeyJsonArray = new JSONArray();
            etlMetaKeyJsonArray.addAll(etlMetaKeyList);
            requestBodyJsonObject.put((Object)"etlMetaKeyList", (Object)etlMetaKeyJsonArray);
        }
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, requestBodyJsonObject.toString());
        return new BatchModifyEtlMetaStatusResponse(response.getHeaders());
    }

    @Override
    public UpdateEtlMetaResponse updateEtlMeta(String project, EtlMeta etlMeta) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMeta, "etlMeta");
        etlMeta.checkForUpdate();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, etlMeta.toJsonObject().toString());
        return new UpdateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public UpdateEtlMetaResponse batchUpdateEtlMeta(String project, ArrayList<EtlMeta> etlMetaList) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(etlMetaList, "etlMetaList");
        if (etlMetaList.size() == 0 || etlMetaList.size() > 100) {
            throw new IllegalArgumentException("etlMetaList size not valid, should be [1, 100]");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/etlmetas";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        JSONObject requestBodyJsonObject = new JSONObject();
        JSONArray etlMetaJsonArray = new JSONArray();
        for (EtlMeta meta : etlMetaList) {
            meta.checkForUpdate();
            etlMetaJsonArray.add((Object)meta.toJsonObject());
        }
        requestBodyJsonObject.put((Object)"etlMetaList", (Object)etlMetaJsonArray);
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, requestBodyJsonObject.toString());
        return new UpdateEtlMetaResponse(response.getHeaders());
    }

    @Override
    public ListEtlMetaNameResponse listEtlMetaName(String project, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/etlmetanames";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.parseResponseBody(response, requestId);
        ListEtlMetaNameResponse listResp = new ListEtlMetaNameResponse(response.getHeaders(), object.getInt("total"));
        listResp.setEtlMetaNameList(this.ExtractJsonArray("etlMetaNameList", object));
        return listResp;
    }

    private ListEtlMetaResponse listEtlMeta(ListEtlMetaRequest request) throws LogException {
        Map<String, String> headParameter = this.GetCommonHeadPara(request.GetProject());
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/etlmetas";
        ResponseMessage response = this.SendData(request.GetProject(), HttpMethod.GET, resourceUri, urlParameter, headParameter);
        String requestId = this.GetRequestId(response.getHeaders());
        JSONObject object = this.parseResponseBody(response, requestId);
        ListEtlMetaResponse listResp = new ListEtlMetaResponse(response.getHeaders(), object.getInt("total"));
        try {
            JSONArray items = object.getJSONArray("etlMetaList");
            for (int i = 0; i < items.size(); ++i) {
                EtlMeta meta = new EtlMeta();
                meta.fromJsonObject(items.getJSONObject(i));
                listResp.addEtlMeta(meta);
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", e.getMessage(), listResp.GetRequestId());
        }
        return listResp;
    }

    @Override
    public ListEtlMetaResponse listEtlMeta(String project, String etlMetaName, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, offset, size);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey("");
        request.setEtlMetaTag("__all_etl_meta_tag_match__");
        return this.listEtlMeta(request);
    }

    @Override
    public ListEtlMetaResponse listEtlMeta(String project, String etlMetaName, String etlMetaTag, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(etlMetaTag, "etlMetaTag");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, offset, size);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey("");
        request.setEtlMetaTag(etlMetaTag);
        return this.listEtlMeta(request);
    }

    @Override
    public ListEtlMetaResponse listEtlMeta(String project, String etlMetaName, String dispatchProject, String dispatchLogstore, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(etlMetaName, "etlMetaName");
        CodingUtils.assertParameterNotNull(dispatchProject, "dispatchProject");
        CodingUtils.assertParameterNotNull(dispatchLogstore, "dispatchLogstore");
        CodingUtils.assertParameterNotNull(offset, "offset");
        CodingUtils.assertParameterNotNull(size, "size");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, offset, size);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey("");
        request.setEtlMetaTag("__all_etl_meta_tag_match__");
        request.setDispatchProject(dispatchProject);
        request.setDispatchLogstore(dispatchLogstore);
        return this.listEtlMeta(request);
    }

    @Override
    public ListEtlMetaResponse getEtlMeta(String project, String etlMetaName, String etlMetaKey) throws LogException {
        Args.notNullOrEmpty(project, "project");
        Args.notNullOrEmpty(etlMetaName, "etlMetaName");
        Args.notNullOrEmpty(etlMetaKey, "etlMetaKey");
        ListEtlMetaRequest request = new ListEtlMetaRequest(project, 0, 1);
        request.setEtlMetaName(etlMetaName);
        request.setEtlMetaKey(etlMetaKey);
        request.setEtlMetaTag("__all_etl_meta_tag_match__");
        return this.listEtlMeta(request);
    }

    @Override
    public CreateLoggingResponse createLogging(CreateLoggingRequest request) throws LogException {
        Args.notNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        Logging logging = request.getLogging();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, "/logging", Collections.<String, String>emptyMap(), headers, logging.marshal().toString());
        return new CreateLoggingResponse(response.getHeaders());
    }

    @Override
    public UpdateLoggingResponse updateLogging(UpdateLoggingRequest request) throws LogException {
        Args.notNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        Logging logging = request.getLogging();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, "/logging", Collections.<String, String>emptyMap(), headers, logging.marshal().toString());
        return new UpdateLoggingResponse(response.getHeaders());
    }

    @Override
    public GetLoggingResponse getLogging(GetLoggingRequest request) throws LogException {
        Args.notNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, "/logging", Collections.<String, String>emptyMap(), headers);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        try {
            return new GetLoggingResponse(response.getHeaders(), Logging.unmarshal(responseBody));
        }
        catch (JSONException ex) {
            throw new LogException("BadResponse", ex.getMessage(), response.getRequestId());
        }
    }

    @Override
    public DeleteLoggingResponse deleteLogging(DeleteLoggingRequest request) throws LogException {
        Args.notNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, "/logging", Collections.<String, String>emptyMap(), headers);
        return new DeleteLoggingResponse(response.getHeaders());
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new CreateJobResponse(response.getHeaders());
    }

    @Override
    public CreateAlertResponse createAlert(CreateAlertRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateAlertResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateETLResponse createETL(CreateETLRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new CreateETLResponse(responseMessage.getHeaders());
    }

    @Override
    public CreateJobScheduleResponse createJobSchedule(CreateJobScheduleRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        CreateJobScheduleResponse response = new CreateJobScheduleResponse(message.getHeaders());
        JSONObject responseBody = this.parseResponseBody(message, message.getRequestId());
        response.deserialize(responseBody, message.getRequestId());
        return response;
    }

    @Override
    public UpdateJobScheduleResponse updateJobSchedule(UpdateJobScheduleRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new UpdateJobScheduleResponse(message.getHeaders());
    }

    @Override
    public StartJobScheduleResponse startJobSchedule(StartJobScheduleRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new StartJobScheduleResponse(message.getHeaders());
    }

    @Override
    public StopJobScheduleResponse stopJobSchedule(StopJobScheduleRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        return new StopJobScheduleResponse(message.getHeaders());
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        GetJobResponse getJobResponse = new GetJobResponse(response.getHeaders());
        getJobResponse.deserialize(responseBody, response.getRequestId());
        return getJobResponse;
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new UpdateJobResponse(response.getHeaders());
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new DeleteJobResponse(response.getHeaders());
    }

    @Override
    public EnableJobResponse enableJob(EnableJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new EnableJobResponse(response.getHeaders());
    }

    @Override
    public EnableAlertResponse enableAlert(EnableAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new EnableAlertResponse(response.getHeaders());
    }

    @Override
    public DisableJobResponse disableJob(DisableJobRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new DisableJobResponse(response.getHeaders());
    }

    @Override
    public DisableAlertResponse disableAlert(DisableAlertRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        return new DisableAlertResponse(response.getHeaders());
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) throws LogException {
        ResponseMessage response = this.send(request);
        JSONObject responseBody = this.parseResponseBody(response, response.getRequestId());
        ListJobsResponse jobsResponse = new ListJobsResponse(response.getHeaders());
        jobsResponse.deserialize(responseBody, response.getRequestId());
        return jobsResponse;
    }

    @Override
    public ListJobSchedulesResponse listJobSchedules(ListJobSchedulesRequest request) throws LogException {
        ResponseMessage message = this.send(request);
        JSONObject response = this.parseResponseBody(message, message.getRequestId());
        ListJobSchedulesResponse jobRunsResponse = new ListJobSchedulesResponse(message.getHeaders());
        jobRunsResponse.deserialize(response, message.getRequestId());
        return jobRunsResponse;
    }

    @Override
    public CreateExportResponse createExport(CreateExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new CreateExportResponse(resp.getHeaders());
    }

    @Override
    public UpdateExportResponse updateExport(UpdateExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new UpdateExportResponse(resp.getHeaders());
    }

    @Override
    public DeleteExportResponse deleteExport(DeleteExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        return new DeleteExportResponse(resp.getHeaders());
    }

    @Override
    public GetExportResponse getExport(GetExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        GetExportResponse exportResp = new GetExportResponse(resp.getHeaders());
        exportResp.deserialize(respBody, resp.getRequestId());
        return exportResp;
    }

    @Override
    public ListExportResponse listExport(ListExportRequest request) throws LogException {
        ResponseMessage resp = this.send(request);
        JSONObject respBody = this.parseResponseBody(resp, resp.getRequestId());
        ListExportResponse listResp = new ListExportResponse(resp.getHeaders());
        listResp.deserialize(respBody, resp.getRequestId());
        return listResp;
    }

    @Override
    public StopExportResponse stopExport(StopExportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StopExportResponse(responseMessage.getHeaders());
    }

    @Override
    public StartExportResponse startExport(StartExportRequest request) throws LogException {
        ResponseMessage responseMessage = this.send(request);
        return new StartExportResponse(responseMessage.getHeaders());
    }

    private ResponseMessage send(BasicRequest request) throws LogException {
        Args.notNull(request, "request");
        String project = request.GetProject();
        Map<String, String> headers = this.GetCommonHeadPara(project);
        Object body = request.getBody();
        byte[] requestBody = body == null ? new byte[]{} : Client.encodeToUtf8(JsonUtils.serialize(body));
        return this.SendData(project, request.getMethod(), request.getUri(), request.GetAllParams(), headers, requestBody);
    }

    public String getRealServerIP() {
        return this.realServerIP;
    }

    public void setRealServerIP(String realServerIP) {
        this.realServerIP = realServerIP;
    }
}

