/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.CsvColumn;
import com.aliyun.openservices.log.common.ExternalStore;
import com.aliyun.openservices.log.common.Parameter;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.util.GzipUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class CsvExternalStore
extends ExternalStore {
    private static final long serialVersionUID = 6493204290917634292L;
    private static final long MAX_FILE_SIZE = 0x3200000L;
    private static final long MAX_FILE_SIZE_COMPRESSED = 10475520L;
    private static final String STORE_TYPE_CSV = "csv";

    public CsvExternalStore(String externalStoreName, byte[] csvFileContent, List<CsvColumn> columns) throws LogException {
        super(externalStoreName, STORE_TYPE_CSV, null);
        if ((long)csvFileContent.length > 0x3200000L) {
            throw new LogException("InvalidExternalStoreCsvConfig", "The csv file content is too large, max size is 52428800", "");
        }
        byte[] compressed = GzipUtils.compress(csvFileContent);
        if ((long)compressed.length > 10475520L) {
            throw new LogException("InvalidExternalStoreCsvConfig", "The compressed csv file content is too large, max size is10475520", "");
        }
        String fileContentBase64 = new String(Base64.encodeBase64((byte[])compressed));
        List<String> objects = Arrays.asList("table.csv");
        this.setParameter(new Parameter(fileContentBase64, csvFileContent.length, objects, columns));
    }

    public List<CsvColumn> getColumns() {
        return this.getParameter().getColumns();
    }

    public String getExternalStoreCsv() {
        return this.getParameter().getObjects().get(0);
    }

    public CsvExternalStore(JSONObject object) throws LogException {
        super(object);
    }
}

