package com.aliyun.openservices.log.http.comm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import com.aliyun.openservices.log.http.utils.CaseInsensitiveMap;

/**
 * The base class for message of HTTP request and response.
 * @author xiaoming.yin
 *
 */
public abstract class HttpMessage {
	
	private Map<String, String> headers = new CaseInsensitiveMap<String>();
    private InputStream content;
    private long contentLength;

    public Map<String, String> getHeaders() {
        return headers;
    }
    
    public void setHeaders(Map<String, String> headers){
        assert (headers != null);
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public InputStream getContent() {
        return content;
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public long getContentLength() {
        return contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    /**
     * Indicate whether the request should be repeatedly sent.
     */
    public boolean isRepeatable() {
        return content == null || content.markSupported();
    }

    public void close() throws IOException{
        if (content != null){
            content.close();
            content = null;
        }
    }
}
