/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.DecryptRequest;
import com.aliyun.dkms.gcs.sdk.models.DecryptResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyun.kms.utils.EncryptionContextUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DecryptTransferHandler
implements KmsTransferHandler<DecryptRequest, DecryptResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public DecryptTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public <T extends AcsResponse> DecryptRequest buildDKMSRequest(AcsRequest<T> request, RuntimeOptions runtimeOptions) throws ClientException {
        com.aliyuncs.kms.model.v20160120.DecryptRequest decryptKmsRequest = (com.aliyuncs.kms.model.v20160120.DecryptRequest)request;
        if (StringUtils.isEmpty((CharSequence)decryptKmsRequest.getCiphertextBlob())) {
            throw this.newMissingParameterClientException("CiphertextBlob");
        }
        DecryptRequest decryptDKmsRequest = new DecryptRequest();
        byte[] ciphertextBlob = base64.decode(decryptKmsRequest.getCiphertextBlob());
        if (ciphertextBlob.length <= 48) {
            throw this.newInvalidParameterClientException("CiphertextBlob");
        }
        byte[] ektIdBytes = Arrays.copyOfRange(ciphertextBlob, 0, 36);
        byte[] ivBytes = Arrays.copyOfRange(ciphertextBlob, 36, 48);
        byte[] ciphertextBytes = Arrays.copyOfRange(ciphertextBlob, 48, ciphertextBlob.length);
        final String ektId = new String(ektIdBytes, StandardCharsets.UTF_8);
        decryptDKmsRequest.setRequestHeaders((Map)new HashMap<String, String>(){
            {
                this.put("x-kms-migrationkeyversionid", ektId);
            }
        });
        decryptDKmsRequest.setIv(ivBytes);
        decryptDKmsRequest.setCiphertextBlob(ciphertextBytes);
        String encryptionContext = decryptKmsRequest.getEncryptionContext();
        if (!StringUtils.isEmpty((CharSequence)encryptionContext)) {
            decryptDKmsRequest.setAad(EncryptionContextUtils.sortAndEncode(encryptionContext, StandardCharsets.UTF_8));
        }
        return decryptDKmsRequest;
    }

    @Override
    public DecryptResponse callDKMS(DecryptRequest dkmsRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        return this.client.decryptWithOptions(dkmsRequest, runtimeOptions);
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, DecryptResponse response) throws ClientException {
        Map responseHeaders = response.getResponseHeaders();
        String keyVersionId = null;
        if (responseHeaders != null) {
            keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid");
        }
        com.aliyuncs.kms.model.v20160120.DecryptResponse decryptKmsResponse = new com.aliyuncs.kms.model.v20160120.DecryptResponse();
        decryptKmsResponse.setKeyId(response.getKeyId());
        decryptKmsResponse.setKeyVersionId(keyVersionId);
        decryptKmsResponse.setPlaintext(new String(response.getPlaintext(), StandardCharsets.UTF_8));
        decryptKmsResponse.setRequestId(response.getRequestId());
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)decryptKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

