/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.EncryptRequest;
import com.aliyun.dkms.gcs.sdk.models.EncryptResponse;
import com.aliyun.dkms.gcs.sdk.models.GenerateDataKeyRequest;
import com.aliyun.dkms.gcs.sdk.models.GenerateDataKeyResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyun.kms.utils.ArrayUtils;
import com.aliyun.kms.utils.EncryptionContextUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyWithoutPlaintextRequest;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyWithoutPlaintextResponse;
import com.aliyuncs.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenerateDataKeyWithoutPlaintextTransferHandler
implements KmsTransferHandler<GenerateDataKeyRequest, GenerateDataKeyResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public GenerateDataKeyWithoutPlaintextTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public <T extends AcsResponse> GenerateDataKeyRequest buildDKMSRequest(AcsRequest<T> request, RuntimeOptions runtimeOptions) throws ClientException {
        GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextKmsRequest = (GenerateDataKeyWithoutPlaintextRequest)request;
        GenerateDataKeyRequest generateDataKeyWithoutPlaintextDKmsRequest = new GenerateDataKeyRequest();
        generateDataKeyWithoutPlaintextDKmsRequest.setKeyId(generateDataKeyWithoutPlaintextKmsRequest.getKeyId());
        String keySpec = generateDataKeyWithoutPlaintextKmsRequest.getKeySpec();
        Integer numberOfBytes = generateDataKeyWithoutPlaintextKmsRequest.getNumberOfBytes();
        if (numberOfBytes == null) {
            if (StringUtils.isEmpty((CharSequence)keySpec) || "AES_256".equals(keySpec)) {
                numberOfBytes = 32;
            } else if ("AES_128".equals(keySpec)) {
                numberOfBytes = 16;
            } else {
                throw new ClientException("InvalidParameter", "The specified parameter KeySpec is not valid.");
            }
        }
        generateDataKeyWithoutPlaintextDKmsRequest.setNumberOfBytes(numberOfBytes);
        String encryptionContext = generateDataKeyWithoutPlaintextKmsRequest.getEncryptionContext();
        if (!StringUtils.isEmpty((CharSequence)encryptionContext)) {
            generateDataKeyWithoutPlaintextDKmsRequest.setAad(EncryptionContextUtils.sortAndEncode(encryptionContext, StandardCharsets.UTF_8));
        }
        return generateDataKeyWithoutPlaintextDKmsRequest;
    }

    @Override
    public GenerateDataKeyResponse callDKMS(GenerateDataKeyRequest dkmsRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        GenerateDataKeyResponse generateDataKeyResponse = this.client.generateDataKeyWithOptions(dkmsRequest, runtimeOptions);
        EncryptRequest encryptRequest = new EncryptRequest();
        encryptRequest.setKeyId(dkmsRequest.getKeyId());
        encryptRequest.setPlaintext(base64.encodeAsString(generateDataKeyResponse.getPlaintext()).getBytes(StandardCharsets.UTF_8));
        encryptRequest.setAad(dkmsRequest.getAad());
        EncryptResponse encryptResponse = this.client.encryptWithOptions(encryptRequest, runtimeOptions);
        generateDataKeyResponse.setCiphertextBlob(encryptResponse.getCiphertextBlob());
        generateDataKeyResponse.setIv(encryptResponse.getIv());
        return generateDataKeyResponse;
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, GenerateDataKeyResponse response) throws ClientException {
        String keyVersionId;
        Map responseHeaders = response.getResponseHeaders();
        if (responseHeaders == null || responseHeaders.size() == 0 || StringUtils.isEmpty((CharSequence)(keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid")))) {
            throw new ClientException(String.format("Can not found response headers parameter[%s]", "x-kms-migrationkeyversionid"));
        }
        byte[] ciphertextBlob = ArrayUtils.concatAll(keyVersionId.getBytes(StandardCharsets.UTF_8), response.getIv(), response.getCiphertextBlob());
        GenerateDataKeyWithoutPlaintextResponse generateDataKeyWithoutPlaintextKmsResponse = new GenerateDataKeyWithoutPlaintextResponse();
        generateDataKeyWithoutPlaintextKmsResponse.setKeyId(response.getKeyId());
        generateDataKeyWithoutPlaintextKmsResponse.setKeyVersionId(keyVersionId);
        generateDataKeyWithoutPlaintextKmsResponse.setRequestId(response.getRequestId());
        generateDataKeyWithoutPlaintextKmsResponse.setCiphertextBlob(base64.encodeToString(ciphertextBlob));
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)generateDataKeyWithoutPlaintextKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

