/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.dkms.gcs.sdk.Client;
import com.aliyun.dkms.gcs.sdk.models.DecryptRequest;
import com.aliyun.dkms.gcs.sdk.models.DecryptResponse;
import com.aliyun.kms.handlers.KmsTransferHandler;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.kms.model.v20160120.AsymmetricDecryptRequest;
import com.aliyuncs.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsymmetricDecryptTransferHandler
implements KmsTransferHandler<DecryptRequest, DecryptResponse> {
    private static final List<String> responseHeaders = new ArrayList<String>(){
        {
            this.add("x-kms-migrationkeyversionid");
        }
    };
    private final Client client;
    private final String action;

    public AsymmetricDecryptTransferHandler(Client client, String action) {
        this.client = client;
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public DecryptRequest buildDKMSRequest(AcsRequest request, RuntimeOptions runtimeOptions) throws ClientException {
        AsymmetricDecryptRequest asymmetricDecryptKmsRequest = (AsymmetricDecryptRequest)request;
        if (StringUtils.isEmpty((CharSequence)asymmetricDecryptKmsRequest.getCiphertextBlob())) {
            throw this.newMissingParameterClientException("CiphertextBlob");
        }
        DecryptRequest asymmetricDecryptDKmsRequest = new DecryptRequest();
        asymmetricDecryptDKmsRequest.setKeyId(asymmetricDecryptKmsRequest.getKeyId());
        asymmetricDecryptDKmsRequest.setCiphertextBlob(base64.decode(asymmetricDecryptKmsRequest.getCiphertextBlob()));
        asymmetricDecryptDKmsRequest.setAlgorithm(asymmetricDecryptKmsRequest.getAlgorithm());
        final String keyVersionId = asymmetricDecryptKmsRequest.getKeyVersionId();
        if (!StringUtils.isEmpty((CharSequence)keyVersionId)) {
            asymmetricDecryptDKmsRequest.setRequestHeaders((Map)new HashMap<String, String>(){
                {
                    this.put("x-kms-migrationkeyversionid", keyVersionId);
                }
            });
        }
        return asymmetricDecryptDKmsRequest;
    }

    @Override
    public DecryptResponse callDKMS(DecryptRequest dkmsRequest, RuntimeOptions runtimeOptions) throws Exception {
        runtimeOptions.setResponseHeaders(responseHeaders);
        return this.client.decryptWithOptions(dkmsRequest, runtimeOptions);
    }

    @Override
    public HttpResponse transferResponse(AcsRequest request, DecryptResponse response) throws ClientException {
        Map responseHeaders = response.getResponseHeaders();
        String keyVersionId = null;
        if (responseHeaders != null) {
            keyVersionId = (String)responseHeaders.get("x-kms-migrationkeyversionid");
        }
        com.aliyuncs.kms.model.v20160120.DecryptResponse asymmetricDecryptKmsResponse = new com.aliyuncs.kms.model.v20160120.DecryptResponse();
        asymmetricDecryptKmsResponse.setKeyId(response.getKeyId());
        asymmetricDecryptKmsResponse.setKeyVersionId(keyVersionId);
        asymmetricDecryptKmsResponse.setPlaintext(base64.encodeToString(response.getPlaintext()));
        asymmetricDecryptKmsResponse.setRequestId(response.getRequestId());
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatus(200);
        httpResponse.setHttpContent(this.getHttpContent(request.getSysAcceptFormat(), (AcsResponse)asymmetricDecryptKmsResponse), StandardCharsets.UTF_8.displayName(), request.getSysAcceptFormat());
        return httpResponse;
    }
}

