/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.iot.model.v20180120;

import com.aliyuncs.RpcAcsRequest;

/**
 * @author auto create
 * @version 
 */
public class QueryProductListRequest extends RpcAcsRequest<QueryProductListResponse> {
	
	public QueryProductListRequest() {
		super("Iot", "2018-01-20", "QueryProductList");
	}

	private Integer pageSize;

	private Integer currentPage;

	private String aliyunCommodityCode;

	public Integer getPageSize() {
		return this.pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
		if(pageSize != null){
			putQueryParameter("PageSize", pageSize.toString());
		}
	}

	public Integer getCurrentPage() {
		return this.currentPage;
	}

	public void setCurrentPage(Integer currentPage) {
		this.currentPage = currentPage;
		if(currentPage != null){
			putQueryParameter("CurrentPage", currentPage.toString());
		}
	}

	public String getAliyunCommodityCode() {
		return this.aliyunCommodityCode;
	}

	public void setAliyunCommodityCode(String aliyunCommodityCode) {
		this.aliyunCommodityCode = aliyunCommodityCode;
		if(aliyunCommodityCode != null){
			putQueryParameter("AliyunCommodityCode", aliyunCommodityCode);
		}
	}

	@Override
	public Class<QueryProductListResponse> getResponseClass() {
		return QueryProductListResponse.class;
	}

}
