/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.iot.model.v20170420;

import com.aliyuncs.RpcAcsRequest;

/**
 * @author auto create
 * @version 
 */
public class SaveDevicePropRequest extends RpcAcsRequest<SaveDevicePropResponse> {
	
	public SaveDevicePropRequest() {
		super("Iot", "2017-04-20", "SaveDeviceProp");
	}

	private String deviceName;

	private String productKey;

	private String props;

	public String getDeviceName() {
		return this.deviceName;
	}

	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
		if(deviceName != null){
			putQueryParameter("DeviceName", deviceName);
		}
	}

	public String getProductKey() {
		return this.productKey;
	}

	public void setProductKey(String productKey) {
		this.productKey = productKey;
		if(productKey != null){
			putQueryParameter("ProductKey", productKey);
		}
	}

	public String getProps() {
		return this.props;
	}

	public void setProps(String props) {
		this.props = props;
		if(props != null){
			putQueryParameter("Props", props);
		}
	}

	@Override
	public Class<SaveDevicePropResponse> getResponseClass() {
		return SaveDevicePropResponse.class;
	}

}
