/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyuncs.iot.model.v20170420;

import com.aliyuncs.RpcAcsRequest;

/**
 * @author auto create
 * @version 
 */
public class RRpcRequest extends RpcAcsRequest<RRpcResponse> {
	
	public RRpcRequest() {
		super("Iot", "2017-04-20", "RRpc");
	}

	private String requestBase64Byte;

	private String deviceName;

	private String productKey;

	private Integer timeout;

	public String getRequestBase64Byte() {
		return this.requestBase64Byte;
	}

	public void setRequestBase64Byte(String requestBase64Byte) {
		this.requestBase64Byte = requestBase64Byte;
		if(requestBase64Byte != null){
			putQueryParameter("RequestBase64Byte", requestBase64Byte);
		}
	}

	public String getDeviceName() {
		return this.deviceName;
	}

	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
		if(deviceName != null){
			putQueryParameter("DeviceName", deviceName);
		}
	}

	public String getProductKey() {
		return this.productKey;
	}

	public void setProductKey(String productKey) {
		this.productKey = productKey;
		if(productKey != null){
			putQueryParameter("ProductKey", productKey);
		}
	}

	public Integer getTimeout() {
		return this.timeout;
	}

	public void setTimeout(Integer timeout) {
		this.timeout = timeout;
		if(timeout != null){
			putQueryParameter("Timeout", timeout.toString());
		}
	}

	@Override
	public Class<RRpcResponse> getResponseClass() {
		return RRpcResponse.class;
	}

}
