/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.regions;

import com.aliyuncs.auth.Credential;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.regions.DescribeEndpointResponse;
import com.aliyuncs.regions.DescribeEndpointService;
import com.aliyuncs.regions.DescribeEndpointServiceImpl;
import com.aliyuncs.regions.Endpoint;
import com.aliyuncs.regions.IEndpointsProvider;
import com.aliyuncs.regions.LocationConfig;
import com.aliyuncs.regions.ProductDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RemoteEndpointsParser
implements IEndpointsProvider {
    private final ConcurrentMap<String, Endpoint> endpointMap = new ConcurrentHashMap<String, Endpoint>();
    private DescribeEndpointService describeEndpointService;

    public void setDescribeEndpointService(DescribeEndpointService describeEndpointService) {
        this.describeEndpointService = describeEndpointService;
    }

    public static RemoteEndpointsParser initRemoteEndpointsParser() {
        RemoteEndpointsParser parser = new RemoteEndpointsParser();
        parser.setDescribeEndpointService(new DescribeEndpointServiceImpl());
        return parser;
    }

    @Override
    public Endpoint getEndpoint(String regionId, String product) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Endpoint getEndpoint(String regionId, String product, String serviceCode, String endpointType, Credential credential, LocationConfig locationConfig) throws ClientException {
        Endpoint endpoint = (Endpoint)this.endpointMap.get(serviceCode);
        if (endpoint != null) {
            return endpoint;
        }
        DescribeEndpointResponse response = this.describeEndpointService.describeEndpoint(regionId, serviceCode, endpointType, credential, locationConfig);
        if (response == null) {
            return endpoint;
        }
        HashSet<String> regionIds = new HashSet<String>();
        regionIds.add(response.getRegionId());
        ArrayList<ProductDomain> productDomainList = new ArrayList<ProductDomain>();
        productDomainList.add(new ProductDomain(product, response.getEndpoint()));
        endpoint = new Endpoint(response.getRegionId(), regionIds, productDomainList);
        this.endpointMap.putIfAbsent(serviceCode, endpoint);
        return endpoint;
    }

    public static void main(String[] args) throws ClientException {
        DefaultProfile profile = DefaultProfile.getProfile("cn-qingdao", "account", "secret");
        List<Endpoint> list = profile.getEndpoints("Ecs", "ecs", "");
        System.out.println(list.get(0));
    }
}

