/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client.utils;

import com.aliyuncs.exceptions.ClientException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class CommonLogger
implements Closeable {
    private static Map<String, CommonLogger> commonLoggerMap = new HashMap<String, CommonLogger>();
    private static List<String> allowModes = new ArrayList<String>(){
        {
            this.add("CacheClient");
        }
    };
    private Logger logger;
    private String modeName;

    private CommonLogger(String modeName, Logger logger) {
        this.logger = logger;
        this.modeName = modeName;
    }

    public static void registerLogger(String modeName, Logger logger) {
        if (!allowModes.contains(modeName)) {
            throw new IllegalArgumentException(String.format("the modeName [%s] is invalid", modeName));
        }
        commonLoggerMap.put(modeName, new CommonLogger(modeName, logger));
    }

    public static CommonLogger getCommonLogger(String modeName) {
        if (!commonLoggerMap.containsKey(modeName)) {
            throw new IllegalArgumentException(String.format("the modeName [%s] need register", modeName));
        }
        return commonLoggerMap.get(modeName);
    }

    public static boolean isRegistered(String modeName) {
        return commonLoggerMap.containsKey(modeName);
    }

    public void flush() {
    }

    public void tracef(String format, Object ... parameters) {
        this.logger.trace(this.parseExceptionErrorMsg(format, parameters), parameters);
    }

    public void infof(String format, Object ... parameters) {
        this.logger.info(this.parseExceptionErrorMsg(format, parameters), parameters);
    }

    public void debugf(String format, Object ... parameters) {
        this.logger.debug(this.parseExceptionErrorMsg(format, parameters), parameters);
    }

    public void warnf(String format, Object ... parameters) {
        this.logger.warn(this.parseExceptionErrorMsg(format, parameters), parameters);
    }

    public void errorf(String format, Object ... parameters) {
        this.logger.error(this.parseExceptionErrorMsg(format, parameters), parameters);
    }

    public String parseExceptionErrorMsg(String format, Object[] parameters) {
        if (parameters != null && parameters.length > 0) {
            Throwable e;
            Object parameter = parameters[parameters.length - 1];
            if (parameter instanceof ClientException) {
                ClientException ce = (ClientException)((Object)parameter);
                format = format + String.format("\tmodeName:%s\terrorCode:%s\terrMsg:%s\terrorType:%s\terrorDescription:%s\trequestId:%s", this.modeName, ce.getErrCode(), ce.getErrMsg(), ce.getErrorType(), ce.getErrorDescription(), ce.getRequestId());
            } else if (parameter instanceof Throwable && (e = (Throwable)parameter).getCause() != null && e.getCause() instanceof ClientException) {
                ClientException ce = (ClientException)e.getCause();
                format = format + String.format("\tmodeName:%s\terrorCode:%s\terrMsg:%s\terrorType:%s\terrorDescription:%s\trequestId:%s", this.modeName, ce.getErrCode(), ce.getErrMsg(), ce.getErrorType(), ce.getErrorDescription(), ce.getRequestId());
            }
        }
        return format;
    }

    @Override
    public void close() throws IOException {
    }
}

