/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.kms.secretsmanager.client;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.kms.model.v20160120.GetSecretValueRequest;
import com.aliyuncs.kms.model.v20160120.GetSecretValueResponse;
import com.aliyuncs.kms.secretsmanager.client.cache.CacheSecretStoreStrategy;
import com.aliyuncs.kms.secretsmanager.client.cache.SecretCacheHook;
import com.aliyuncs.kms.secretsmanager.client.exception.CacheSecretException;
import com.aliyuncs.kms.secretsmanager.client.model.CacheSecretInfo;
import com.aliyuncs.kms.secretsmanager.client.model.SecretInfo;
import com.aliyuncs.kms.secretsmanager.client.service.RefreshSecretStrategy;
import com.aliyuncs.kms.secretsmanager.client.service.SecretManagerClient;
import com.aliyuncs.kms.secretsmanager.client.utils.BackoffUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.ByteBufferUtils;
import com.aliyuncs.kms.secretsmanager.client.utils.CommonLogger;
import com.aliyuncs.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SecretCacheClient
implements Closeable {
    private static final long DEFAULT_TTL = 3600000L;
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(5);
    private final Map<String, ScheduledFuture> scheduledFutureMap = new ConcurrentHashMap<String, ScheduledFuture>();
    private final Map<String, Long> nextExecuteTimeMap = new ConcurrentHashMap<String, Long>();
    protected String stage = "ACSCurrent";
    protected String jsonTTLPropertyName = "ttl";
    protected SecretManagerClient secretClient;
    protected CacheSecretStoreStrategy cacheSecretStoreStrategy;
    protected RefreshSecretStrategy refreshSecretStrategy;
    protected SecretCacheHook cacheHook;
    protected Map<String, Long> secretTTLMap = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretInfo getSecretInfo(String secretName) throws CacheSecretException {
        if (StringUtils.isEmpty((CharSequence)secretName)) {
            throw new IllegalArgumentException("the argument[secretName] must not be null");
        }
        CacheSecretInfo cacheSecretInfo = this.cacheSecretStoreStrategy.getCacheSecretInfo(secretName);
        if (this.checkCacheSecretInfoIsValid(cacheSecretInfo)) {
            return this.cacheHook.get(cacheSecretInfo);
        }
        String string = secretName.intern();
        synchronized (string) {
            cacheSecretInfo = this.cacheSecretStoreStrategy.getCacheSecretInfo(secretName);
            if (this.checkCacheSecretInfoIsValid(cacheSecretInfo)) {
                return this.cacheHook.get(cacheSecretInfo);
            }
            SecretInfo secretInfo = this.getSecretValue(secretName);
            this.storeAndRefresh(secretName, secretInfo);
            return this.cacheHook.put(secretInfo) == null ? null : this.cacheHook.put(secretInfo).getSecretInfo();
        }
    }

    public String getStringValue(String secretName) throws CacheSecretException {
        SecretInfo secretInfo = this.getSecretInfo(secretName);
        if (secretInfo == null) {
            return null;
        }
        if (!"text".equals(secretInfo.getSecretDataType())) {
            throw new IllegalArgumentException(String.format("the secret named[%s] do not support text value", secretName));
        }
        return secretInfo.getSecretValue();
    }

    public ByteBuffer getBinaryValue(String secretName) throws CacheSecretException {
        SecretInfo secretInfo = this.getSecretInfo(secretName);
        if (secretInfo == null) {
            return null;
        }
        if (!"binary".equals(secretInfo.getSecretDataType())) {
            throw new IllegalArgumentException(String.format("the secret named[%s] do not support binary value", secretName));
        }
        return ByteBufferUtils.convertStringToByte(secretInfo.getSecretValue());
    }

    public boolean refreshNow(String secretName) throws InterruptedException {
        if (StringUtils.isEmpty((CharSequence)secretName)) {
            throw new IllegalArgumentException("the argument[secretName] must not be null");
        }
        return this.refreshNow(secretName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshNow(String secretName, SecretInfo secretInfo) throws InterruptedException {
        boolean executeResult = true;
        String string = secretName.intern();
        synchronized (string) {
            try {
                this.refresh(secretName, secretInfo);
            }
            catch (Throwable e) {
                CommonLogger.getCommonLogger("CacheClient").errorf("action:refresh", e);
                executeResult = false;
            }
            try {
                this.removeRefreshTask(secretName);
            }
            catch (Throwable e) {
                CommonLogger.getCommonLogger("CacheClient").errorf("action:removeRefreshTask", e);
                executeResult = false;
            }
            try {
                this.addRefreshTask(secretName, new RefreshSecretTask(secretName));
            }
            catch (Throwable e) {
                CommonLogger.getCommonLogger("CacheClient").errorf("action:addRefreshTask", e);
                executeResult = false;
            }
        }
        return executeResult;
    }

    protected void init() throws CacheSecretException {
        this.secretClient.init();
        this.cacheSecretStoreStrategy.init();
        this.refreshSecretStrategy.init();
        this.cacheHook.init();
        for (String secretName : this.secretTTLMap.keySet()) {
            SecretInfo secretInfo;
            block3: {
                secretInfo = null;
                try {
                    secretInfo = this.getSecretValue(secretName);
                }
                catch (CacheSecretException e) {
                    CommonLogger.getCommonLogger("CacheClient").errorf("action:initSecretCacheClient", e);
                    if (!this.judgeSkipRefreshException(e)) break block3;
                    throw e;
                }
            }
            this.storeAndRefresh(secretName, secretInfo);
        }
        new Thread(new MonitorRefreshSecretTask()).start();
        CommonLogger.getCommonLogger("CacheClient").infof("secretCacheClient init success", new Object[0]);
    }

    private boolean judgeCacheExpire(CacheSecretInfo cacheSecretInfo) {
        long ttl = this.refreshSecretStrategy.parseTTL(cacheSecretInfo.getSecretInfo());
        if (ttl <= 0L) {
            ttl = this.secretTTLMap.getOrDefault(cacheSecretInfo.getSecretInfo().getSecretName(), 3600000L);
        }
        return System.currentTimeMillis() - cacheSecretInfo.getRefreshTimestamp() > ttl;
    }

    private SecretInfo getSecretValue(String secretName) throws CacheSecretException {
        GetSecretValueResponse resp;
        GetSecretValueRequest request = new GetSecretValueRequest();
        request.setSecretName(secretName);
        request.setVersionStage(this.stage);
        request.setFetchExtendedConfig(Boolean.valueOf(true));
        request.setAcceptFormat(FormatType.XML);
        try {
            resp = this.secretClient.getSecretValue(request);
        }
        catch (ClientException e) {
            CommonLogger.getCommonLogger("CacheClient").errorf("action:getSecretValue", new Object[]{e});
            if (!BackoffUtils.judgeNeedRecoveryException(e)) {
                throw new CacheSecretException(e);
            }
            try {
                SecretInfo secretInfo = this.cacheHook.recoveryGetSecret(secretName);
                if (secretInfo != null) {
                    return secretInfo;
                }
                throw e;
            }
            catch (ClientException ce) {
                CommonLogger.getCommonLogger("CacheClient").errorf("action:getSecretValue", new Object[]{e});
                throw new CacheSecretException(e);
            }
        }
        return new SecretInfo(resp.getSecretName(), resp.getVersionId(), resp.getSecretData(), resp.getSecretDataType(), resp.getCreateTime(), resp.getSecretType(), resp.getAutomaticRotation(), resp.getExtendedConfig(), resp.getRotationInterval(), resp.getNextRotationDate());
    }

    private void storeAndRefresh(String secretName, SecretInfo secretInfo) throws CacheSecretException {
        try {
            this.refreshNow(secretName, secretInfo);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void refresh(String secretName, SecretInfo secretInfo) throws CacheSecretException {
        CacheSecretInfo cacheSecretInfo;
        if (secretInfo == null) {
            secretInfo = this.getSecretValue(secretName);
        }
        if ((cacheSecretInfo = this.cacheHook.put(secretInfo)) != null) {
            this.cacheSecretStoreStrategy.storeSecret(cacheSecretInfo);
        }
        CommonLogger.getCommonLogger("CacheClient").infof("secretName:{} refresh success", secretName);
    }

    private void addRefreshTask(String secretName, Runnable runnable) throws CacheSecretException {
        CacheSecretInfo cacheSecretInfo = this.cacheSecretStoreStrategy.getCacheSecretInfo(secretName);
        long executeTime = this.refreshSecretStrategy.parseNextExecuteTime(cacheSecretInfo);
        if (executeTime <= 0L) {
            long refreshTimestamp = cacheSecretInfo.getRefreshTimestamp();
            executeTime = this.refreshSecretStrategy.getNextExecuteTime(secretName, this.secretTTLMap.getOrDefault(secretName, 3600000L), refreshTimestamp);
            executeTime = Math.max(executeTime, System.currentTimeMillis());
        }
        this.nextExecuteTimeMap.put(secretName, executeTime);
        ScheduledFuture<?> schedule = this.scheduledThreadPoolExecutor.schedule(runnable, executeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        this.scheduledFutureMap.put(secretName, schedule);
        CommonLogger.getCommonLogger("CacheClient").infof("secretName:{} addRefreshTask success", secretName);
    }

    private void removeRefreshTask(String secretName) throws InterruptedException {
        if (this.scheduledFutureMap.get(secretName) != null) {
            this.scheduledThreadPoolExecutor.remove((RunnableScheduledFuture)this.scheduledFutureMap.get(secretName));
        }
    }

    private boolean checkCacheSecretInfoIsValid(CacheSecretInfo cacheSecretInfo) {
        if (cacheSecretInfo != null && !this.judgeCacheExpire(cacheSecretInfo)) {
            return this.checkSecretValueIsEmpty(cacheSecretInfo);
        }
        return false;
    }

    private boolean checkSecretValueIsEmpty(CacheSecretInfo cacheSecretInfo) {
        SecretInfo secretInfo;
        return cacheSecretInfo != null && (secretInfo = cacheSecretInfo.getSecretInfo()) != null && !StringUtils.isEmpty((CharSequence)secretInfo.getSecretValue());
    }

    private boolean judgeServerException(ClientException e) {
        return BackoffUtils.judgeNeedBackoff(e);
    }

    private boolean judgeSkipRefreshException(CacheSecretException e) {
        return e.getCause() instanceof ClientException && !this.judgeServerException((ClientException)e.getCause()) && !"Forbidden.InDebtOverdue".equals(((ClientException)e.getCause()).getErrCode()) && !"Forbidden.InDebt".equals(((ClientException)e.getCause()).getErrCode());
    }

    @Override
    public void close() throws IOException {
        if (this.cacheSecretStoreStrategy != null) {
            this.cacheSecretStoreStrategy.close();
        }
        if (this.refreshSecretStrategy != null) {
            this.refreshSecretStrategy.close();
        }
        if (this.secretClient != null) {
            this.secretClient.close();
        }
        if (this.cacheHook != null) {
            this.cacheHook.close();
        }
        if (!this.scheduledThreadPoolExecutor.isShutdown()) {
            this.scheduledThreadPoolExecutor.shutdownNow();
        }
    }

    class MonitorRefreshSecretTask
    implements Runnable {
        MonitorRefreshSecretTask() {
        }

        @Override
        public void run() {
            while (true) {
                Set secretNames;
                if ((secretNames = SecretCacheClient.this.nextExecuteTimeMap.keySet()) != null && !secretNames.isEmpty()) {
                    for (String secretName : secretNames) {
                        try {
                            CacheSecretInfo cacheSecretInfo = SecretCacheClient.this.cacheSecretStoreStrategy.getCacheSecretInfo(secretName);
                            if (cacheSecretInfo != null) {
                                Long nextExecuteTime = (Long)SecretCacheClient.this.nextExecuteTimeMap.get(secretName);
                                if (System.currentTimeMillis() <= nextExecuteTime + 600000L) continue;
                                CommonLogger.getCommonLogger("CacheClient").warnf("MonitorRefreshSecretTask secret is expired, secretName={}", secretName);
                                try {
                                    SecretCacheClient.this.refreshNow(secretName);
                                }
                                catch (Throwable e) {
                                    CommonLogger.getCommonLogger("CacheClient").errorf("MonitorRefreshSecretTask refreshNow error, secretName={}", secretName, e);
                                }
                                continue;
                            }
                            CommonLogger.getCommonLogger("CacheClient").warnf("MonitorRefreshSecretTask can not get cache secret, secretName={}", secretName);
                            try {
                                SecretCacheClient.this.refreshNow(secretName);
                            }
                            catch (Throwable e) {
                                CommonLogger.getCommonLogger("CacheClient").errorf("MonitorRefreshSecretTask refreshNow error, secretName={}", secretName, e);
                            }
                        }
                        catch (Throwable e) {
                            CommonLogger.getCommonLogger("CacheClient").errorf("MonitorRefreshSecretTask error, secretName={}", secretName, e);
                        }
                    }
                }
                try {
                    Thread.sleep(300000L);
                    continue;
                }
                catch (Throwable e) {
                    CommonLogger.getCommonLogger("CacheClient").errorf("MonitorRefreshSecretTask sleep error", e);
                    continue;
                }
                break;
            }
        }
    }

    class RefreshSecretTask
    implements Runnable {
        private final String secretName;

        public RefreshSecretTask(String secretName) {
            this.secretName = secretName;
        }

        @Override
        public void run() {
            try {
                SecretCacheClient.this.refresh(this.secretName, null);
            }
            catch (Throwable e) {
                CommonLogger.getCommonLogger("CacheClient").errorf("action:refreshSecretTask", e);
            }
            try {
                SecretCacheClient.this.addRefreshTask(this.secretName, this);
            }
            catch (Throwable e) {
                CommonLogger.getCommonLogger("CacheClient").errorf("action:addRefreshTask", e);
            }
        }
    }
}

