/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.bean;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.util.StringUtils;

public class SofaBeanNameGenerator {
    private static final String SERVICE_BEAN_NAME_PREFIX = "ServiceFactoryBean#";
    private static final String REFERENCE_BEAN_NAME_PREFIX = "ReferenceFactoryBean#";

    public static String generateSofaServiceBeanName(BeanDefinition definition) {
        String interfaceName = (String)definition.getPropertyValues().get("interfaceType");
        Class clazz = (Class)definition.getPropertyValues().get("interfaceClass");
        if (clazz != null) {
            interfaceName = clazz.getCanonicalName();
        }
        String uniqueId = (String)definition.getPropertyValues().get("uniqueId");
        return SofaBeanNameGenerator.generateSofaServiceBeanName(interfaceName, uniqueId);
    }

    public static String generateSofaServiceBeanName(Class<?> interfaceType, String uniqueId) {
        return SofaBeanNameGenerator.generateSofaServiceBeanName(interfaceType.getCanonicalName(), uniqueId);
    }

    public static String generateSofaServiceBeanName(String interfaceName, String uniqueId) {
        if (StringUtils.isEmpty((Object)uniqueId)) {
            return SERVICE_BEAN_NAME_PREFIX + interfaceName;
        }
        return SERVICE_BEAN_NAME_PREFIX + interfaceName + ":" + uniqueId;
    }

    public static String generateSofaReferenceBeanName(Class<?> interfaceType, String uniqueId) {
        if (StringUtils.isEmpty((Object)uniqueId)) {
            return REFERENCE_BEAN_NAME_PREFIX + interfaceType.getCanonicalName();
        }
        return REFERENCE_BEAN_NAME_PREFIX + interfaceType.getCanonicalName() + ":" + uniqueId;
    }
}

