/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.client;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.client.ServiceClient;
import com.alipay.sofa.runtime.api.client.param.BindingParam;
import com.alipay.sofa.runtime.api.client.param.ServiceParam;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.service.component.impl.ServiceImpl;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import java.util.Collection;
import java.util.Map;

public class ServiceClientImpl
implements ServiceClient {
    private SofaRuntimeContext sofaRuntimeContext;
    private BindingConverterFactory bindingConverterFactory;
    private BindingAdapterFactory bindingAdapterFactory;

    public ServiceClientImpl(SofaRuntimeContext sofaRuntimeContext, BindingConverterFactory bindingConverterFactory, BindingAdapterFactory bindingAdapterFactory) {
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.bindingConverterFactory = bindingConverterFactory;
        this.bindingAdapterFactory = bindingAdapterFactory;
    }

    @Override
    public void service(ServiceParam serviceParam) {
        DefaultImplementation implementation = new DefaultImplementation();
        implementation.setTarget(serviceParam.getInstance());
        if (serviceParam.getInterfaceType() == null) {
            throw new ServiceRuntimeException("Interface type is null. Interface type is required while publish a service.");
        }
        ServiceImpl service = new ServiceImpl(serviceParam.getUniqueId(), serviceParam.getInterfaceType(), InterfaceMode.api, serviceParam.getInstance(), null);
        for (BindingParam bindingParam : serviceParam.getBindingParams()) {
            BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(bindingParam.getBindingType());
            if (bindingConverter == null) {
                throw new ServiceRuntimeException("Can not found binding converter for binding type " + bindingParam.getBindingType());
            }
            BindingConverterContext bindingConverterContext = new BindingConverterContext();
            bindingConverterContext.setInBinding(false);
            bindingConverterContext.setAppName(this.sofaRuntimeContext.getAppName());
            bindingConverterContext.setAppClassLoader(this.sofaRuntimeContext.getAppClassLoader());
            Object binding = bindingConverter.convert(bindingParam, bindingConverterContext);
            service.addBinding(binding);
        }
        boolean hasJvmBinding = false;
        for (Binding binding : service.getBindings()) {
            if (!binding.getBindingType().equals(JvmBinding.JVM_BINDING_TYPE)) continue;
            hasJvmBinding = true;
            break;
        }
        if (!hasJvmBinding) {
            service.addBinding(new JvmBinding());
        }
        ServiceComponent componentInfo = new ServiceComponent(implementation, service, this.bindingAdapterFactory, this.sofaRuntimeContext);
        this.sofaRuntimeContext.getComponentManager().register(componentInfo);
    }

    @Override
    public void removeService(Class<?> interfaceClass, int millisecondsToDelay) {
        this.removeService(interfaceClass, "", millisecondsToDelay);
    }

    @Override
    public void removeService(Class<?> interfaceClass, String uniqueId, int millisecondsToDelay) {
        if (millisecondsToDelay < 0) {
            throw new IllegalArgumentException("Argument delay must be a positive integer or zero.");
        }
        Collection<ComponentInfo> serviceComponents = this.sofaRuntimeContext.getComponentManager().getComponentInfosByType(ServiceComponent.SERVICE_COMPONENT_TYPE);
        for (ComponentInfo componentInfo : serviceComponents) {
            ServiceComponent serviceComponent;
            if (!(componentInfo instanceof ServiceComponent) || (serviceComponent = (ServiceComponent)componentInfo).getService().getInterfaceType() != interfaceClass || !serviceComponent.getService().getUniqueId().equals(uniqueId)) continue;
            Map<String, Property> properties = serviceComponent.getProperties();
            Property property = new Property();
            property.setValue(millisecondsToDelay);
            properties.put("UNREGISTER_DELAY_MILLISECONDS", property);
            this.sofaRuntimeContext.getComponentManager().unregister(serviceComponent);
        }
    }
}

